/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Switch;

public class TARDISBlockSetters {
    public static void setBlock(Location l, BlockData bd) {
        if (l != null) {
            Block b = l.getBlock();
            switch (bd.getMaterial()) {
                case CAKE: {
                    BlockData blockData = Material.LEVER.createBlockData();
                    Switch lever = (Switch)blockData;
                    lever.setAttachedFace(FaceAttachable.AttachedFace.FLOOR);
                    lever.setFacing(BlockFace.SOUTH);
                    b.setBlockData((BlockData)lever);
                    break;
                }
                case SPAWNER: {
                    BlockData blockData = Material.OAK_BUTTON.createBlockData();
                    Switch button = (Switch)blockData;
                    button.setAttachedFace(FaceAttachable.AttachedFace.WALL);
                    button.setFacing(BlockFace.SOUTH);
                    b.setBlockData((BlockData)button);
                    break;
                }
                default: {
                    b.setBlockData(bd);
                }
            }
            if (TARDIS.plugin.getBlockLogger().isLogging()) {
                TARDIS.plugin.getBlockLogger().logPlacement(b);
            }
        }
    }

    public static void setBlock(World w, int x, int y, int z, BlockData data) {
        if (w != null) {
            Block b = w.getBlockAt(x, y, z);
            switch (data.getMaterial()) {
                case CAKE: {
                    BlockData blockData = Material.LEVER.createBlockData();
                    Switch lever = (Switch)blockData;
                    lever.setAttachedFace(FaceAttachable.AttachedFace.FLOOR);
                    lever.setFacing(BlockFace.SOUTH);
                    b.setBlockData((BlockData)lever);
                    break;
                }
                case SPAWNER: {
                    BlockData oak = Material.OAK_BUTTON.createBlockData();
                    Switch button = (Switch)oak;
                    button.setAttachedFace(FaceAttachable.AttachedFace.WALL);
                    button.setFacing(BlockFace.SOUTH);
                    b.setBlockData((BlockData)button);
                    break;
                }
                default: {
                    b.setBlockData(data);
                }
            }
            if (TARDIS.plugin.getBlockLogger().isLogging()) {
                TARDIS.plugin.getBlockLogger().logPlacement(b);
            }
        }
    }

    public static void setBlock(World w, int x, int y, int z, Material material) {
        if (w != null) {
            Block b = w.getBlockAt(x, y, z);
            BlockData blockData = material.createBlockData();
            switch (material) {
                case CAKE: {
                    blockData = Material.LEVER.createBlockData();
                    Switch lever = (Switch)blockData;
                    lever.setAttachedFace(FaceAttachable.AttachedFace.FLOOR);
                    lever.setFacing(BlockFace.SOUTH);
                    b.setBlockData((BlockData)lever);
                    break;
                }
                case SPAWNER: {
                    blockData = Material.OAK_BUTTON.createBlockData();
                    Switch button = (Switch)blockData;
                    button.setAttachedFace(FaceAttachable.AttachedFace.WALL);
                    button.setFacing(BlockFace.SOUTH);
                    b.setBlockData((BlockData)button);
                    break;
                }
                default: {
                    b.setBlockData(blockData);
                }
            }
            if (TARDIS.plugin.getBlockLogger().isLogging()) {
                TARDIS.plugin.getBlockLogger().logPlacement(b);
            }
        }
    }

    public static void rememberBlock(World w, int x, int y, int z, int id) {
        Block b = w.getBlockAt(x, y, z);
        String l = b.getLocation().toString();
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("tardis_id", id);
        set.put("location", l);
        set.put("data", b.getBlockData().getAsString());
        set.put("police_box", 1);
        TARDIS.plugin.getQueryFactory().doInsert("blocks", set);
        TARDIS.plugin.getGeneralKeeper().getProtectBlockMap().put(l, id);
    }

    public static void rememberBlock(Block b, int id) {
        String l = b.getLocation().toString();
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("tardis_id", id);
        set.put("location", l);
        set.put("data", b.getBlockData().getAsString());
        set.put("police_box", 1);
        TARDIS.plugin.getQueryFactory().doInsert("blocks", set);
        TARDIS.plugin.getGeneralKeeper().getProtectBlockMap().put(l, id);
    }

    public static void setBlockAndRemember(World w, int x, int y, int z, BlockData data, int id) {
        Block b = w.getBlockAt(x, y, z);
        String l = b.getLocation().toString();
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("tardis_id", id);
        set.put("location", l);
        set.put("data", b.getBlockData().getAsString());
        set.put("police_box", 1);
        TARDIS.plugin.getQueryFactory().doInsert("blocks", set);
        TARDIS.plugin.getGeneralKeeper().getProtectBlockMap().put(l, id);
        b.setBlockData(data);
    }

    public static void setBlockAndRemember(World w, int x, int y, int z, Material material, int id) {
        Block b = w.getBlockAt(x, y, z);
        String l = b.getLocation().toString();
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("tardis_id", id);
        set.put("location", l);
        set.put("data", b.getBlockData().getAsString());
        set.put("police_box", 1);
        TARDIS.plugin.getQueryFactory().doInsert("blocks", set);
        TARDIS.plugin.getGeneralKeeper().getProtectBlockMap().put(l, id);
        b.setBlockData(material.createBlockData());
    }

    public static void setBlockAndRemember(Block b, Material m, int id, int type) {
        String l = b.getLocation().toString();
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("tardis_id", id);
        set.put("location", l);
        BlockData data = b.getBlockData();
        set.put("data", data.getAsString());
        set.put("police_box", type);
        TARDIS.plugin.getQueryFactory().doInsert("blocks", set);
        b.setBlockData(m.createBlockData(), true);
    }

    public static void setUnderDoorBlock(World w, int x, int y, int z, int id, boolean portal) {
        Block b;
        BlockData blockData;
        List ids = TARDIS.plugin.getBlocksConfig().getStringList("under_door_blocks");
        if (portal) {
            ids.remove("CHEST");
        }
        if (ids.contains((blockData = (b = w.getBlockAt(x, y, z)).getBlockData()).getMaterial().toString())) {
            String l = b.getLocation().toString();
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("tardis_id", id);
            set.put("location", l);
            set.put("data", blockData.getAsString());
            set.put("police_box", 1);
            TARDIS.plugin.getQueryFactory().doInsert("blocks", set);
            TARDIS.plugin.getGeneralKeeper().getProtectBlockMap().put(l, id);
            b.setBlockData(Material.BARRIER.createBlockData());
        }
    }
}

