/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.universaltranslator;

import io.papermc.paper.event.player.AsyncChatEvent;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.universaltranslator.Language;
import me.eccentric_nz.TARDIS.universaltranslator.LingvaTranslate;
import me.eccentric_nz.TARDIS.universaltranslator.TranslateData;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TARDISTranslateChatListener
implements Listener {
    private final TARDIS plugin;

    public TARDISTranslateChatListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onTranslateChat(AsyncChatEvent event) {
        if (this.plugin.getTrackerKeeper().getTranslators().isEmpty()) {
            return;
        }
        String sender = event.getPlayer().getName();
        for (Audience audience : event.viewers()) {
            TranslateData data;
            if (!(audience instanceof Player)) continue;
            Player p = (Player)audience;
            if (!this.plugin.getTrackerKeeper().getTranslators().containsKey(p.getUniqueId()) || (data = this.plugin.getTrackerKeeper().getTranslators().get(p.getUniqueId())) == null || !data.getSender().equals(sender)) continue;
            this.translateChat(p, data.getFrom(), data.getTo(), ComponentUtils.stripColour(event.message()));
        }
    }

    private void translateChat(Player p, Language from, Language to, String message) {
        try {
            LingvaTranslate translate = new LingvaTranslate(this.plugin, from.getCode(), to.getCode(), message);
            translate.fetchAsync((hasResult, translated) -> {
                if (hasResult) {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().message((CommandSender)p, TardisModule.TRANSLATOR, translated.getTranslated()), 2L);
                }
            });
        }
        catch (Exception ex) {
            this.plugin.debug("Could not get translation! " + ex.getMessage());
        }
    }
}

