/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.travel.Check;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISCaveFinder {
    private final TARDIS plugin;
    private final List<BlockFace> directions = new ArrayList<BlockFace>(List.of(BlockFace.EAST, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH));

    public TARDISCaveFinder(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static int getLowestAirBlock(World w, int x, int y, int z) {
        while (w.getBlockAt(x, y, z).getRelative(BlockFace.DOWN).getType().isAir() && y > w.getMinHeight() + 7) {
            --y;
        }
        return y;
    }

    public static boolean worldCheck(World w) {
        if (w.getGenerator() != null && !w.getGenerator().shouldGenerateCaves()) {
            return false;
        }
        Location spawn = w.getSpawnLocation();
        int y = w.getHighestBlockYAt(spawn);
        if (y < w.getMinHeight() + 15) {
            return false;
        }
        if (w.getBlockAt(spawn.getBlockX(), w.getMinHeight(), spawn.getBlockZ()).getType().isAir()) {
            return false;
        }
        spawn.setZ((double)(spawn.getBlockZ() - 100));
        int ny = w.getHighestBlockYAt(spawn);
        spawn.setX((double)(spawn.getBlockX() + 100));
        int ey = w.getHighestBlockYAt(spawn);
        spawn.setZ((double)(spawn.getBlockZ() + 100));
        int sy = w.getHighestBlockYAt(spawn);
        return y != ny || y != ey || y != sy;
    }

    public Location searchCave(Player p, int id) {
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (rsc.resultSet()) {
            boolean hoth;
            Current current = rsc.getCurrent();
            World w = current.location().getWorld();
            int startx = current.location().getBlockX();
            int startz = current.location().getBlockZ();
            COMPASS d = current.direction();
            boolean bl = hoth = w.getGenerator() != null && w.getGenerator().getClass().getName().contains("hothgenerator");
            if (!(w.getEnvironment().equals((Object)World.Environment.NETHER) || w.getEnvironment().equals((Object)World.Environment.THE_END) || hoth)) {
                if (TARDISCaveFinder.worldCheck(w)) {
                    int plusx = startx + 2048;
                    int plusz = startz + 2048;
                    int minusx = startx - 2048;
                    int minusz = startz - 2048;
                    int step = 32;
                    Collections.shuffle(this.directions);
                    block5: for (int i = 0; i < 4; ++i) {
                        switch (this.directions.get(i)) {
                            case EAST: {
                                Check chk;
                                this.plugin.getMessenger().sendStatus(p, "LOOK_E");
                                for (int east = startx; east < plusx; east += step) {
                                    chk = this.isThereRoom(w, east, startz, d);
                                    if (!chk.isSafe()) continue;
                                    this.plugin.getMessenger().sendStatus(p, "CAVE_E");
                                    return new Location(w, (double)east, (double)chk.getY(), (double)startz);
                                }
                                continue block5;
                            }
                            case SOUTH: {
                                Check chk;
                                this.plugin.getMessenger().sendStatus(p, "LOOK_S");
                                for (int south = startz; south < plusz; south += step) {
                                    chk = this.isThereRoom(w, startx, south, d);
                                    if (!chk.isSafe()) continue;
                                    this.plugin.getMessenger().sendStatus(p, "CAVE_S");
                                    return new Location(w, (double)startx, (double)chk.getY(), (double)south);
                                }
                                continue block5;
                            }
                            case WEST: {
                                Check chk;
                                this.plugin.getMessenger().sendStatus(p, "LOOK_W");
                                for (int west = startx; west > minusx; west -= step) {
                                    chk = this.isThereRoom(w, west, startz, d);
                                    if (!chk.isSafe()) continue;
                                    this.plugin.getMessenger().sendStatus(p, "CAVE_W");
                                    return new Location(w, (double)west, (double)chk.getY(), (double)startz);
                                }
                                continue block5;
                            }
                            default: {
                                Check chk;
                                this.plugin.getMessenger().sendStatus(p, "LOOK_N");
                                for (int north = startz; north > minusz; north -= step) {
                                    chk = this.isThereRoom(w, startx, north, d);
                                    if (!chk.isSafe()) continue;
                                    this.plugin.getMessenger().sendStatus(p, "CAVE_N");
                                    return new Location(w, (double)startx, (double)chk.getY(), (double)north);
                                }
                            }
                        }
                    }
                }
            } else {
                String env = w.getGenerator().getClass().getName().contains("hothgenerator") ? "Hoth World System" : w.getEnvironment().toString();
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "CAVE_NO_TRAVEL", env);
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
        }
        return null;
    }

    private Check isThereRoom(World w, int x, int z, COMPASS d) {
        Check ret = new Check();
        ret.setSafe(false);
        for (int y = 35; y > w.getMinHeight() + 14; --y) {
            int yy;
            if (!w.getBlockAt(x, y, z).getType().isAir() || (yy = TARDISCaveFinder.getLowestAirBlock(w, x, y, z)) > y - 3 || !Tag.BASE_STONE_OVERWORLD.isTagged((Keyed)w.getBlockAt(x - 1, yy - 1, z - 1).getType()) || !w.getBlockAt(x - 1, yy, z - 1).getType().isAir() || !w.getBlockAt(x - 1, yy, z).getType().isAir() || !w.getBlockAt(x - 1, yy, z + 1).getType().isAir() || !w.getBlockAt(x, yy, z - 1).getType().isAir() || !w.getBlockAt(x, yy, z + 1).getType().isAir() || !w.getBlockAt(x + 1, yy, z - 1).getType().isAir() || !w.getBlockAt(x + 1, yy, z).getType().isAir() || !w.getBlockAt(x + 1, yy, z + 1).getType().isAir()) continue;
            boolean safe = false;
            switch (d) {
                case NORTH: {
                    if (!w.getBlockAt(x - 1, yy, z + 2).getType().isAir() || !w.getBlockAt(x, yy, z + 2).getType().isAir() || !w.getBlockAt(x + 1, yy, z + 2).getType().isAir()) break;
                    safe = true;
                    break;
                }
                case WEST: {
                    if (!w.getBlockAt(x + 2, yy, z - 1).getType().isAir() || !w.getBlockAt(x + 2, yy, z).getType().isAir() || !w.getBlockAt(x + 2, yy, z + 1).getType().isAir()) break;
                    safe = true;
                    break;
                }
                case SOUTH: {
                    if (!w.getBlockAt(x - 1, yy, z - 2).getType().isAir() || !w.getBlockAt(x, yy, z - 2).getType().isAir() || !w.getBlockAt(x + 1, yy, z - 2).getType().isAir()) break;
                    safe = true;
                    break;
                }
                default: {
                    if (!w.getBlockAt(x - 2, yy, z - 1).getType().isAir() || !w.getBlockAt(x - 2, yy, z).getType().isAir() || !w.getBlockAt(x - 2, yy, z + 1).getType().isAir()) break;
                    safe = true;
                }
            }
            if (!safe) continue;
            ret.setSafe(true);
            ret.setY(yy);
        }
        return ret;
    }
}

