/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.control.TARDISScanner;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class TARDISSonicScanner {
    public static void scan(TARDIS plugin, Location scan_loc, Player player) {
        HashMap scannedEntities = new HashMap();
        ArrayList playernames = new ArrayList();
        TARDISScanner.getNearbyEntities(scan_loc, 16).forEach(k -> {
            EntityType et = k.getType();
            if (TARDISConstants.ENTITY_TYPES.contains(et)) {
                boolean visible = true;
                if (et.equals((Object)EntityType.PLAYER)) {
                    Player entPlayer = (Player)k;
                    if (player.canSee(entPlayer)) {
                        playernames.add(entPlayer.getName());
                    } else {
                        visible = false;
                    }
                }
                if (TARDIS.plugin.getConfig().getBoolean("modules.weeping_angels")) {
                    EntityEquipment ee;
                    if ((et.equals((Object)EntityType.SKELETON) || et.equals((Object)EntityType.ZOMBIE) || et.equals((Object)EntityType.ZOMBIFIED_PIGLIN)) && (ee = ((LivingEntity)k).getEquipment()).getHelmet() != null) {
                        switch (ee.getHelmet().getType()) {
                            case BAKED_POTATO: {
                                et = EntityType.EGG;
                                break;
                            }
                            case BOOK: {
                                et = EntityType.END_CRYSTAL;
                                break;
                            }
                            case CRIMSON_BUTTON: {
                                et = EntityType.BLOCK_DISPLAY;
                                break;
                            }
                            case FEATHER: {
                                et = EntityType.JUNGLE_BOAT;
                                break;
                            }
                            case IRON_INGOT: {
                                et = EntityType.AREA_EFFECT_CLOUD;
                                break;
                            }
                            case KELP: {
                                et = EntityType.EXPERIENCE_BOTTLE;
                                break;
                            }
                            case MANGROVE_PROPAGULE: {
                                et = EntityType.SMALL_FIREBALL;
                                break;
                            }
                            case NETHERITE_SCRAP: {
                                et = EntityType.GLOW_ITEM_FRAME;
                                break;
                            }
                            case PAINTING: {
                                et = EntityType.FISHING_BOBBER;
                                break;
                            }
                            case POTATO: {
                                et = EntityType.FIREWORK_ROCKET;
                                break;
                            }
                            case PUFFERFISH: {
                                et = EntityType.INTERACTION;
                                break;
                            }
                            case RED_CANDLE: {
                                et = EntityType.TEXT_DISPLAY;
                                break;
                            }
                            case SLIME_BALL: {
                                et = EntityType.LLAMA_SPIT;
                                break;
                            }
                            case SNOWBALL: {
                                et = EntityType.SNOWBALL;
                                break;
                            }
                            case SPIDER_EYE: {
                                et = EntityType.ITEM_DISPLAY;
                                break;
                            }
                            case STONE_BUTTON: {
                                et = EntityType.DRAGON_FIREBALL;
                                break;
                            }
                            case SUGAR: {
                                et = EntityType.FALLING_BLOCK;
                                break;
                            }
                            case TURTLE_EGG: {
                                et = EntityType.ARROW;
                                break;
                            }
                        }
                    }
                    if (et.equals((Object)EntityType.SKELETON) && !k.getPassengers().isEmpty() && k.getPassengers().getFirst() != null && ((Entity)k.getPassengers().getFirst()).getType().equals((Object)EntityType.GUARDIAN)) {
                        et = EntityType.SPLASH_POTION;
                    }
                    if (et.equals((Object)EntityType.ARMOR_STAND) && (ee = ((ArmorStand)k).getEquipment()).getHelmet() != null) {
                        switch (ee.getHelmet().getType()) {
                            case YELLOW_DYE: {
                                et = EntityType.SHULKER_BULLET;
                                break;
                            }
                            case BONE: {
                                et = EntityType.EVOKER_FANGS;
                                break;
                            }
                            case ROTTEN_FLESH: {
                                et = EntityType.ITEM_FRAME;
                                break;
                            }
                            case GUNPOWDER: {
                                et = EntityType.ITEM;
                                break;
                            }
                        }
                    }
                }
                Integer entity_count = scannedEntities.getOrDefault(et, 0);
                if (visible) {
                    scannedEntities.put(et, entity_count + 1);
                }
            }
        });
        long time = scan_loc.getWorld().getTime();
        String daynight = TARDISStaticUtils.getTime(time);
        String worldname = !plugin.getPlanetsConfig().getBoolean("planets." + scan_loc.getWorld().getName() + ".enabled") && plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? plugin.getMVHelper().getAlias(scan_loc.getWorld()) : TARDISAliasResolver.getWorldAlias(scan_loc.getWorld());
        String wn = worldname;
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SONIC_SCAN");
        BukkitScheduler bsched = plugin.getServer().getScheduler();
        bsched.scheduleSyncDelayedTask((Plugin)plugin, () -> {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_WORLD", wn);
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SONIC_COORDS", scan_loc.getBlockX() + ":" + scan_loc.getBlockY() + ":" + scan_loc.getBlockZ());
        }, 20L);
        String biome = scan_loc.getBlock().getBiome().getKey().value().toUpperCase(Locale.ROOT);
        bsched.scheduleSyncDelayedTask((Plugin)plugin, () -> plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_TYPE", biome), 40L);
        bsched.scheduleSyncDelayedTask((Plugin)plugin, () -> plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_TIME", daynight + " / " + time), 60L);
        String weather = switch (biome) {
            case "BADLANDS", "BADLANDS_PLATEAU", "DESERT", "DESERT_HILLS", "DESERT_LAKES", "ERODED_BADLANDS", "MODIFIED_BADLANDS_PLATEAU", "MODIFIED_WOODED_BADLANDS_PLATEAU", "SAVANNA", "SAVANNA_PLATEAU", "SHATTERED_SAVANNA", "SHATTERED_SAVANNA_PLATEAU", "WOODED_BADLANDS_PLATEAU" -> plugin.getLanguage().getString("WEATHER_DRY");
            case "FROZEN_OCEAN", "FROZEN_RIVER", "ICE_SPIKES", "SNOWY_BEACH", "SNOWY_MOUNTAINS", "SNOWY_TAIGA", "SNOWY_TAIGA_HILLS", "SNOWY_TAIGA_MOUNTAINS", "SNOWY_TUNDRA" -> {
                if (scan_loc.getWorld().hasStorm()) {
                    yield plugin.getLanguage().getString("WEATHER_SNOW");
                }
                yield plugin.getLanguage().getString("WEATHER_COLD");
            }
            default -> scan_loc.getWorld().hasStorm() ? plugin.getLanguage().getString("WEATHER_RAIN") : plugin.getLanguage().getString("WEATHER_CLEAR");
        };
        bsched.scheduleSyncDelayedTask((Plugin)plugin, () -> plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_WEATHER", weather), 80L);
        bsched.scheduleSyncDelayedTask((Plugin)plugin, () -> plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_HUMIDITY", String.format("%.2f", scan_loc.getBlock().getHumidity())), 100L);
        bsched.scheduleSyncDelayedTask((Plugin)plugin, () -> plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_TEMP", String.format("%.2f", scan_loc.getBlock().getTemperature())), 120L);
        bsched.scheduleSyncDelayedTask((Plugin)plugin, () -> {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_ENTS");
            if (!scannedEntities.isEmpty()) {
                scannedEntities.forEach((ent, value) -> {
                    Object message = "";
                    StringBuilder buf = new StringBuilder();
                    if (ent.equals((Object)EntityType.PLAYER) && !playernames.isEmpty()) {
                        playernames.forEach(p -> buf.append(", ").append((String)p));
                        message = " (" + buf.substring(2) + ")";
                    }
                    switch (ent) {
                        case AREA_EFFECT_CLOUD: {
                            player.sendMessage("    Cyberman: " + value);
                            break;
                        }
                        case ARROW: {
                            player.sendMessage("    Slitheen: " + value);
                            break;
                        }
                        case BLOCK_DISPLAY: {
                            player.sendMessage("    Davros: " + value);
                            break;
                        }
                        case JUNGLE_BOAT: {
                            player.sendMessage("    Silurian: " + value);
                            break;
                        }
                        case DRAGON_FIREBALL: {
                            player.sendMessage("    Weeping Angel: " + value);
                            break;
                        }
                        case ITEM: {
                            player.sendMessage("    Toclafane: " + value);
                            break;
                        }
                        case EGG: {
                            player.sendMessage("    Strax: " + value);
                            break;
                        }
                        case END_CRYSTAL: {
                            player.sendMessage("    Vashta Nerada: " + value);
                            break;
                        }
                        case EVOKER_FANGS: {
                            player.sendMessage("    K9: " + value);
                            break;
                        }
                        case FALLING_BLOCK: {
                            player.sendMessage("    Empty Child: " + value);
                            break;
                        }
                        case FIREWORK_ROCKET: {
                            player.sendMessage("    Sontaran: " + value);
                            break;
                        }
                        case FISHING_BOBBER: {
                            player.sendMessage("    Zygon: " + value);
                            break;
                        }
                        case GLOW_ITEM_FRAME: {
                            player.sendMessage("    Mire: " + value);
                            break;
                        }
                        case INTERACTION: {
                            player.sendMessage("    Hath: " + value);
                            break;
                        }
                        case ITEM_DISPLAY: {
                            player.sendMessage("    Racnoss: " + value);
                            break;
                        }
                        case ITEM_FRAME: {
                            player.sendMessage("    Ood: " + value);
                            break;
                        }
                        case LLAMA_SPIT: {
                            player.sendMessage("    Dalek: " + value);
                            break;
                        }
                        case SHULKER_BULLET: {
                            player.sendMessage("    Judoon: " + value);
                            break;
                        }
                        case SMALL_FIREBALL: {
                            player.sendMessage("    Dalek Sec: " + value);
                            break;
                        }
                        case SNOWBALL: {
                            player.sendMessage("    Ice Warrior: " + value);
                            break;
                        }
                        case SPLASH_POTION: {
                            player.sendMessage("    Silent: " + value);
                            break;
                        }
                        case TEXT_DISPLAY: {
                            player.sendMessage("    Headless Monk: " + value);
                            break;
                        }
                        case EXPERIENCE_BOTTLE: {
                            player.sendMessage("    Sea Devil: " + value);
                            break;
                        }
                        default: {
                            if (ent == EntityType.ARMOR_STAND) break;
                            player.sendMessage("    " + String.valueOf(ent) + ": " + value + (String)message);
                        }
                    }
                });
                scannedEntities.clear();
            } else {
                plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCAN_NONE");
            }
        }, 140L);
    }
}

