/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.siegemode;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TARDISTIPSData;
import me.eccentric_nz.TARDIS.database.data.Archive;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.desktop.TARDISUpgradeData;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.TARDIS.schematic.archive.ResultSetArchiveByUse;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class TARDISSiegeWallFloorRunnable
implements Runnable {
    private final TARDIS plugin;
    private final UUID uuid;
    private final TARDISUpgradeData tud;
    private final boolean toSiege;
    private boolean running;
    private int level = 0;
    private int row = 0;
    private int h;
    private int w;
    private int c;
    private int startx;
    private int starty;
    private int startz;
    private World world;
    private Material wall_type;
    private Material floor_type;
    private Material siege_wall_type;
    private Material siege_floor_type;
    private Player player;
    private int taskID;
    private Archive archive;

    TARDISSiegeWallFloorRunnable(TARDIS plugin, UUID uuid, TARDISUpgradeData tud, boolean toSiege) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.tud = tud;
        this.toSiege = toSiege;
    }

    @Override
    public void run() {
        if (!this.running) {
            JsonObject obj;
            if (this.tud.getSchematic().getPermission().equals("archive")) {
                ResultSetArchiveByUse rs = new ResultSetArchiveByUse(this.plugin, this.uuid.toString(), 1);
                if (rs.resultSet()) {
                    this.archive = rs.getArchive();
                } else {
                    Player cp = this.plugin.getServer().getPlayer(this.uuid);
                    this.plugin.getMessenger().send((CommandSender)cp, TardisModule.TARDIS, "ARCHIVE_NOT_FOUND");
                    this.plugin.getServer().getScheduler().cancelTask(this.taskID);
                    return;
                }
            }
            if (this.archive == null) {
                obj = TARDISSchematicGZip.getObject(this.plugin, "consoles", this.tud.getSchematic().getPermission(), this.tud.getSchematic().isCustom());
                if (obj == null) {
                    this.plugin.getServer().getScheduler().cancelTask(this.taskID);
                    return;
                }
            } else {
                obj = this.archive.getJSON();
            }
            JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
            this.h = dimensions.get("height").getAsInt();
            this.w = dimensions.get("width").getAsInt();
            this.c = dimensions.get("length").getAsInt();
            HashMap<String, Object> wheret = new HashMap<String, Object>();
            wheret.put("uuid", this.uuid.toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
            if (!rs.resultSet()) {
                HashMap<String, Object> wherea = new HashMap<String, Object>();
                wherea.put("uuid", this.uuid.toString());
                int amount = this.plugin.getArtronConfig().getInt("upgrades." + this.tud.getSchematic().getPermission());
                this.plugin.getQueryFactory().alterEnergyLevel("tardis", amount, wherea, this.player);
            }
            Tardis tardis = rs.getTardis();
            int slot = tardis.getTIPS();
            int id = tardis.getTardisId();
            if (slot != -1000001) {
                TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(this.plugin);
                TARDISTIPSData pos = tintpos.getTIPSData(slot);
                this.startx = pos.getCentreX();
                this.startz = pos.getCentreZ();
            } else {
                int[] gsl = this.plugin.getLocationUtils().getStartLocation(id);
                this.startx = gsl[0];
                this.startz = gsl[2];
            }
            this.starty = this.tud.getSchematic().getStartY();
            this.world = TARDISStaticLocationGetters.getWorldFromSplitString(tardis.getChunk());
            this.wall_type = Material.valueOf((String)this.tud.getWall());
            this.floor_type = Material.valueOf((String)this.tud.getFloor());
            this.siege_wall_type = Material.valueOf((String)this.tud.getSiegeWall());
            this.siege_floor_type = Material.valueOf((String)this.tud.getSiegeFloor());
            this.running = true;
            this.player = this.plugin.getServer().getPlayer(this.uuid);
            this.plugin.getTrackerKeeper().getUpgrades().remove(this.uuid);
        }
        if (this.level == this.h - 1 && this.row == this.w - 1) {
            this.plugin.getServer().getScheduler().cancelTask(this.taskID);
            this.taskID = 0;
        } else {
            for (int col = 0; col < this.c; ++col) {
                Material type;
                Material to_floor_type;
                int x = this.startx + this.row;
                int y = this.starty + this.level;
                int z = this.startz + col;
                Block bb = this.world.getBlockAt(x, y, z);
                Material compare_type = bb.getType();
                Material to_wall_type = this.toSiege ? this.wall_type : this.siege_wall_type;
                Material material = to_floor_type = this.toSiege ? this.floor_type : this.siege_floor_type;
                if (compare_type.equals((Object)to_wall_type)) {
                    type = this.toSiege ? this.siege_wall_type : this.wall_type;
                    TARDISBlockSetters.setBlock(this.world, x, y, z, type);
                }
                if (!compare_type.equals((Object)to_floor_type)) continue;
                type = this.toSiege ? this.siege_floor_type : this.floor_type;
                TARDISBlockSetters.setBlock(this.world, x, y, z, type);
            }
            if (this.row < this.w) {
                ++this.row;
            }
            if (this.row == this.w && this.level < this.h) {
                this.row = 0;
                ++this.level;
            }
        }
    }

    public void setTaskID(int taskID) {
        this.taskID = taskID;
    }
}

