/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.setters;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.rooms.TARDISPainting;
import me.eccentric_nz.TARDIS.schematic.getters.DataPackPainting;
import org.bukkit.Art;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Painting;

public class PaintingSetter {
    public static void setArt(JsonArray paintings, World world, int x, int y, int z) {
        for (int i = 0; i < paintings.size(); ++i) {
            Location pl;
            JsonObject painting = paintings.get(i).getAsJsonObject();
            JsonObject rel = painting.get("rel_location").getAsJsonObject();
            int px = rel.get("x").getAsInt();
            int py = rel.get("y").getAsInt();
            int pz = rel.get("z").getAsInt();
            BlockFace facing = BlockFace.valueOf((String)painting.get("facing").getAsString());
            String which = painting.get("art").getAsString();
            Art art = null;
            if (which.contains(":")) {
                pl = TARDISPainting.calculatePosition(which.split(":")[1], facing, new Location(world, (double)(x + px), (double)(y + py), (double)(z + pz)));
            } else {
                art = (Art)RegistryAccess.registryAccess().getRegistry(RegistryKey.PAINTING_VARIANT).get(new NamespacedKey("minecraft", which.toLowerCase(Locale.ROOT)));
                pl = TARDISPainting.calculatePosition(art, facing, new Location(world, (double)(x + px), (double)(y + py), (double)(z + pz)));
            }
            try {
                Painting ent = (Painting)world.spawnEntity(pl, EntityType.PAINTING);
                ent.teleport(pl);
                ent.setFacingDirection(facing, true);
                if (art != null) {
                    ent.setArt(art, true);
                    continue;
                }
                DataPackPainting.setCustomVariant(ent, which);
                continue;
            }
            catch (IllegalArgumentException e) {
                TARDIS.plugin.debug("Invalid painting location!" + String.valueOf(pl));
            }
        }
    }
}

