/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.happy;

import io.papermc.paper.entity.Leashable;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.mobfarming.HappyGhastUtils;
import me.eccentric_nz.TARDIS.mobfarming.TARDISBoat;
import me.eccentric_nz.TARDIS.mobfarming.TARDISHappyGhast;
import me.eccentric_nz.TARDIS.move.TARDISDoorListener;
import me.eccentric_nz.TARDIS.travel.TARDISDoorLocation;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Switch;
import org.bukkit.entity.Boat;
import org.bukkit.entity.ChestBoat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.Player;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class HappyGhastRelease {
    private final TARDIS plugin;

    public HappyGhastRelease(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void undock(Block block, int id, Player player) {
        Switch lever;
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Switch && !(lever = (Switch)blockData).isPowered()) {
            return;
        }
        for (Entity e : block.getWorld().getNearbyEntities(block.getLocation(), 10.0, 10.0, 10.0)) {
            if (!(e instanceof HappyGhast)) continue;
            HappyGhast ghast = (HappyGhast)e;
            TARDISHappyGhast happy = new TARDISHappyGhast();
            happy.setAge(ghast.getAge());
            happy.setBaby(!ghast.isAdult());
            happy.setName(ComponentUtils.stripColour(ghast.customName()));
            happy.setHealth(ghast.getHealth());
            happy.setHarness(ghast.getEquipment().getItem(EquipmentSlot.BODY));
            happy.setHome((Location)ghast.getMemory(MemoryKey.HOME));
            Leashable leashed = HappyGhastUtils.getLeashed((Entity)ghast);
            if (leashed instanceof Boat) {
                Boat boat = (Boat)leashed;
                TARDISBoat tb = new TARDISBoat();
                tb.setType(boat.getType());
                if (boat instanceof ChestBoat) {
                    ChestBoat chested = (ChestBoat)boat;
                    tb.setItems(chested.getInventory().getContents());
                }
                happy.setBoat(tb);
                boat.remove();
            }
            if (leashed != null) {
                leashed.setLeashHolder(null);
            }
            List passengers = ghast.getPassengers();
            TARDISDoorLocation dl = TARDISDoorListener.getDoor(0, id);
            Location l = dl.getL();
            switch (dl.getD()) {
                case NORTH: {
                    l.setZ(l.getZ() + 4.5);
                    l.setYaw(0.0f);
                    break;
                }
                case WEST: {
                    l.setX(l.getX() + 4.5);
                    l.setYaw(270.0f);
                    break;
                }
                case SOUTH: {
                    l.setZ(l.getZ() - 4.5);
                    l.setYaw(180.0f);
                    break;
                }
                default: {
                    l.setX(l.getX() - 4.5);
                    l.setYaw(90.0f);
                }
            }
            HappyGhast skies = (HappyGhast)l.getWorld().spawnEntity(l, EntityType.HAPPY_GHAST);
            skies.setAge(happy.getAge());
            if (happy.isBaby()) {
                skies.setBaby();
            }
            if (happy.getHarness() != null) {
                skies.getEquipment().setItem(EquipmentSlot.BODY, happy.getHarness());
            }
            skies.setHealth(happy.getHealth());
            String name = happy.getName();
            if (name != null && !name.isEmpty()) {
                skies.customName((Component)Component.text((String)name));
            }
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                for (Entity p : passengers) {
                    ghast.removePassenger(p);
                    p.teleport(skies.getLocation().clone().add(0.0, 4.0, 0.0));
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ghast.addPassenger(p), 2L);
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("uuid", p.getUniqueId().toString());
                    this.plugin.getQueryFactory().doDelete("travellers", where);
                }
            }, 3L);
            ghast.remove();
            if (happy.getBoat() != null) {
                TARDISBoat tb = happy.getBoat();
                Entity boat = l.getWorld().spawnEntity(l, tb.getType());
                if (boat instanceof ChestBoat) {
                    ChestBoat chested = (ChestBoat)boat;
                    chested.getInventory().setContents(tb.getItems());
                }
                Leashable leashable = (Leashable)boat;
                leashable.setLeashHolder((Entity)skies);
            }
            skies.setMemory(MemoryKey.HOME, (Object)happy.getHome());
            skies.setRemoveWhenFarAway(false);
        }
    }
}

