/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.particles;

import com.mojang.datafixers.util.Pair;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.data.ParticleData;
import me.eccentric_nz.TARDIS.particles.ParticleAdaptive;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.util.Vector;

public class TARDISParticleRunnable
implements Runnable {
    protected final TARDIS plugin;
    protected final boolean adaptive;
    protected double t = 0.0;
    protected BlockData adaptiveData = null;
    protected int taskID;

    public TARDISParticleRunnable(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        Pair<Boolean, Integer> pair = ParticleAdaptive.isAdaptive(plugin, uuid);
        this.adaptive = (Boolean)pair.getFirst();
        if (this.adaptive) {
            this.adaptiveData = ParticleAdaptive.getAdaptiveData(plugin, (Integer)pair.getSecond());
        }
    }

    public void setTaskID(int taskID) {
        this.taskID = taskID;
    }

    public void spawnParticle(Location location, int count, ParticleData data) {
        Particle particle = data.getEffect().getParticle();
        if (particle == Particle.FLAME && location.getWorld().getEnvironment() == World.Environment.NETHER) {
            particle = Particle.SOUL_FIRE_FLAME;
        }
        if (this.adaptive) {
            particle = Particle.BLOCK;
        }
        double speed = data.getSpeed();
        switch (particle) {
            case BLOCK: {
                BlockData block = this.adaptive && this.adaptiveData != null ? this.adaptiveData : data.getBlockData();
                location.getWorld().spawnParticle(particle, location, count, speed, speed, speed, speed, (Object)block, false);
                break;
            }
            case DUST: {
                Color colour = data.getColour();
                Particle.DustOptions options = new Particle.DustOptions(colour, 1.0f);
                location.getWorld().spawnParticle(particle, location, count, speed, speed, speed, speed, (Object)options, false);
                break;
            }
            case SHRIEK: {
                location.getWorld().spawnParticle(particle, location, count, speed, speed, speed, speed, (Object)1, false);
                break;
            }
            case SCULK_CHARGE: {
                location.getWorld().spawnParticle(particle, location, count, speed, speed, speed, speed, (Object)Float.valueOf(1.0f), false);
                break;
            }
            case ENTITY_EFFECT: 
            case TINTED_LEAVES: {
                Color colour = data.getColour();
                location.getWorld().spawnParticle(particle, location, count, 0.0, 0.0, 0.0, 0.0, (Object)colour, false);
                break;
            }
            default: {
                location.getWorld().spawnParticle(particle, location, count, speed, speed, speed, speed, null, false);
            }
        }
    }

    public void spawnParticle(Particle particle, Location location, int count, double speed, Color colour) {
        if (particle == Particle.DUST) {
            Particle.DustOptions options = new Particle.DustOptions(colour, 1.0f);
            location.getWorld().spawnParticle(particle, location, count, speed, speed, speed, speed, (Object)options, false);
        }
        if (particle == Particle.ENTITY_EFFECT) {
            location.getWorld().spawnParticle(particle, location, count, 0.0, 0.0, 0.0, 0.0, (Object)colour, false);
        }
    }

    public Vector[] generateVectors(boolean full) {
        Vector[] vectors = new Vector[10];
        for (int i = 0; i < 10; ++i) {
            double vx = TARDISConstants.RANDOM.nextDouble(-1.0, 1.0);
            double vy = TARDISConstants.RANDOM.nextDouble(full ? -1.0 : 0.0, 1.0);
            double vz = TARDISConstants.RANDOM.nextDouble(-1.0, 1.0);
            vectors[i] = new Vector(vx, vy, vz);
        }
        return vectors;
    }

    public void cancel() {
        this.plugin.getServer().getScheduler().cancelTask(this.taskID);
        this.taskID = 0;
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

