/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.mapping;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.TARDISData;
import me.eccentric_nz.TARDIS.files.TARDISFileCopier;
import me.eccentric_nz.TARDIS.mapping.TARDISGetter;
import me.eccentric_nz.TARDIS.mapping.TARDISMapper;
import me.eccentric_nz.TARDIS.mapping.TARDISServerListener;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import xyz.jpenilla.squaremap.api.BukkitAdapter;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.api.marker.Icon;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;

public class TARDISSquareMap
implements TARDISMapper {
    public static final Key TARDIS_ICON_KEY = Key.key((String)"tardis_icon");
    private static final Key TARDIS_LAYER_KEY = Key.key((String)"tardis");
    private final TARDIS plugin;
    private final Map<WorldIdentifier, SquaremapTask> tasks = new HashMap<WorldIdentifier, SquaremapTask>();

    public TARDISSquareMap(TARDIS plugin) {
        this.plugin = plugin;
    }

    @Override
    public void disable() {
        this.tasks.values().forEach(SquaremapTask::disable);
        this.tasks.clear();
    }

    @Override
    public void enable() {
        Plugin squaremap = this.plugin.getPM().getPlugin("squaremap");
        this.plugin.getPM().registerEvents((Listener)new TARDISServerListener("squaremap", this), (Plugin)this.plugin);
        if (squaremap != null && squaremap.isEnabled()) {
            this.activate();
        }
    }

    @Override
    public void activate() {
        try {
            File icon = new File(this.plugin.getDataFolder(), "tardis.png");
            if (!icon.exists()) {
                TARDISFileCopier.copy("plugins/TARDIS/tardis.png", this.plugin.getResource("tardis.png"), true);
            }
            BufferedImage image = ImageIO.read(icon);
            SquaremapProvider.get().iconRegistry().register(TARDIS_ICON_KEY, (Object)image);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to register TARDIS icon", e);
        }
        this.updateMarkerSet(this.plugin.getConfig().getLong("mapping.update_period"));
    }

    @Override
    public void updateMarkerSet(long period) {
        for (MapWorld world : SquaremapProvider.get().mapWorlds()) {
            if (!this.plugin.getPlanetsConfig().getBoolean("planets." + world.identifier().value() + ".time_travel")) continue;
            SimpleLayerProvider provider = SimpleLayerProvider.builder((String)"TARDIS").showControls(true).defaultHidden(false).build();
            world.layerRegistry().register(TARDIS_LAYER_KEY, (Object)provider);
            SquaremapTask task = new SquaremapTask(world, provider, this.plugin);
            task.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, 20L * period);
            this.tasks.put(world.identifier(), task);
        }
    }

    private static class SquaremapTask
    extends BukkitRunnable {
        private final MapWorld world;
        private final SimpleLayerProvider provider;
        private final TARDIS plugin;
        private boolean stop;

        public SquaremapTask(MapWorld world, SimpleLayerProvider provider, TARDIS plugin) {
            this.world = world;
            this.provider = provider;
            this.plugin = plugin;
        }

        public void run() {
            if (this.stop) {
                this.cancel();
            }
            this.provider.clearMarkers();
            World bukkitWorld = BukkitAdapter.bukkitWorld((MapWorld)this.world);
            TARDISGetter getter = new TARDISGetter(this.plugin, bukkitWorld);
            getter.resultSetAsync(results -> {
                for (TARDISData data : results) {
                    this.handle(data.owner(), data.location());
                }
            });
        }

        private void handle(String name, Location location) {
            Icon icon = Marker.icon((Point)BukkitAdapter.point((Location)location), (Key)TARDIS_ICON_KEY, (int)16);
            String label = String.format("%s (TARDIS)", name);
            icon.markerOptions(MarkerOptions.builder().hoverTooltip(label));
            String markerid = "tardis_" + name;
            this.provider.addMarker(Key.of((String)markerid), (Marker)icon);
        }

        public void disable() {
            this.cancel();
            this.stop = true;
            this.provider.clearMarkers();
        }
    }
}

