/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.desktop.TARDISThemeProcessor;
import me.eccentric_nz.TARDIS.desktop.TARDISUpgradeData;
import me.eccentric_nz.TARDIS.desktop.TARDISWallListener;
import me.eccentric_nz.TARDIS.desktop.TARDISWallsInventory;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TARDISWallMenuListener
extends TARDISWallListener {
    private final TARDIS plugin;

    public TARDISWallMenuListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler
    public void onWallMenuOpen(InventoryOpenEvent event) {
        if (event.getInventory().getHolder(false) instanceof TARDISWallsInventory) {
            Player player = (Player)event.getPlayer();
            this.scroll.put(player.getUniqueId(), 0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onWallMenuClick(InventoryClickEvent event) {
        InventoryView view = event.getView();
        InventoryHolder holder = event.getInventory().getHolder(false);
        if (!(holder instanceof TARDISWallsInventory)) {
            return;
        }
        TARDISWallsInventory walls = (TARDISWallsInventory)holder;
        boolean isWall = walls.getTitle().equals("TARDIS Wall Menu");
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                this.plugin.debug("TARDISWallMenuListener");
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(true);
        switch (slot) {
            case 8: {
                if (this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scroll(view, (Integer)this.scroll.get(uuid) + 1, true, uuid);
                break;
            }
            case 17: {
                if (this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scroll(view, (Integer)this.scroll.get(uuid) - 1, false, uuid);
                break;
            }
            case 26: {
                String wall = this.getWallFloor(uuid, true);
                this.setWallFloorBlock(player, uuid, wall, isWall);
                break;
            }
            case 35: {
                String floor = this.getWallFloor(uuid, false);
                this.setWallFloorBlock(player, uuid, floor, isWall);
                break;
            }
            case 53: {
                this.close(player, true);
                break;
            }
            default: {
                ItemStack choice = view.getItem(slot);
                this.setWallFloorBlock(player, uuid, choice.getType().toString(), isWall);
            }
        }
    }

    private void setWallFloorBlock(Player p, UUID uuid, String str, boolean isWall) {
        TARDISUpgradeData tud = this.plugin.getTrackerKeeper().getUpgrades().get(uuid);
        if (isWall) {
            tud.setWall(str);
            this.floor(p);
        } else {
            tud.setFloor(str);
            this.close(p, false);
            new TARDISThemeProcessor(this.plugin, uuid).changeDesktop();
        }
        this.plugin.getTrackerKeeper().getUpgrades().put(uuid, tud);
    }

    private void floor(Player p) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> p.openInventory(new TARDISWallsInventory(this.plugin, "TARDIS Floor Menu").getInventory()), 1L);
    }
}

