/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.ARS.TARDISARSMethods;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Archive;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetARS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.desktop.TARDISBlockScannerData;
import me.eccentric_nz.TARDIS.desktop.TARDISDelavafier;
import me.eccentric_nz.TARDIS.desktop.TARDISFullThemeRunnable;
import me.eccentric_nz.TARDIS.desktop.TARDISThemeRunnable;
import me.eccentric_nz.TARDIS.desktop.TARDISUpgradeBlockScanner;
import me.eccentric_nz.TARDIS.desktop.TARDISUpgradeData;
import me.eccentric_nz.TARDIS.desktop.TARDISWallFloorRunnable;
import me.eccentric_nz.TARDIS.enumeration.ConsoleSize;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.TARDIS.schematic.archive.ArchiveReset;
import me.eccentric_nz.TARDIS.schematic.archive.ResultSetArchiveByUse;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISThemeProcessor {
    private final TARDIS plugin;
    private final UUID uuid;
    private Archive archive_next;

    public TARDISThemeProcessor(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void changeDesktop() {
        TARDISThemeRunnable ttr;
        boolean hasLava;
        ConsoleSize size_prev;
        int previousWidth;
        int previousHeight;
        ConsoleSize size_next;
        int nextWidth;
        int nextHeight;
        TARDISUpgradeData tud;
        block25: {
            JsonObject dimensions;
            block24: {
                JsonObject dimensions2;
                tud = this.plugin.getTrackerKeeper().getUpgrades().get(this.uuid);
                Player player = this.plugin.getServer().getPlayer(this.uuid);
                if (this.plugin.getHandlesConfig().getBoolean("enabled") && TARDISPermission.hasPermission(player, "tardis.handles")) {
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("uuid", this.uuid.toString());
                    ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
                    rs.resultSet();
                    Tardis tardis = rs.getTardis();
                    HashMap<String, Object> whereh = new HashMap<String, Object>();
                    whereh.put("type", 26);
                    whereh.put("tardis_id", tardis.getTardisId());
                    ResultSetControls rsc = new ResultSetControls(this.plugin, whereh, false);
                    if (rsc.resultSet()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPGRADE_REMOVE_HANDLES");
                        return;
                    }
                }
                if (tud.getPrevious().getPermission().equals("archive")) {
                    new ArchiveReset(this.plugin, this.uuid.toString(), 1, 2).resetUse();
                }
                if (tud.getSchematic().getPermission().equals("archive")) {
                    ResultSetArchiveByUse rs = new ResultSetArchiveByUse(this.plugin, this.uuid.toString(), 1);
                    if (rs.resultSet()) {
                        this.archive_next = rs.getArchive();
                        dimensions2 = this.archive_next.getJSON().get("dimensions").getAsJsonObject();
                        nextHeight = dimensions2.get("height").getAsInt();
                        nextWidth = dimensions2.get("width").getAsInt();
                        size_next = this.archive_next.getConsoleSize();
                        break block24;
                    } else {
                        Player cp = this.plugin.getServer().getPlayer(this.uuid);
                        this.plugin.getMessenger().send((CommandSender)cp, TardisModule.TARDIS, "ARCHIVE_NOT_FOUND");
                        new ArchiveReset(this.plugin, this.uuid.toString(), 1, 0).resetUse();
                        if (tud.getPrevious().getPermission().equals("archive")) {
                            new ArchiveReset(this.plugin, this.uuid.toString(), 2, 1).resetUse();
                        }
                        return;
                    }
                }
                JsonObject obj = TARDISSchematicGZip.getObject(this.plugin, "consoles", tud.getSchematic().getPermission(), tud.getSchematic().isCustom());
                if (obj == null) {
                    return;
                }
                dimensions2 = obj.get("dimensions").getAsJsonObject();
                nextHeight = dimensions2.get("height").getAsInt();
                nextWidth = dimensions2.get("width").getAsInt();
                size_next = tud.getSchematic().getConsoleSize();
            }
            if (tud.getPrevious().getPermission().equals("archive")) {
                ResultSetArchiveByUse rs = new ResultSetArchiveByUse(this.plugin, this.uuid.toString(), 2);
                if (rs.resultSet()) {
                    dimensions = rs.getArchive().getJSON().get("dimensions").getAsJsonObject();
                    previousHeight = dimensions.get("height").getAsInt();
                    previousWidth = dimensions.get("width").getAsInt();
                    size_prev = rs.getArchive().getConsoleSize();
                    break block25;
                } else {
                    Player cp = this.plugin.getServer().getPlayer(this.uuid);
                    this.plugin.getMessenger().send((CommandSender)cp, TardisModule.TARDIS, "ARCHIVE_NOT_FOUND");
                    if (tud.getSchematic().getPermission().equals("archive")) {
                        new ArchiveReset(this.plugin, this.uuid.toString(), 1, 0).resetUse();
                    }
                    new ArchiveReset(this.plugin, this.uuid.toString(), 2, 1).resetUse();
                    return;
                }
            }
            JsonObject obj = TARDISSchematicGZip.getObject(this.plugin, "consoles", tud.getPrevious().getPermission(), tud.getPrevious().isCustom());
            if (obj == null) {
                return;
            }
            dimensions = obj.get("dimensions").getAsJsonObject();
            previousHeight = dimensions.get("height").getAsInt();
            previousWidth = dimensions.get("width").getAsInt();
            size_prev = tud.getPrevious().getConsoleSize();
        }
        if (this.plugin.getConfig().getBoolean("desktop.check_blocks_before_upgrade")) {
            TARDISUpgradeBlockScanner scanner = new TARDISUpgradeBlockScanner(this.plugin, tud, this.uuid);
            TARDISBlockScannerData check = scanner.check();
            if (check == null) {
                return;
            }
            if (!check.allow()) {
                Player cp = this.plugin.getServer().getPlayer(this.uuid);
                this.plugin.getMessenger().send((CommandSender)cp, TardisModule.TARDIS, "UPGRADE_PERCENT_BLOCKS", "" + this.plugin.getConfig().getInt("desktop.block_change_percent"));
                this.plugin.getMessenger().send((CommandSender)cp, TardisModule.TARDIS, "UPGRADE_PERCENT_EXPLAIN", "" + check.getCount(), "" + check.getVolume(), "" + check.getChanged());
                this.plugin.getMessenger().send((CommandSender)cp, TardisModule.TARDIS, "UPGRADE_PERCENT_REASON");
                if (tud.getPrevious().getPermission().equals("archive")) {
                    if (tud.getSchematic().getPermission().equals("archive")) {
                        new ArchiveReset(this.plugin, this.uuid.toString(), 1, 0).resetUse();
                    }
                    new ArchiveReset(this.plugin, this.uuid.toString(), 2, 1).resetUse();
                }
                return;
            }
        }
        if ((nextWidth > previousWidth || nextHeight > previousHeight) && this.checkARSGrid(size_prev, size_next, this.uuid)) {
            this.plugin.getMessenger().send((CommandSender)this.plugin.getServer().getPlayer(this.uuid), TardisModule.TARDIS, "UPGRADE_ABORT_SPACE");
            this.plugin.getTrackerKeeper().getUpgrades().remove(this.uuid);
            if (tud.getSchematic().getPermission().equals("archive")) {
                new ArchiveReset(this.plugin, this.uuid.toString(), 1, 0).resetUse();
            }
            if (tud.getPrevious().getPermission().equals("archive")) {
                new ArchiveReset(this.plugin, this.uuid.toString(), 2, 1).resetUse();
            }
            return;
        }
        HashMap<String, Object> setp = new HashMap<String, Object>();
        setp.put("wall", tud.getWall());
        setp.put("floor", tud.getFloor());
        setp.put("lights", tud.getSchematic().getLights().toString());
        HashMap<String, Object> wherep = new HashMap<String, Object>();
        wherep.put("uuid", this.uuid.toString());
        this.plugin.getQueryFactory().doUpdate("player_prefs", setp, wherep);
        HashMap<String, Object> sett = new HashMap<String, Object>();
        sett.put("size", tud.getSchematic().getPermission().toUpperCase(Locale.ROOT));
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("uuid", this.uuid.toString());
        this.plugin.getQueryFactory().doUpdate("tardis", sett, wheret);
        HashMap<String, Object> wherea = new HashMap<String, Object>();
        wherea.put("uuid", this.uuid.toString());
        String config_path = this.archive_next != null ? "upgrades.archive." + this.archive_next.getConsoleSize().getConfigPath() : "upgrades." + tud.getSchematic().getPermission().toLowerCase(Locale.ROOT);
        int amount = this.plugin.getArtronConfig().getInt(config_path);
        boolean bl = hasLava = tud.getPrevious().getPermission().equals("master") || tud.getPrevious().getPermission().equals("delta");
        if (tud.getPrevious().equals(tud.getSchematic()) && this.archive_next == null) {
            amount = Math.round((float)this.plugin.getArtronConfig().getInt("just_wall_floor") / 100.0f * (float)amount);
            ttr = new TARDISWallFloorRunnable(this.plugin, this.uuid, tud);
        } else {
            if (hasLava) {
                new TARDISDelavafier(this.plugin, this.uuid).swap();
            }
            ttr = new TARDISFullThemeRunnable(this.plugin, this.uuid, tud);
        }
        this.plugin.getQueryFactory().alterEnergyLevel("tardis", -amount, wherea, this.plugin.getServer().getPlayer(this.uuid));
        long initial_delay = hasLava ? 45L : 5L;
        long delay = Math.round(20.0 / this.plugin.getConfig().getDouble("growth.room_speed"));
        int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)ttr, initial_delay, delay);
        ttr.setTaskID(task);
    }

    private boolean checkARSGrid(ConsoleSize prev, ConsoleSize next, UUID uuid) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetARS rs = new ResultSetARS(this.plugin, where);
        if (rs.resultSet()) {
            String json = rs.getJson();
            String[][][] grid = TARDISARSMethods.getGridFromJSON(json);
            switch (prev) {
                case SMALL: {
                    switch (next) {
                        case MEDIUM: {
                            return !grid[1][4][5].equals("STONE") || !grid[1][5][4].equals("STONE") || !grid[1][5][5].equals("STONE");
                        }
                        case TALL: {
                            return !grid[1][4][5].equals("STONE") || !grid[1][5][4].equals("STONE") || !grid[1][5][5].equals("STONE") || !grid[2][4][4].equals("STONE") || !grid[2][4][5].equals("STONE") || !grid[2][5][4].equals("STONE") || !grid[2][5][5].equals("STONE");
                        }
                        case WIDE: {
                            return !grid[1][4][5].equals("STONE") || !grid[1][4][6].equals("STONE") || !grid[1][5][4].equals("STONE") || !grid[1][5][5].equals("STONE") || !grid[1][5][6].equals("STONE") || !grid[1][6][4].equals("STONE") || !grid[1][6][5].equals("STONE") || !grid[1][6][6].equals("STONE");
                        }
                        case MASSIVE: {
                            return !grid[1][4][5].equals("STONE") || !grid[1][4][6].equals("STONE") || !grid[1][5][4].equals("STONE") || !grid[1][5][5].equals("STONE") || !grid[1][5][6].equals("STONE") || !grid[1][6][4].equals("STONE") || !grid[1][6][5].equals("STONE") || !grid[1][6][6].equals("STONE") || !grid[2][4][4].equals("STONE") || !grid[2][4][5].equals("STONE") || !grid[2][4][6].equals("STONE") || !grid[2][5][4].equals("STONE") || !grid[2][5][5].equals("STONE") || !grid[2][5][6].equals("STONE") || !grid[2][6][4].equals("STONE") || !grid[2][6][5].equals("STONE") || !grid[2][6][6].equals("STONE");
                        }
                    }
                    return false;
                }
                case MEDIUM: {
                    switch (next) {
                        case TALL: {
                            return !grid[2][4][4].equals("STONE") || !grid[2][4][5].equals("STONE") || !grid[2][5][4].equals("STONE") || !grid[2][5][5].equals("STONE");
                        }
                        case WIDE: {
                            return !grid[1][4][6].equals("STONE") || !grid[1][5][6].equals("STONE") || !grid[1][6][4].equals("STONE") || !grid[1][6][5].equals("STONE") || !grid[1][6][6].equals("STONE");
                        }
                        case MASSIVE: {
                            return !grid[1][4][6].equals("STONE") || !grid[1][5][6].equals("STONE") || !grid[1][6][4].equals("STONE") || !grid[1][6][5].equals("STONE") || !grid[1][6][6].equals("STONE") || !grid[2][4][4].equals("STONE") || !grid[2][4][5].equals("STONE") || !grid[2][4][6].equals("STONE") || !grid[2][5][4].equals("STONE") || !grid[2][5][5].equals("STONE") || !grid[2][5][6].equals("STONE") || !grid[2][6][4].equals("STONE") || !grid[2][6][5].equals("STONE") || !grid[2][6][6].equals("STONE");
                        }
                    }
                    return false;
                }
                case TALL: {
                    if (next == ConsoleSize.WIDE) {
                        return !grid[1][4][6].equals("STONE") || !grid[1][5][6].equals("STONE") || !grid[1][6][4].equals("STONE") || !grid[1][6][5].equals("STONE") || !grid[1][6][6].equals("STONE");
                    }
                    if (next != ConsoleSize.MASSIVE) break;
                    return !grid[1][4][6].equals("STONE") || !grid[1][5][6].equals("STONE") || !grid[1][6][4].equals("STONE") || !grid[1][6][5].equals("STONE") || !grid[1][6][6].equals("STONE") || !grid[2][4][6].equals("STONE") || !grid[2][5][6].equals("STONE") || !grid[2][6][4].equals("STONE") || !grid[2][6][5].equals("STONE") || !grid[2][6][6].equals("STONE");
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }
}

