/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.ProtectedBlock;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Location;

public class ResultSetFindProtected {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final List<ProtectedBlock> data = new ArrayList<ProtectedBlock>();

    public ResultSetFindProtected(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectedBlock> search(Location location, int range) {
        int maxX = location.getBlockX() + range;
        int minX = location.getBlockX() - range;
        int maxZ = location.getBlockZ() + range;
        int minZ = location.getBlockZ() - range;
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT b_id, location FROM " + this.prefix + "blocks WHERE location LIKE 'Location{world=CraftWorld{name=" + location.getWorld().getName() + "%'";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            rs = statement.executeQuery();
            while (rs.next()) {
                String loc = rs.getString("location");
                String[] bukkit = loc.split(",");
                String[] xPart = bukkit[1].split("=");
                String[] yPart = bukkit[2].split("=");
                String[] zPart = bukkit[3].split("=");
                int x = (int)TARDISNumberParsers.parseFloat(xPart[1]);
                int y = (int)TARDISNumberParsers.parseFloat(yPart[1]);
                int z = (int)TARDISNumberParsers.parseFloat(zPart[1]);
                if (x >= maxX || x <= minX || z >= maxZ || z <= minZ) continue;
                this.data.add(new ProtectedBlock(loc, x, y, z, rs.getInt("b_id")));
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for find protected! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing find protected! " + e.getMessage());
            }
        }
        return this.data;
    }
}

