/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISSaveIconCommand {
    private final TARDIS plugin;

    public TARDISSaveIconCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean changeIcon(CommandSender sender, String[] args) {
        Player player;
        Material material;
        if (args.length < 3) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return false;
        }
        try {
            material = Material.valueOf((String)args[2].toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "MATERIAL_NOT_VALID");
            return false;
        }
        String m = material.toString();
        if (args[0].equalsIgnoreCase("dimensionicon")) {
            if (!TARDISPermission.hasPermission(sender, "tardis.admin")) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                return true;
            }
            World world = TARDISAliasResolver.getWorldFromAlias(args[1]);
            if (world == null) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_WORLD");
                return false;
            }
            this.plugin.getPlanetsConfig().set("planets." + world.getName() + ".icon", (Object)m);
            try {
                this.plugin.getPlanetsConfig().save(new File(this.plugin.getDataFolder(), "planets.yml"));
            }
            catch (IOException ex) {
                this.plugin.debug("Could not save planets.yml, " + ex.getMessage());
            }
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "DIMENSION_ICON", m);
        } else if (sender instanceof Player && TARDISPermission.hasPermission(player = (Player)sender, "tardis.save")) {
            ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
            if (!rs.fromUUID(player.getUniqueId().toString())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return false;
            }
            int id = rs.getTardisId();
            HashMap<String, Object> whered = new HashMap<String, Object>();
            whered.put("dest_name", args[1]);
            whered.put("tardis_id", id);
            ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, whered, false);
            if (!rsd.resultSet()) {
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "SAVE_NOT_FOUND", "/tardis list saves", this.plugin);
                return false;
            }
            int destID = rsd.getDest_id();
            HashMap<String, Object> did = new HashMap<String, Object>();
            did.put("dest_id", destID);
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("icon", m);
            this.plugin.getQueryFactory().doUpdate("destinations", set, did);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DEST_ICON", m);
        }
        return true;
    }
}

