/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev.wiki;

import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.dev.wiki.PageBuilder;
import me.eccentric_nz.TARDIS.info.TARDISDescription;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class ShapedPageBuilder
extends PageBuilder {
    private final TARDIS plugin;

    public ShapedPageBuilder(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public boolean compile() {
        for (String key : this.plugin.getFigura().getShapedRecipes().keySet()) {
            this.plugin.debug(key);
            String data = this.formatShaped(key);
            if (data.isEmpty()) continue;
            this.save(TARDISStringUtils.toDashedLowercase(key), data);
        }
        return true;
    }

    private String formatShaped(String item) {
        String crafting = TARDISStringUtils.toLowercaseDashed(item);
        String easyIngredients = this.getIngredients(item);
        String hardIngredients = this.getIngredients(item);
        String easyTable = this.getShapedTable(item);
        String hardTable = this.getShapedTable(item);
        String desc = String.format("The %s is used to ", item);
        try {
            String info = TARDISStringUtils.toEnumUppercase(item) + "_INFO";
            TARDISDescription description = TARDISDescription.valueOf(info);
            desc = description.getDesc();
        }
        catch (IllegalArgumentException info) {
            // empty catch block
        }
        String PAGE = "---\nlayout: default\ntitle: %s\n---\n\nimport Recipe from \"@site/src/components/Recipe\";\n\n%s\n===================\n\n%s\n\n## Crafting\n\n`/trecipe %s`\n\n| Ingredients | Crafting recipe | Difficulty |\n| ----------- | --------------- | ------------- |\n| %s | <Recipe icons={%s} /> | easy |\n| %s | <Recipe icons={%s} /> | hard |\n";
        return String.format(PAGE, item, item, desc, crafting, easyIngredients, easyTable, hardIngredients, hardTable);
    }

    private String getIngredients(String item) {
        StringBuilder ingredientBuilder = new StringBuilder();
        String prefix = "";
        for (Map.Entry map : this.plugin.getFigura().getShapedRecipes().get(item).getChoiceMap().entrySet()) {
            RecipeChoice choice = (RecipeChoice)map.getValue();
            String link = this.getLink(choice);
            ingredientBuilder.append(prefix);
            prefix = "<br/>";
            ingredientBuilder.append(link);
        }
        return ingredientBuilder.toString();
    }

    private String getShapedTable(String item) {
        String[] shape;
        StringBuilder tableBuilder = new StringBuilder("[");
        ShapedRecipe shapedRecipe = this.plugin.getFigura().getShapedRecipes().get(item);
        Map choices = shapedRecipe.getChoiceMap();
        for (String row : shape = shapedRecipe.getShape()) {
            block9: for (int i = 0; i < row.length(); ++i) {
                Character c = Character.valueOf(row.charAt(i));
                switch (c.charValue()) {
                    case ',': {
                        continue block9;
                    }
                    case ' ': {
                        tableBuilder.append("'air',");
                        continue block9;
                    }
                    default: {
                        String dashed = "";
                        RecipeChoice choice = (RecipeChoice)choices.get(c);
                        if (choice instanceof RecipeChoice.MaterialChoice) {
                            RecipeChoice.MaterialChoice mat = (RecipeChoice.MaterialChoice)choice;
                            dashed = TARDISStringUtils.toLowercaseDashed(TARDISStringUtils.capitalise(((Material)mat.getChoices().getFirst()).toString()));
                        }
                        if (choice instanceof RecipeChoice.ExactChoice) {
                            RecipeChoice.ExactChoice exact = (RecipeChoice.ExactChoice)choice;
                            ItemStack is = exact.getItemStack();
                            switch (is.getType()) {
                                case POTION: {
                                    PotionMeta pm = (PotionMeta)is.getItemMeta();
                                    String potion = pm.getBasePotionType().name();
                                    dashed = TARDISStringUtils.toLowercaseDashed("Potion of " + TARDISStringUtils.capitalise(potion));
                                    break;
                                }
                                case ENCHANTED_BOOK: {
                                    EnchantmentStorageMeta bm = (EnchantmentStorageMeta)is.getItemMeta();
                                    String enchant = bm.getEnchants().keySet().stream().findFirst().toString();
                                    String cap = TARDISStringUtils.capitalise(enchant);
                                    dashed = TARDISStringUtils.toLowercaseDashed("Enchanted Book of " + cap);
                                    break;
                                }
                                default: {
                                    ItemMeta im = is.getItemMeta();
                                    dashed = TARDISStringUtils.toLowercaseDashed(ComponentUtils.stripColour(im.displayName()));
                                }
                            }
                        }
                        tableBuilder.append("'").append(dashed).append("'").append(",");
                    }
                }
            }
        }
        String result = TARDISStringUtils.toLowercaseDashed(item);
        tableBuilder.append("'").append(result).append("'").append("]");
        return tableBuilder.toString();
    }
}

