/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISBuildData;
import me.eccentric_nz.TARDIS.builders.utility.TARDISSeedBlockProcessor;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.TARDISWalls;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISCreateCommand {
    private final TARDIS plugin;

    public TARDISCreateCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean buildTARDIS(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player admin = (Player)sender;
            if (args.length < 3) {
                return false;
            }
            Player player = Bukkit.getPlayer((String)args[1]);
            if (player == null) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
                return true;
            }
            String seed = args[2].toUpperCase(Locale.ROOT);
            if (!(!Desktops.getBY_NAMES().containsKey(seed) || seed.equals("SMALL") || seed.equals("MEDIUM") || seed.equals("TALL") || seed.equals("ARCHIVE"))) {
                Schematic schematic = Desktops.getBY_NAMES().get(seed);
                Material wallMaterial = Material.ORANGE_WOOL;
                Material floorMaterial = Material.LIGHT_GRAY_WOOL;
                if (args.length > 3) {
                    try {
                        wallMaterial = Material.valueOf((String)args[3].toUpperCase(Locale.ROOT));
                        if (!TARDISWalls.BLOCKS.contains(wallMaterial)) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WALL_NOT_VALID", args[3]);
                            TARDISWalls.BLOCKS.forEach(w -> sender.sendMessage(w.toString()));
                            return true;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "SEED_MAT_NOT_VALID", args[3]);
                        return true;
                    }
                }
                if (args.length > 4) {
                    try {
                        floorMaterial = Material.valueOf((String)args[4].toUpperCase(Locale.ROOT));
                        if (!TARDISWalls.BLOCKS.contains(floorMaterial)) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WALL_NOT_VALID", args[4]);
                            TARDISWalls.BLOCKS.forEach(w -> sender.sendMessage(w.toString()));
                            return true;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "SEED_MAT_NOT_VALID", args[4]);
                        return true;
                    }
                }
                Location target = admin.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 16).getRelative(BlockFace.UP).getLocation();
                TARDISBuildData data = new TARDISBuildData();
                data.setSchematic(schematic);
                data.setWallType(wallMaterial);
                data.setFloorType(floorMaterial);
                return new TARDISSeedBlockProcessor(this.plugin).processBlock(data, target, player);
            }
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_SEED");
            return true;
        }
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
        return true;
    }
}

