/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.utils;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.ChameleonVariant;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class SidratOpens {
    private final TARDIS plugin;
    private final NamespacedKey[] opening = new NamespacedKey[]{ChameleonVariant.SIDRAT_25.getKey(), ChameleonVariant.SIDRAT_50.getKey(), ChameleonVariant.SIDRAT_75.getKey(), ChameleonVariant.SIDRAT_OPEN.getKey()};
    private final NamespacedKey[] closing = new NamespacedKey[]{ChameleonVariant.SIDRAT_75.getKey(), ChameleonVariant.SIDRAT_50.getKey(), ChameleonVariant.SIDRAT_25.getKey(), ChameleonVariant.SIDRAT_CLOSED.getKey()};
    private final BukkitScheduler scheduler;

    public SidratOpens(TARDIS plugin) {
        this.plugin = plugin;
        this.scheduler = this.plugin.getServer().getScheduler();
    }

    public void animate(ArmorStand stand, boolean open) {
        Location location = stand.getLocation();
        while (!location.getChunk().isLoaded()) {
            location.getChunk().load();
        }
        EntityEquipment ee = stand.getEquipment();
        ItemStack is = ee.getHelmet();
        ItemMeta im = is.getItemMeta();
        long delay = 5L;
        for (int i = 0; i < 4; ++i) {
            NamespacedKey model;
            String sound;
            if (open) {
                sound = "sidrat_open";
                model = this.opening[i];
            } else {
                sound = "sidrat_close";
                model = this.closing[i];
            }
            TARDISSounds.playTARDISSound(stand.getLocation(), sound);
            this.scheduler.scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                im.setItemModel(model);
                is.setItemMeta(im);
                ee.setHelmet(is, true);
            }, delay * (long)i);
        }
    }
}

