/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.arch;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.arch.TARDISArchDisguise;
import me.eccentric_nz.TARDIS.arch.TARDISArchInventory;
import me.eccentric_nz.TARDIS.arch.TARDISArchLibsDisguise;
import me.eccentric_nz.TARDIS.arch.TARDISArchPersister;
import me.eccentric_nz.TARDIS.arch.TARDISRandomName;
import me.eccentric_nz.TARDIS.arch.TARDISWatchData;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISArchCommand {
    private final TARDIS plugin;

    public TARDISArchCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean getTime(Player player) {
        long now;
        UUID uuid = player.getUniqueId();
        if (!this.plugin.getTrackerKeeper().getJohnSmith().containsKey(uuid)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCH_NOT_VALID");
            return true;
        }
        long time = this.plugin.getTrackerKeeper().getJohnSmith().get(uuid).getTime();
        long diff = time - (now = System.currentTimeMillis());
        if (diff > 0L) {
            String sub0 = String.format("%d", diff / 60000L % 60L);
            String sub1 = String.format("%d", diff / 1000L % 60L);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCH_TIME", sub0, sub1);
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCH_FREE");
        }
        return true;
    }

    public boolean whois(CommandSender sender, String[] args) {
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            if (!ComponentUtils.stripColour(p.playerListName()).equalsIgnoreCase(args[1])) continue;
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARCH_PLAYER", p.getName());
            return true;
        }
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
        return true;
    }

    public boolean force(CommandSender sender, String[] args) {
        if (args[2].length() < 2) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return true;
        }
        Player player = this.plugin.getServer().getPlayer(args[1]);
        if (player == null) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
            return true;
        }
        UUID uuid = player.getUniqueId();
        boolean inv = this.plugin.getConfig().getBoolean("arch.switch_inventory");
        if (!this.plugin.getTrackerKeeper().getJohnSmith().containsKey(uuid)) {
            String name = TARDISRandomName.name();
            long time = System.currentTimeMillis() + this.plugin.getConfig().getLong("arch.min_time") * 60000L;
            TARDISWatchData twd = new TARDISWatchData(name, time);
            this.plugin.getTrackerKeeper().getJohnSmith().put(uuid, twd);
            if (this.plugin.isDisguisesOnServer()) {
                TARDISArchLibsDisguise.undisguise(player);
            } else {
                TARDISArchDisguise.undisguise(player);
            }
            player.getWorld().strikeLightningEffect(player.getLocation());
            double mh = player.getAttribute(Attribute.MAX_HEALTH).getValue();
            player.setHealth(mh / 10.0);
            if (inv) {
                new TARDISArchInventory().switchInventories(player, 0);
            }
            if (this.plugin.isDisguisesOnServer()) {
                TARDISArchLibsDisguise.disguise(player, name);
            } else {
                TARDISArchDisguise.disguise(player, name);
            }
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                TextComponent component = Component.text((String)name);
                player.displayName((Component)component);
                player.playerListName((Component)component);
            }, 5L);
        } else {
            if (this.plugin.isDisguisesOnServer()) {
                TARDISArchLibsDisguise.undisguise(player);
            } else {
                TARDISArchDisguise.undisguise(player);
            }
            if (inv) {
                new TARDISArchInventory().switchInventories(player, 1);
            }
            player.getWorld().strikeLightningEffect(player.getLocation());
            this.plugin.getTrackerKeeper().getJohnSmith().remove(uuid);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                TextComponent component = Component.text((String)player.getName());
                player.displayName((Component)component);
                player.playerListName((Component)component);
            }, 5L);
            new TARDISArchPersister(this.plugin).removeArch(uuid);
        }
        return true;
    }
}

