/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.api;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.TARDISRandomLocation;
import me.eccentric_nz.TARDIS.api.WorldAndRange;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class TARDISRandomOverworld
extends TARDISRandomLocation {
    private final TARDIS plugin;
    private final Parameters param;
    private final List<World> worlds;
    private Location dest;

    TARDISRandomOverworld(TARDIS plugin, List<String> list, Parameters param) {
        super(plugin);
        this.worlds = this.getWorlds(list);
        this.plugin = plugin;
        this.param = param;
    }

    public Location getlocation() {
        WorldAndRange war = this.getWorldandRange(this.worlds);
        for (int n = 0; n < this.plugin.getConfig().getInt("travel.random_attempts"); ++n) {
            int randX = TARDISConstants.RANDOM.nextInt(war.getRangeX());
            int randZ = TARDISConstants.RANDOM.nextInt(war.getRangeZ());
            int x = war.getMinX() + randX;
            int z = war.getMinZ() + randZ;
            Location tmp = new Location(war.getWorld(), (double)x, 64.0, (double)z);
            while (!war.getWorld().getChunkAt(tmp).isLoaded()) {
                war.getWorld().getChunkAt(tmp).load();
            }
            if (this.param.spaceTardis()) {
                if (!this.safeOverworld(war.getWorld(), x, z, this.param.getCompass())) continue;
                if (!this.dest.getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.WATER) || !TARDISStaticUtils.isOceanBiome(this.dest.getBlock().getBiome()) || !this.safeSubmarine(this.dest, this.param.getCompass(), this.param.getPlayer())) break;
                break;
            }
            int highest = TARDISStaticLocationGetters.getHighestYin3x3(war.getWorld(), x, z);
            Location chk = new Location(war.getWorld(), (double)x, (double)highest, (double)z);
            if (!this.plugin.getPluginRespect().getRespect(chk, this.param)) continue;
            return chk;
        }
        return this.dest;
    }

    private boolean safeOverworld(World world, int wherex, int wherez, COMPASS d) {
        int count;
        boolean safe = false;
        int highest = TARDISStaticLocationGetters.getHighestYin3x3(world, wherex, wherez);
        if (highest > 3) {
            Block currentBlock = world.getBlockAt(wherex, highest, wherez);
            if (TARDISConstants.GOOD_MATERIALS.contains(currentBlock.getType())) {
                currentBlock = currentBlock.getRelative(BlockFace.DOWN);
            }
            Location overworld = currentBlock.getLocation();
            if (this.plugin.getPluginRespect().getRespect(overworld, this.param)) {
                while (!world.getChunkAt(overworld).isLoaded()) {
                    world.getChunkAt(overworld).load();
                }
                int[] gsl = TARDISTimeTravel.getStartLocation(overworld, d);
                int startx = gsl[0];
                int resetx = gsl[1];
                int starty = overworld.getBlockY() + 1;
                int startz = gsl[2];
                int resetz = gsl[3];
                count = TARDISTimeTravel.safeLocation(startx, starty, startz, resetx, resetz, world, d);
            } else {
                count = 1;
            }
        } else {
            count = 1;
        }
        if (count == 0) {
            this.dest = new Location(world, (double)wherex, (double)highest, (double)wherez);
            safe = true;
        }
        return safe;
    }

    private boolean safeSubmarine(Location l, COMPASS d, Player p) {
        boolean safe = false;
        int count = 0;
        Block block = l.getBlock();
        while ((block = block.getRelative(BlockFace.DOWN)).getType().equals((Object)Material.WATER) || block.getType().equals((Object)Material.ICE)) {
        }
        Location loc = block.getRelative(BlockFace.UP).getLocation();
        for (int n = 0; n < 5; ++n) {
            int rowcount;
            int[] s = TARDISTimeTravel.getStartLocation(loc, d);
            int starty = loc.getBlockY();
            int colcount = switch (d) {
                case COMPASS.EAST, COMPASS.WEST -> {
                    rowcount = 3;
                    yield 4;
                }
                default -> {
                    rowcount = 4;
                    yield 3;
                }
            };
            for (int level = starty; level < starty + 4; ++level) {
                for (int row = s[0]; row < s[0] + rowcount; ++row) {
                    for (int col = s[2]; col < s[2] + colcount; ++col) {
                        Material mat = loc.getWorld().getBlockAt(row, level, col).getType();
                        if (TARDISConstants.GOOD_WATER.contains(mat)) continue;
                        ++count;
                    }
                }
            }
            if (count == 0) {
                safe = true;
                HashMap<String, Object> wherep = new HashMap<String, Object>();
                wherep.put("uuid", p.getUniqueId().toString());
                ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherep, false);
                if (rst.resultSet()) {
                    this.plugin.getTrackerKeeper().getSubmarine().add(rst.getTardis_id());
                }
                this.dest = loc;
                break;
            }
            loc.setY(loc.getY() + 1.0);
        }
        return safe;
    }
}

