/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS;

import me.eccentric_nz.TARDIS.ARS.ARSConverter;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.chameleon.construct.ConstructsConverter;
import me.eccentric_nz.TARDIS.database.converters.TARDISBindConverter;
import me.eccentric_nz.TARDIS.database.converters.TARDISControlsConverter;
import me.eccentric_nz.TARDIS.database.converters.TARDISFarmingConverter;
import me.eccentric_nz.TARDIS.database.converters.TARDISGrassConverter;
import me.eccentric_nz.TARDIS.database.converters.TARDISLegacyConverter;
import me.eccentric_nz.TARDIS.database.converters.TARDISMaterialIDConverter;
import me.eccentric_nz.TARDIS.database.converters.TARDISSaveIconUpdate;
import me.eccentric_nz.TARDIS.database.converters.TARDISWallConverter;
import me.eccentric_nz.TARDIS.database.converters.TARDISWallSignConverter;
import me.eccentric_nz.TARDIS.doors.TARDISInteractionDoorUpdater;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.files.TARDISAllInOneConfigConverter;
import me.eccentric_nz.TARDIS.rooms.eye.EyePopulator;

public class TARDISConversions {
    private final TARDIS plugin;
    private int conversions = 0;

    public TARDISConversions(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void convert() {
        if (!(this.plugin.getConfig().getBoolean("conversions.condenser_materials") && this.plugin.getConfig().getBoolean("conversions.player_prefs_materials") && this.plugin.getConfig().getBoolean("conversions.block_materials"))) {
            TARDISMaterialIDConverter tmic = new TARDISMaterialIDConverter(this.plugin);
            tmic.checkCondenserData();
            tmic.checkPlayerPrefsData();
            tmic.checkBlockData();
            new TARDISFarmingConverter(this.plugin).update();
        }
        if (!this.plugin.getConfig().getBoolean("conversions.block_wall_signs")) {
            new TARDISWallSignConverter(this.plugin).convertSignBlocks();
            this.plugin.getConfig().set("conversions.block_wall_signs", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.short_grass")) {
            new TARDISGrassConverter(this.plugin).checkBlockData();
            this.plugin.getConfig().set("conversions.short_grass", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.eyes")) {
            new EyePopulator(this.plugin).insert();
            this.plugin.getConfig().set("conversions.eyes", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.ars_materials")) {
            new ARSConverter(this.plugin).convertARS();
            this.plugin.getConfig().set("conversions.ars_materials", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.constructs")) {
            new ConstructsConverter(this.plugin).convertConstructs();
            this.plugin.getConfig().set("conversions.constructs", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.controls")) {
            new TARDISControlsConverter(this.plugin).update();
            this.plugin.getConfig().set("conversions.controls", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.bind")) {
            new TARDISBindConverter(this.plugin).update();
            this.plugin.getConfig().set("conversions.bind", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.icons")) {
            new TARDISSaveIconUpdate(this.plugin).addIcons();
            this.plugin.getConfig().set("conversions.icons", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.archive_wall_data")) {
            new TARDISWallConverter(this.plugin).processArchives();
            this.plugin.getConfig().set("conversions.archive_wall_data", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.legacy_default")) {
            new TARDISLegacyConverter(this.plugin).setOriginal();
            this.plugin.getConfig().set("conversions.legacy_default", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.all_in_one.helper") && new TARDISAllInOneConfigConverter(this.plugin).transferConfig(TardisModule.HELPER)) {
            this.plugin.getConfig().set("conversions.all_in_one.helper", (Object)true);
            ++this.conversions;
        }
        if (!this.plugin.getConfig().getBoolean("conversions.interior_door_id") && new TARDISInteractionDoorUpdater(this.plugin).addIds()) {
            this.plugin.getConfig().set("conversions.interior_door_id", (Object)true);
            ++this.conversions;
        }
        if (this.conversions > 0) {
            this.plugin.saveConfig();
        }
    }
}

