/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.utils;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitWorldConfiguration;
import com.sk89q.worldguard.config.ConfigurationManager;
import com.sk89q.worldguard.internal.platform.WorldGuardPlatform;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class WorldGuardChecker {
    public static boolean canSpawn(Location l) {
        Plugin p = Bukkit.getPluginManager().getPlugin("WorldGuard");
        if (p != null) {
            WorldGuardPlatform wg = WorldGuard.getInstance().getPlatform();
            BlockVector3 vector = BukkitAdapter.asBlockVector((Location)l);
            RegionManager rm = wg.getRegionContainer().get(BukkitAdapter.adapt((org.bukkit.World)l.getWorld()));
            ApplicableRegionSet rs = rm.getApplicableRegions(vector);
            if (rs.testState(null, new StateFlag[]{Flags.MOB_SPAWNING})) {
                return rs.queryValue(null, (Flag)Flags.DENY_SPAWN) == null;
            }
            return false;
        }
        return true;
    }

    public static boolean canExplode(Location l) {
        Plugin p = Bukkit.getPluginManager().getPlugin("WorldGuard");
        if (p != null) {
            WorldGuardPlatform wg = WorldGuard.getInstance().getPlatform();
            ConfigurationManager cfg = wg.getGlobalStateManager();
            World bw = BukkitAdapter.adapt((org.bukkit.World)l.getWorld());
            BukkitWorldConfiguration wcfg = (BukkitWorldConfiguration)cfg.get(bw);
            if (wcfg.blockCreeperBlockDamage || wcfg.blockTNTBlockDamage) {
                return false;
            }
            BlockVector3 vector = BukkitAdapter.asBlockVector((Location)l);
            RegionManager rm = wg.getRegionContainer().get(bw);
            ApplicableRegionSet rs = rm.getApplicableRegions(vector);
            return rs.testState(null, new StateFlag[]{Flags.OTHER_EXPLOSION, Flags.CREEPER_EXPLOSION, Flags.TNT});
        }
        return true;
    }
}

