/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.utils;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.SmilerVariant;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class MonsterTargetListener
implements Listener {
    private static boolean isWearingMonsterHead(Player player, Material material) {
        ItemStack is = player.getInventory().getHelmet();
        if (is != null && is.getType().equals((Object)material) && is.hasItemMeta()) {
            return is.getItemMeta().getPersistentDataContainer().has(TARDIS.plugin.getHeadBlockKey(), PersistentDataType.INTEGER);
        }
        return false;
    }

    public static boolean monsterShouldIgnorePlayer(Entity entity, Player player) {
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        boolean ignore = false;
        switch (entity.getType()) {
            case ZOMBIE: {
                if (pdc.has(TARDISWeepingAngels.ANGEL_OF_LIBERTY, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.ANGEL_OF_LIBERTY.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.CLOCKWORK_DROID, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.CLOCKWORK_DROID.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.CYBERMAN, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.CYBERMAN.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.CYBERSHADE, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.CYBERSHADE.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.EMPTY, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.EMPTY_CHILD.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.SCARECROW, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.SCARECROW.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.SLITHEEN, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.SLITHEEN.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.SMILER, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.SMILER.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.SONTARAN, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.SONTARAN.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.SYCORAX, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.SYCORAX.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.BEAST, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.THE_BEAST.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.VASHTA, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.VASHTA_NERADA.getMaterial());
                }
                if (!pdc.has(TARDISWeepingAngels.ZYGON, PersistentDataType.INTEGER)) break;
                ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.ZYGON.getMaterial());
                break;
            }
            case SKELETON: {
                if (pdc.has(TARDISWeepingAngels.DALEK, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.DALEK.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.MONK, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.HEADLESS_MONK.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.HEAVENLY_HOST, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.HEAVENLY_HOST.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.MIRE, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.MIRE.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.NIMON, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.NIMON.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.OMEGA, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.OMEGA.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.OSSIFIED, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.OSSIFIED.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.SATURNYNIAN, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.SATURNYNIAN.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.SILENT, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.SILENT.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.SILURIAN, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.SILURIAN.getMaterial());
                }
                if (!pdc.has(TARDISWeepingAngels.ANGEL, PersistentDataType.INTEGER)) break;
                ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.WEEPING_ANGEL.getMaterial());
                break;
            }
            case GUARDIAN: {
                if (!pdc.has(TARDISWeepingAngels.SILENT, PersistentDataType.INTEGER)) break;
                ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.SILENT.getMaterial());
                break;
            }
            case STRAY: {
                if (!pdc.has(TARDISWeepingAngels.SUTEKH, PersistentDataType.INTEGER)) break;
                ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.SUTEKH.getMaterial());
                break;
            }
            case ZOMBIFIED_PIGLIN: {
                if (pdc.has(TARDISWeepingAngels.DALEK_SEC, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.DALEK_SEC.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.DAVROS, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.DAVROS.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.HATH, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.HATH.getMaterial());
                }
                if (pdc.has(TARDISWeepingAngels.WARRIOR, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.ICE_WARRIOR.getMaterial());
                }
                if (!pdc.has(TARDISWeepingAngels.STRAX, PersistentDataType.INTEGER)) break;
                ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.STRAX.getMaterial());
                break;
            }
            case DROWNED: {
                if (pdc.has(TARDISWeepingAngels.DEVIL, PersistentDataType.INTEGER)) {
                    ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.SEA_DEVIL.getMaterial());
                }
                if (!pdc.has(TARDISWeepingAngels.VAMPIRE, PersistentDataType.INTEGER)) break;
                ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.VAMPIRE_OF_VENICE.getMaterial());
                break;
            }
            case PIGLIN_BRUTE: {
                if (!pdc.has(TARDISWeepingAngels.RACNOSS, PersistentDataType.INTEGER)) break;
                ignore = MonsterTargetListener.isWearingMonsterHead(player, Monster.RACNOSS.getMaterial());
                break;
            }
        }
        return ignore;
    }

    @EventHandler
    public void onMonsterTargetEvent(EntityTargetLivingEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof org.bukkit.entity.Monster) {
            ItemMeta im;
            EntityEquipment ee;
            ItemStack head;
            org.bukkit.entity.Monster monster = (org.bukkit.entity.Monster)entity;
            double range = entity instanceof Zombie ? 40.0 : 16.0;
            Player closest = null;
            double distance = 1000.0;
            Location locEnt = entity.getLocation();
            for (Entity e : entity.getNearbyEntities(range, range, range)) {
                if (!(e instanceof Player)) continue;
                Player player = (Player)e;
                if (closest == null) {
                    closest = player;
                    distance = e.getLocation().distanceSquared(locEnt);
                    continue;
                }
                if (!(e.getLocation().distanceSquared(locEnt) < distance)) continue;
                closest = player;
                distance = e.getLocation().distanceSquared(locEnt);
            }
            if (closest != null && MonsterTargetListener.monsterShouldIgnorePlayer(entity, closest)) {
                event.setCancelled(true);
                monster.setTarget(null);
            } else if (monster.getPersistentDataContainer().has(TARDISWeepingAngels.SMILER, PersistentDataType.INTEGER) && (head = (ee = monster.getEquipment()).getHelmet()) != null) {
                im = head.getItemMeta();
                im.setItemModel(SmilerVariant.SMILER_ANGRY_HEAD.getKey());
                head.setItemMeta(im);
                ee.setHelmet(head);
            }
            if (event.getReason() == EntityTargetEvent.TargetReason.FORGOT_TARGET && monster.getPersistentDataContainer().has(TARDISWeepingAngels.SMILER, PersistentDataType.INTEGER) && (head = (ee = monster.getEquipment()).getHelmet()) != null) {
                im = head.getItemMeta();
                im.setItemModel(SmilerVariant.SMILER_HEAD.getKey());
                head.setItemMeta(im);
                ee.setHelmet(head);
            }
        }
    }
}

