/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.transmat;

import java.util.ArrayList;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.custommodels.GUITransmat;
import me.eccentric_nz.TARDIS.database.data.Transmat;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTransmatList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISTransmatInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final int id;
    private final Player player;
    private final Inventory inventory;

    public TARDISTransmatInventory(TARDIS plugin, int id, Player player) {
        this.plugin = plugin;
        this.id = id;
        this.player = player;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"TARDIS transmats", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] stack = new ItemStack[54];
        int i = 0;
        ResultSetTransmatList rslist = new ResultSetTransmatList(this.plugin, this.id);
        if (rslist.resultSet()) {
            for (Transmat t : rslist.getData()) {
                if (i > 52) break;
                ItemStack is = ItemStack.of((Material)Material.MAP, (int)1);
                ItemMeta im = is.getItemMeta();
                im.displayName((Component)Component.text((String)t.name()));
                ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                lore.add(Component.text((String)String.format("X: %.2f", Float.valueOf(t.x()))));
                lore.add(Component.text((String)String.format("Y: %.2f", Float.valueOf(t.y()))));
                lore.add(Component.text((String)String.format("Z: %.2f", Float.valueOf(t.z()))));
                lore.add(Component.text((String)String.format("Yaw: %.2f", Float.valueOf(t.yaw()))));
                im.lore(lore);
                is.setItemMeta(im);
                stack[i] = is;
                if (i % 9 == 7) {
                    i += 2;
                    continue;
                }
                ++i;
            }
            ItemStack info = ItemStack.of((Material)GUITransmat.INFO.material(), (int)1);
            ItemMeta meta = info.getItemMeta();
            meta.displayName((Component)Component.text((String)this.plugin.getChameleonGuis().getString("INFO", "Info")));
            ArrayList<TextComponent> metaLore = new ArrayList<TextComponent>();
            for (String s : this.plugin.getChameleonGuis().getStringList("INFO_TRANSMAT")) {
                metaLore.add(Component.text((String)s));
            }
            meta.lore(metaLore);
            info.setItemMeta(meta);
            stack[GUITransmat.INFO.slot()] = info;
            ItemStack delete = ItemStack.of((Material)GUITransmat.DELETE.material(), (int)1);
            ItemMeta dim = delete.getItemMeta();
            dim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_DELETE", "Delete")));
            delete.setItemMeta(dim);
            stack[GUITransmat.DELETE.slot()] = delete;
        }
        ItemStack tele = ItemStack.of((Material)GUITransmat.TRANSMAT.material(), (int)1);
        ItemMeta port = tele.getItemMeta();
        port.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_TRANSMAT", "Transmat")));
        tele.setItemMeta(port);
        stack[GUITransmat.TRANSMAT.slot()] = tele;
        if (this.plugin.getPlanetsConfig().getBoolean("planets.rooms.enabled") && this.plugin.getServer().getWorld("rooms") != null && TARDISPermission.hasPermission(this.player, "tardis.transmat.rooms")) {
            ItemStack rooms = ItemStack.of((Material)GUITransmat.ROOMS.material(), (int)1);
            ItemMeta world = rooms.getItemMeta();
            world.displayName((Component)Component.text((String)"Rooms World"));
            rooms.setItemMeta(world);
            stack[GUITransmat.ROOMS.slot()] = rooms;
        }
        ItemStack close = ItemStack.of((Material)GUITransmat.CLOSE.material(), (int)1);
        ItemMeta close_im = close.getItemMeta();
        close_im.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(close_im);
        stack[GUITransmat.CLOSE.slot()] = close;
        return stack;
    }
}

