/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.archive;

import com.google.gson.JsonParser;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Archive;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;

public class ResultSetArchiveByUse {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final String uuid;
    private final int use;
    private Archive archive;

    public ResultSetArchiveByUse(TARDIS plugin, String uuid, int use) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.use = use;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block19: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT " + this.prefix + "archive.*, " + this.prefix + "player_prefs.lights FROM " + this.prefix + "archive, " + this.prefix + "player_prefs WHERE archive.uuid = ? AND use = ? AND " + this.prefix + "archive.uuid = " + this.prefix + "player_prefs.uuid";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.uuid);
                statement.setInt(2, this.use);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        TardisLight light;
                        try {
                            light = TardisLight.valueOf(rs.getString("lights"));
                        }
                        catch (IllegalArgumentException e) {
                            light = TardisLight.LAMP;
                        }
                        this.archive = new Archive(UUID.fromString(rs.getString("uuid")), rs.getString("name"), rs.getString("console_size"), rs.getBoolean("beacon"), light, rs.getInt("use"), rs.getInt("y"), JsonParser.parseString((String)rs.getString("data")).getAsJsonObject(), rs.getString("description"));
                    }
                    break block19;
                }
                boolean light = false;
                return light;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for archive! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing archive! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public Archive getArchive() {
        return this.archive;
    }
}

