/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.move;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.control.TARDISPowerButton;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCompanions;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetVoid;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.mobfarming.TARDISFarmer;
import me.eccentric_nz.TARDIS.mobfarming.TARDISFollowerSpawner;
import me.eccentric_nz.TARDIS.mobfarming.TARDISPetsAndFollowers;
import me.eccentric_nz.TARDIS.move.TARDISMoveSession;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.portal.Capture;
import me.eccentric_nz.TARDIS.portal.Cast;
import me.eccentric_nz.TARDIS.portal.CastData;
import me.eccentric_nz.TARDIS.portal.MatrixUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import me.eccentric_nz.TARDIS.utility.TARDISVoidUpdate;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class TARDISMoveListener
implements Listener {
    private final TARDIS plugin;

    public TARDISMoveListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerMoveToFromTARDIS(PlayerMoveEvent event) {
        CastData data;
        Location exterior;
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.plugin.getTrackerKeeper().getMovers().contains(uuid)) {
            return;
        }
        Location l = new Location(event.getTo().getWorld(), (double)event.getTo().getBlockX(), (double)event.getTo().getBlockY(), (double)event.getTo().getBlockZ(), 0.0f, 0.0f);
        Location loc = player.getLocation();
        TARDISMoveSession tms = this.plugin.getTrackerKeeper().getTARDISMoveSession(player);
        tms.setStaleLocation(loc);
        if (tms.isStaleLocation()) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("police_box.view_interior") && this.plugin.getTrackerKeeper().getCasters().containsKey(uuid) && (exterior = (data = this.plugin.getTrackerKeeper().getCasters().get(uuid)).exterior()).getWorld() == loc.getWorld()) {
            double vx;
            Location interior = data.interior();
            double distance = l.distanceSquared(exterior);
            double angle = MatrixUtils.getPlayerAngle(l.getX(), l.getZ(), vx, switch (data.direction()) {
                case COMPASS.EAST -> {
                    vx = exterior.getX() - 3.0;
                    yield exterior.getZ();
                }
                case COMPASS.WEST -> {
                    vx = exterior.getX() + 3.0;
                    yield exterior.getZ();
                }
                case COMPASS.NORTH -> {
                    vx = exterior.getX();
                    yield exterior.getZ() + 3.0;
                }
                default -> {
                    vx = exterior.getX();
                    yield exterior.getZ() - 3.0;
                }
            }, exterior.getX(), exterior.getZ());
            if (angle >= 360.0) {
                angle -= 360.0;
            }
            Cast cast = new Cast(this.plugin, exterior);
            if (distance <= 9.0 && angle < 26.0 && angle > -26.0) {
                Capture capture = new Capture();
                BlockData[][][] dataArr = capture.captureInterior(interior, (int)distance, data.rotor(), data.consoleSize());
                cast.castInterior(uuid, dataArr);
                if (capture.getRotorData().frame() != null) {
                    cast.castRotor(capture.getRotorData().frame(), player, capture.getRotorData().offset(), data.direction());
                }
            } else if (this.plugin.getTrackerKeeper().getCastRestore().containsKey(uuid)) {
                cast.restoreExterior(uuid);
                this.plugin.getTrackerKeeper().getCastRestore().remove(uuid);
                if (this.plugin.getTrackerKeeper().getRotorRestore().containsKey(uuid)) {
                    int rotorId = this.plugin.getTrackerKeeper().getRotorRestore().get(uuid);
                    this.plugin.getTardisHelper().removeFakeItemFrame(rotorId, player);
                    this.plugin.getTrackerKeeper().getRotorRestore().remove(uuid);
                }
            }
        }
        if (this.plugin.getTrackerKeeper().getPortals().containsKey(l)) {
            TARDISTeleportLocation tpl = this.plugin.getTrackerKeeper().getPortals().get(l);
            int id = tpl.getTardisId();
            List<UUID> companions = new ResultSetCompanions(this.plugin, id).getCompanions();
            if (tpl.isAbandoned() || companions.contains(uuid)) {
                Location to = tpl.getLocation();
                boolean exit = this.plugin.getConfig().getBoolean("creation.create_worlds_with_perms") && TARDISPermission.hasPermission(player, "tardis.create_world") ? !to.getWorld().getName().contains("TARDIS") : (this.plugin.getConfig().getBoolean("creation.default_world") ? !to.getWorld().getName().equals(this.plugin.getConfig().getString("creation.default_world_name")) : !to.getWorld().getName().contains("TARDIS"));
                float yaw = exit ? loc.getYaw() + 180.0f : loc.getYaw();
                switch (tpl.getDirection()) {
                    case NORTH_WEST: {
                        yaw += 90.0f;
                        break;
                    }
                    case SOUTH_WEST: {
                        yaw -= 90.0f;
                        break;
                    }
                }
                COMPASS d = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(player, false));
                if (!tpl.getDirection().equals((Object)d)) {
                    yaw += this.plugin.getGeneralKeeper().getDoorListener().adjustYaw(d, tpl.getDirection());
                }
                to.setYaw(yaw);
                ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
                boolean hasPrefs = rsp.resultSet();
                boolean minecart = hasPrefs && rsp.isMinecartOn();
                boolean userQuotes = hasPrefs && rsp.isQuotesOn();
                boolean willFarm = hasPrefs && rsp.isFarmOn();
                boolean canPowerUp = hasPrefs && rsp.isAutoPowerUp() && !tpl.isAbandoned();
                TARDISPetsAndFollowers petsAndFollowers = null;
                if (this.plugin.getConfig().getBoolean("allow.mob_farming") && TARDISPermission.hasPermission(player, "tardis.farm") && !this.plugin.getTrackerKeeper().getFarming().contains(uuid) && willFarm) {
                    this.plugin.getTrackerKeeper().getFarming().add(uuid);
                    TARDISFarmer tf = new TARDISFarmer(this.plugin);
                    petsAndFollowers = tf.farmAnimals(l, d, id, player, tpl.getLocation().getWorld().getName(), l.getWorld().getName());
                }
                this.plugin.getGeneralKeeper().getDoorListener().removeTraveller(uuid);
                if (!exit) {
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("tardis_id", id);
                    set.put("uuid", uuid.toString());
                    this.plugin.getQueryFactory().doSyncInsert("travellers", set);
                    if (!new ResultSetVoid(this.plugin, id).hasUpdatedToVOID()) {
                        new TARDISVoidUpdate(this.plugin, id).updateBiome();
                        this.plugin.getQueryFactory().addToVoid(id);
                    }
                }
                this.plugin.getGeneralKeeper().getDoorListener().movePlayer(player, to, exit, l.getWorld(), userQuotes, 0, minecart, false);
                if (petsAndFollowers != null) {
                    if (!petsAndFollowers.getPets().isEmpty()) {
                        this.plugin.getGeneralKeeper().getDoorListener().movePets(petsAndFollowers.getPets(), tpl.getLocation(), player, d, true);
                    }
                    if (!petsAndFollowers.getFollowers().isEmpty()) {
                        new TARDISFollowerSpawner(this.plugin).spawn(petsAndFollowers.getFollowers(), tpl.getLocation(), player, d, true);
                    }
                }
                if (canPowerUp && !exit) {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        Tardis tardis;
                        HashMap<String, Object> where = new HashMap<String, Object>();
                        where.put("tardis_id", id);
                        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                        if (rs.resultSet() && !(tardis = rs.getTardis()).isPoweredOn()) {
                            new TARDISPowerButton(this.plugin, id, player, tardis.getPreset(), false, tardis.isHidden(), tardis.isLightsOn(), loc, tardis.getArtronLevel(), tardis.getSchematic().getLights()).clickButton();
                        }
                    }, 20L);
                }
                if (userQuotes) {
                    this.plugin.getMessenger().sendStatus(player, "DOOR_REMIND");
                }
            }
        }
    }
}

