/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Objects;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCreeper;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.hads.TARDISHostileAction;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public class TARDISExplosionAndDamageListener
implements Listener {
    private final TARDIS plugin;

    public TARDISExplosionAndDamageListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.getEntityType().equals((Object)EntityType.ENDER_DRAGON)) {
            return;
        }
        Location explode = event.getLocation();
        if ((explode.getWorld().getName().contains("TARDIS") || explode.getWorld().getName().equals(this.plugin.getConfig().getString("creation.default_world_name"))) && event.getEntity() instanceof Creeper) {
            event.setCancelled(true);
            String loc_chk = explode.getWorld().getName() + ":" + ((float)explode.getBlockX() + 0.5f) + ":" + (explode.getBlockY() - 1) + ":" + ((float)explode.getBlockZ() + 0.5f);
            if (!new ResultSetCreeper(this.plugin, loc_chk).resultSet()) {
                explode.getWorld().createExplosion(explode.getX(), explode.getY(), explode.getZ(), 4.0f, false, false);
            }
        } else {
            World.Environment env = explode.getWorld().getEnvironment();
            if (env.equals((Object)World.Environment.THE_END) && !this.plugin.getConfig().getBoolean("travel.the_end") || env.equals((Object)World.Environment.NETHER) && !this.plugin.getConfig().getBoolean("travel.nether")) {
                return;
            }
            for (String str : this.plugin.getGeneralKeeper().getProtectBlockMap().keySet()) {
                Location loc = TARDISStaticLocationGetters.getLocationFromBukkitString(str);
                if (loc == null) continue;
                Block block = loc.getBlock();
                event.blockList().remove(block);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onProjectileHit(ProjectileHitEvent event) {
        Entity entity = event.getHitEntity();
        if (entity instanceof ArmorStand) {
            ProjectileSource projectileSource;
            ArmorStand stand = (ArmorStand)entity;
            String location = stand.getLocation().getBlock().getRelative(BlockFace.DOWN).getLocation().toString();
            if (this.plugin.getGeneralKeeper().getProtectBlockMap().containsKey(location) && (projectileSource = event.getEntity().getShooter()) instanceof Player) {
                Player p = (Player)projectileSource;
                int limit = this.plugin.getConfig().getInt("preferences.hads_damage");
                int id = this.plugin.getGeneralKeeper().getProtectBlockMap().get(location);
                int damage = this.plugin.getTrackerKeeper().getHadsDamage().getOrDefault(id, 0);
                this.plugin.getTrackerKeeper().getHadsDamage().put(id, damage + 1);
                if (damage == limit && this.plugin.getConfig().getBoolean("allow.hads") && !this.plugin.getTrackerKeeper().getInVortex().contains(id) && TARDISStaticUtils.isOwnerOnline(id) && !this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                    new TARDISHostileAction(this.plugin).processAction(id, p);
                } else if (limit - damage >= 0) {
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "HADS_WARNING", String.format("%d", limit - damage));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, ItemFrame.class, ArmorStand.class}, (Object)entity2, n)) {
                case 0: {
                    Player player = (Player)entity2;
                    if (!this.plugin.getTrackerKeeper().getFlyingReturnLocation().containsKey(player.getUniqueId())) {
                        n = 1;
                        continue block5;
                    }
                    event.setCancelled(true);
                    break block5;
                }
                case 1: {
                    ItemFrame frame = (ItemFrame)entity2;
                    if (!(event.getDamager() instanceof Player)) {
                        n = 2;
                        continue block5;
                    }
                    String l = frame.getLocation().toString();
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("location", l);
                    where.put("type", 27);
                    ResultSetControls rs = new ResultSetControls(this.plugin, where, false);
                    if (!rs.resultSet()) break block5;
                    event.setCancelled(true);
                    break block5;
                }
                case 2: {
                    ArmorStand stand = (ArmorStand)entity2;
                    this.plugin.debug(stand.getLocation());
                    if (!this.plugin.getGeneralKeeper().getProtectBlockMap().containsKey(stand.getLocation().getBlock().getRelative(BlockFace.DOWN).getLocation().toString())) break block5;
                    this.plugin.debug("Armour Stand HADS");
                    break block5;
                }
            }
            break;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        String l = event.getDamager().getLocation().getWorld().getName();
        if (l.contains("TARDIS") || l.equals(this.plugin.getConfig().getString("creation.default_world_name"))) {
            event.setCancelled(true);
        }
    }
}

