/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.handles;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Program;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPrograms;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

class TARDISHandlesSavedInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final String uuid;
    private final Inventory inventory;

    TARDISHandlesSavedInventory(TARDIS plugin, String uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"Saved Programs", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] stack = new ItemStack[54];
        int i = 0;
        ResultSetPrograms rs = new ResultSetPrograms(this.plugin, this.uuid);
        if (rs.resultSet()) {
            for (Program p : rs.getPrograms()) {
                String checked;
                ItemStack is = ItemStack.of((Material)Material.MUSIC_DISC_WARD, (int)1);
                ItemMeta im = is.getItemMeta();
                im.displayName((Component)Component.text((String)"Handles Program Disk"));
                String string = checked = p.isCheckedOut() ? "Checked OUT" : "Checked IN";
                if (!p.getParsed().isEmpty()) {
                    im.lore(List.of(Component.text((String)p.getName()), Component.text((int)p.getProgram_id()), Component.text((String)checked), Component.text((String)"Running", (TextColor)NamedTextColor.AQUA)));
                } else {
                    im.lore(List.of(Component.text((String)p.getName()), Component.text((int)p.getProgram_id()), Component.text((String)checked)));
                }
                im.addItemFlags(ItemFlag.values());
                im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
                is.setItemMeta(im);
                stack[i] = is;
                if (++i <= 44) continue;
                break;
            }
        }
        ItemStack back = ItemStack.of((Material)Material.ARROW, (int)1);
        ItemMeta bk = back.getItemMeta();
        bk.displayName((Component)Component.text((String)"Back to editor"));
        back.setItemMeta(bk);
        stack[45] = back;
        ItemStack load = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta ld = load.getItemMeta();
        ld.displayName((Component)Component.text((String)"Load selected program in editor"));
        load.setItemMeta(ld);
        stack[47] = load;
        ItemStack deactivate = ItemStack.of((Material)Material.BUCKET, (int)1);
        ItemMeta dem = deactivate.getItemMeta();
        dem.displayName((Component)Component.text((String)"Deactivate selected program"));
        deactivate.setItemMeta(dem);
        stack[48] = deactivate;
        ItemStack delete = ItemStack.of((Material)Material.BUCKET, (int)1);
        ItemMeta dm = delete.getItemMeta();
        dm.displayName((Component)Component.text((String)"Delete selected program"));
        delete.setItemMeta(dm);
        stack[49] = delete;
        ItemStack checked = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta km = checked.getItemMeta();
        km.displayName((Component)Component.text((String)"Check out selected program"));
        checked.setItemMeta(km);
        stack[51] = checked;
        ItemStack close = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta cm = close.getItemMeta();
        cm.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(cm);
        stack[53] = close;
        return stack;
    }
}

