/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.handles;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.artron.TARDISLampToggler;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.commands.handles.TARDISHandlesTeleportCommand;
import me.eccentric_nz.TARDIS.control.TARDISPowerButton;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Program;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHomeLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisArtron;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.doors.inner.Inner;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorOpener;
import me.eccentric_nz.TARDIS.doors.inner.InnerDoor;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorOpener;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDoor;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisOldBiomeLookup;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesBlock;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesCategory;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.siegemode.TARDISSiegeMode;
import me.eccentric_nz.TARDIS.travel.TARDISRandomiserCircuit;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.tardischunkgenerator.custombiome.BiomeUtilities;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Powerable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TARDISHandlesProcessor {
    private final TARDIS plugin;
    private final Program program;
    private final Player player;
    private final int pid;

    public TARDISHandlesProcessor(TARDIS plugin, Program program, Player player, int pid) {
        this.plugin = plugin;
        this.program = program;
        this.player = player;
        this.pid = pid;
    }

    public void processDisk() {
        String event = "";
        block3: for (ItemStack is : this.program.getInventory()) {
            if (is == null) continue;
            TARDISHandlesBlock thb = TARDISHandlesBlock.BY_NAME.get(is.getItemMeta().displayName());
            switch (thb) {
                case ARTRON: 
                case DEATH: 
                case DEMATERIALISE: 
                case ENTER: 
                case EXIT: 
                case HADS: 
                case LOG_OUT: 
                case MATERIALISE: 
                case SIEGE_OFF: 
                case SIEGE_ON: {
                    event = thb.toString();
                    continue block3;
                }
            }
        }
        if (!event.isEmpty()) {
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("parsed", event);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("program_id", this.pid);
            this.plugin.getQueryFactory().doUpdate("programs", set, where);
            this.plugin.getMessenger().handlesSend(this.player, "HANDLES_RUNNING");
        } else {
            this.processCommand(0);
            this.plugin.getMessenger().handlesSend(this.player, "HANDLES_EXECUTE");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processCommand(int pos) {
        int i = pos;
        while (i < 36) {
            ItemStack is = this.program.getInventory()[i];
            if (is != null) {
                TARDISHandlesBlock thb = TARDISHandlesBlock.BY_NAME.get(is.getItemMeta().displayName());
                TARDISHandlesBlock next = this.getNext(i + 1);
                if (next != null) {
                    UUID uuid = this.player.getUniqueId();
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("uuid", uuid.toString());
                    ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                    if (rs.resultSet()) {
                        Tardis tardis = rs.getTardis();
                        int id = tardis.getTardisId();
                        block1 : switch (thb) {
                            case DOOR: {
                                switch (next) {
                                    case CLOSE: {
                                        ResultSetTardisPreset rsp = new ResultSetTardisPreset(this.plugin);
                                        if (!rsp.fromID(id)) break;
                                        Inner innerDisplayDoor = new InnerDoor(this.plugin, id).get();
                                        if (innerDisplayDoor.display()) {
                                            new InnerDisplayDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, uuid, true);
                                        } else {
                                            new InnerMinecraftDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, uuid);
                                        }
                                        boolean outerDisplayDoor = rsp.getPreset().usesArmourStand();
                                        if (outerDisplayDoor) {
                                            new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, uuid);
                                            break;
                                        }
                                        if (!rsp.getPreset().hasDoor()) break;
                                        new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, uuid);
                                        break;
                                    }
                                    case OPEN: {
                                        ResultSetTardisPreset rsp = new ResultSetTardisPreset(this.plugin);
                                        if (!rsp.fromID(id)) break;
                                        Inner innerDisplayDoor = new InnerDoor(this.plugin, id).get();
                                        if (innerDisplayDoor.display()) {
                                            new InnerDisplayDoorOpener(this.plugin).open(innerDisplayDoor.block(), id, true);
                                        } else {
                                            new InnerMinecraftDoorOpener(this.plugin).open(innerDisplayDoor.block(), id);
                                        }
                                        boolean outerDisplayDoor = rsp.getPreset().usesArmourStand();
                                        if (outerDisplayDoor) {
                                            new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, uuid);
                                            break;
                                        }
                                        if (!rsp.getPreset().hasDoor()) break;
                                        new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, uuid);
                                        break;
                                    }
                                    case LOCK: 
                                    case UNLOCK: {
                                        HashMap<String, Object> whered = new HashMap<String, Object>();
                                        whered.put("tardis_id", id);
                                        whered.put("door_type", 0);
                                        ResultSetDoors rsd = new ResultSetDoors(this.plugin, whered, false);
                                        if (!rsd.resultSet() || (!next.equals((Object)TARDISHandlesBlock.LOCK) || rsd.isLocked()) && (!next.equals((Object)TARDISHandlesBlock.UNLOCK) || !rsd.isLocked())) break;
                                        String message = rsd.isLocked() ? this.plugin.getLanguage().getString("DOOR_UNLOCK") : this.plugin.getLanguage().getString("DOOR_DEADLOCK");
                                        int locked = rsd.isLocked() ? 0 : 1;
                                        HashMap<String, Object> setl = new HashMap<String, Object>();
                                        setl.put("locked", locked);
                                        HashMap<String, Object> wherel = new HashMap<String, Object>();
                                        wherel.put("tardis_id", id);
                                        this.plugin.getQueryFactory().doUpdate("doors", setl, wherel);
                                        this.plugin.getMessenger().handlesSend(this.player, "DOOR_LOCK", message);
                                        break;
                                    }
                                }
                                break;
                            }
                            case LIGHTS: {
                                boolean onoff = next.equals((Object)TARDISHandlesBlock.ON);
                                if ((!onoff || tardis.isLightsOn()) && (onoff || !tardis.isLightsOn())) break;
                                new TARDISLampToggler(this.plugin).flickSwitch(id, uuid, onoff, tardis.getSchematic().getLights());
                                break;
                            }
                            case POWER: {
                                switch (next) {
                                    case ON: {
                                        if (!tardis.isPoweredOn() && this.plugin.getConfig().getBoolean("allow.power_down")) {
                                            new TARDISPowerButton(this.plugin, id, this.player, tardis.getPreset(), false, tardis.isHidden(), tardis.isLightsOn(), this.player.getLocation(), tardis.getArtronLevel(), tardis.getSchematic().getLights()).clickButton();
                                            break;
                                        }
                                        break block1;
                                    }
                                    case OFF: {
                                        if (tardis.isPoweredOn() && this.plugin.getConfig().getBoolean("allow.power_down")) {
                                            new TARDISPowerButton(this.plugin, id, this.player, tardis.getPreset(), true, tardis.isHidden(), tardis.isLightsOn(), this.player.getLocation(), tardis.getArtronLevel(), tardis.getSchematic().getLights()).clickButton();
                                            break;
                                        }
                                        break block1;
                                    }
                                    case SHOW: {
                                        this.plugin.getMessenger().sendArtron(this.player, id, 0);
                                        break;
                                    }
                                    case REDSTONE: {
                                        HashMap<String, Object> whereh = new HashMap<String, Object>();
                                        whereh.put("tardis_id", id);
                                        whereh.put("type", 26);
                                        ResultSetControls rsh = new ResultSetControls(this.plugin, whereh, false);
                                        if (!rsh.resultSet()) break;
                                        Location handles = TARDISStaticLocationGetters.getLocationFromBukkitString(rsh.getLocation());
                                        Block block = handles.getBlock();
                                        Powerable button = (Powerable)block.getBlockData();
                                        if (!button.isPowered()) {
                                            button.setPowered(true);
                                        }
                                        block.setBlockData((BlockData)button, true);
                                        break;
                                    }
                                }
                                break;
                            }
                            case SIEGE: {
                                if ((!next.equals((Object)TARDISHandlesBlock.ON) || tardis.isSiegeOn()) && (!next.equals((Object)TARDISHandlesBlock.OFF) || !tardis.isSiegeOn())) break;
                                new TARDISSiegeMode(this.plugin).toggleViaSwitch(id, this.player);
                                break;
                            }
                            case TRAVEL: {
                                int travel;
                                ResultSetTardisArtron rsArtron = new ResultSetTardisArtron(this.plugin);
                                if (!rsArtron.fromID(id)) break;
                                int level = rsArtron.getArtronLevel();
                                if (level < (travel = this.plugin.getArtronConfig().getInt("travel"))) {
                                    this.plugin.getMessenger().handlesSend(this.player, "NOT_ENOUGH_ENERGY");
                                    break;
                                }
                                ItemStack after = this.program.getInventory()[i + 1];
                                List lore = after.getItemMeta().lore();
                                if (lore == null) break;
                                String first = ComponentUtils.stripColour((Component)lore.getFirst());
                                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                                if (!rsc.resultSet()) break;
                                Current current = rsc.getCurrent();
                                Location goto_loc = null;
                                COMPASS direction = current.direction();
                                COMPASS nextDirection = current.direction();
                                int x = current.location().getBlockX();
                                int y = current.location().getBlockY();
                                int z = current.location().getBlockZ();
                                boolean sub = false;
                                TravelType travelType = TravelType.SAVE;
                                switch (next) {
                                    case RANDOM: {
                                        Location random = new TARDISRandomiserCircuit(this.plugin).getRandomlocation(this.player, direction);
                                        if (random != null) {
                                            this.plugin.getTrackerKeeper().getHasRandomised().add(id);
                                            this.plugin.getMessenger().handlesSend(this.player, "RANDOMISER");
                                            goto_loc = random;
                                            sub = this.plugin.getTrackerKeeper().getSubmarine().contains(id);
                                        }
                                        travelType = TravelType.RANDOM;
                                        break;
                                    }
                                    case X: {
                                        int fz;
                                        ItemStack coordX = this.program.getInventory()[i + 2];
                                        TARDISHandlesBlock coordBlockX = TARDISHandlesBlock.valueOf(ComponentUtils.stripColour(coordX.getItemMeta().displayName()));
                                        x = this.getNumber(coordBlockX, i + 2);
                                        int fy = this.find(TARDISHandlesBlock.Y, i + 3);
                                        if (fy > 0) {
                                            ItemStack coordY = this.program.getInventory()[fy];
                                            TARDISHandlesBlock coordBlockY = TARDISHandlesBlock.valueOf(ComponentUtils.stripColour(coordY.getItemMeta().displayName()));
                                            y = this.getNumber(coordBlockY, fy);
                                        }
                                        if ((fz = this.find(TARDISHandlesBlock.Z, i + 3)) > 0) {
                                            ItemStack coordZ = this.program.getInventory()[fz];
                                            TARDISHandlesBlock coordBlockZ = TARDISHandlesBlock.valueOf(ComponentUtils.stripColour(coordZ.getItemMeta().displayName()));
                                            z = this.getNumber(coordBlockZ, fz);
                                        }
                                        goto_loc = new Location(current.location().getWorld(), (double)x, (double)y, (double)z);
                                        travelType = TravelType.COORDINATES;
                                        break;
                                    }
                                    case Y: {
                                        ItemStack coordY = this.program.getInventory()[i + 2];
                                        TARDISHandlesBlock coordBlockY = TARDISHandlesBlock.valueOf(ComponentUtils.stripColour(coordY.getItemMeta().displayName()));
                                        y = this.getNumber(coordBlockY, i + 2);
                                        int fyz = this.find(TARDISHandlesBlock.Z, i + 3);
                                        if (fyz > 0) {
                                            ItemStack coordZ = this.program.getInventory()[fyz];
                                            TARDISHandlesBlock coordBlockZ = TARDISHandlesBlock.valueOf(ComponentUtils.stripColour(coordZ.getItemMeta().displayName()));
                                            z = this.getNumber(coordBlockZ, fyz);
                                        }
                                        goto_loc = new Location(current.location().getWorld(), (double)x, (double)y, (double)z);
                                        travelType = TravelType.RELATIVE_COORDINATES;
                                        break;
                                    }
                                    case Z: {
                                        ItemStack coordZ = this.program.getInventory()[i + 2];
                                        TARDISHandlesBlock coordBlockZ = TARDISHandlesBlock.valueOf(ComponentUtils.stripColour(coordZ.getItemMeta().displayName()));
                                        z = this.getNumber(coordBlockZ, i + 2);
                                        goto_loc = new Location(current.location().getWorld(), (double)x, (double)y, (double)z);
                                        travelType = TravelType.RELATIVE_COORDINATES;
                                        break;
                                    }
                                    case HOME: {
                                        HashMap<String, Object> wherehl = new HashMap<String, Object>();
                                        wherehl.put("tardis_id", id);
                                        ResultSetHomeLocation rsh = new ResultSetHomeLocation(this.plugin, wherehl);
                                        if (!rsh.resultSet()) {
                                            this.plugin.getMessenger().handlesSend(this.player, "HOME_NOT_FOUND");
                                            break block1;
                                        }
                                        this.plugin.getMessenger().handlesSend(this.player, "TRAVEL_LOADED", "Home");
                                        goto_loc = new Location(rsh.getWorld(), (double)rsh.getX(), (double)rsh.getY(), (double)rsh.getZ());
                                        nextDirection = rsh.getDirection();
                                        sub = rsh.isSubmarine();
                                        if (!rsh.getPreset().isEmpty()) {
                                            HashMap<String, Object> wherep = new HashMap<String, Object>();
                                            wherep.put("tardis_id", id);
                                            HashMap<String, Object> setp = new HashMap<String, Object>();
                                            setp.put("chameleon_preset", rsh.getPreset());
                                            setp.put("adapti_on", 0);
                                            this.plugin.getQueryFactory().doSyncUpdate("tardis", setp, wherep);
                                        }
                                        travelType = TravelType.HOME;
                                        break;
                                    }
                                    case RECHARGER: {
                                        Location recharger = this.getRecharger(current.location().getWorld(), this.player);
                                        if (recharger != null) {
                                            this.plugin.getMessenger().handlesSend(this.player, "RECHARGER_FOUND");
                                            goto_loc = recharger;
                                            travelType = TravelType.RECHARGER;
                                            break;
                                        }
                                        this.plugin.getMessenger().handlesSend(this.player, "NO_MORE_SPOTS");
                                        break block1;
                                    }
                                    case AREA_DISK: {
                                        if (!this.plugin.getTardisArea().areaCheckInExile(first, current.location())) break block1;
                                        HashMap<String, Object> wherea = new HashMap<String, Object>();
                                        wherea.put("area_name", first);
                                        ResultSetAreas rsa = new ResultSetAreas(this.plugin, wherea, false, false);
                                        if (!rsa.resultSet()) {
                                            this.plugin.getMessenger().sendColouredCommand((CommandSender)this.player, "AREA_NOT_FOUND", "/tardis list areas", this.plugin);
                                            break block1;
                                        }
                                        if (!TARDISPermission.hasPermission(this.player, "tardis.area." + first) && !TARDISPermission.hasPermission(this.player, "tardis.area.*") || !this.player.isPermissionSet("tardis.area." + first) && !this.player.isPermissionSet("tardis.area.*")) {
                                            this.plugin.getMessenger().handlesSend(this.player, "TRAVEL_NO_AREA_PERM", first);
                                            break block1;
                                        }
                                        Location l = rsa.getArea().grid() ? this.plugin.getTardisArea().getNextSpot(rsa.getArea().areaName()) : this.plugin.getTardisArea().getSemiRandomLocation(rsa.getArea().areaId());
                                        if (l == null) {
                                            this.plugin.getMessenger().handlesSend(this.player, "NO_MORE_SPOTS");
                                            break block1;
                                        }
                                        this.plugin.getMessenger().handlesSend(this.player, "TRAVEL_APPROVED", first);
                                        goto_loc = l;
                                        travelType = TravelType.AREA;
                                        break;
                                    }
                                    case BIOME_DISK: {
                                        int count;
                                        Biome biome;
                                        if (!TARDISPermission.hasPermission(this.player, "tardis.timetravel.biome")) {
                                            this.plugin.getMessenger().handlesSend(this.player, "TRAVEL_NO_PERM_BIOME");
                                            break block1;
                                        }
                                        if (current.location().getBlock().getBiome().getKey().value().toUpperCase(Locale.ROOT).equals(first)) break block1;
                                        try {
                                            biome = (Biome)RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME).get(new NamespacedKey("minecraft", first.toLowerCase(Locale.ROOT)));
                                        }
                                        catch (IllegalArgumentException iae) {
                                            String upper = first.toUpperCase(Locale.ROOT);
                                            if (!TardisOldBiomeLookup.OLD_BIOME_LOOKUP.containsKey(upper)) {
                                                this.plugin.getMessenger().handlesSend(this.player, "BIOME_NOT_VALID");
                                                break block1;
                                            }
                                            biome = TardisOldBiomeLookup.OLD_BIOME_LOOKUP.get(upper);
                                        }
                                        this.plugin.getMessenger().handlesSend(this.player, "BIOME_SEARCH");
                                        Location nsob = BiomeUtilities.searchBiome(current.location().getWorld(), biome, current.location());
                                        if (nsob == null) {
                                            this.plugin.getMessenger().handlesSend(this.player, "BIOME_NOT_FOUND");
                                            break block1;
                                        }
                                        if (!this.plugin.getPluginRespect().getRespect(nsob, new Parameters(this.player, Flag.getDefaultFlags()))) break block1;
                                        World bw = nsob.getWorld();
                                        while (!bw.getChunkAt(nsob).isLoaded()) {
                                            bw.getChunkAt(nsob).load();
                                        }
                                        int[] start_loc = TARDISTimeTravel.getStartLocation(nsob, direction);
                                        int tmp_y = nsob.getBlockY();
                                        for (int up = 0; up < 10; ++up) {
                                            count = TARDISTimeTravel.safeLocation(start_loc[0], tmp_y + up, start_loc[2], start_loc[1], start_loc[3], nsob.getWorld(), direction);
                                            if (count != 0) continue;
                                            nsob.setY((double)(tmp_y + up));
                                            break;
                                        }
                                        this.plugin.getMessenger().handlesSend(this.player, "BIOME_SET");
                                        goto_loc = nsob;
                                        travelType = TravelType.BIOME;
                                        break;
                                    }
                                    case PLAYER_DISK: {
                                        int count;
                                        if (TARDISPermission.hasPermission(this.player, "tardis.timetravel.player")) {
                                            if (this.player.getName().equalsIgnoreCase(first)) {
                                                this.plugin.getMessenger().handlesSend(this.player, "TRAVEL_NO_SELF");
                                                break block1;
                                            }
                                            Player to = this.plugin.getServer().getPlayer(first);
                                            if (to == null) {
                                                this.plugin.getMessenger().handlesSend(this.player, "NOT_ONLINE");
                                                break block1;
                                            }
                                            UUID toUUID = to.getUniqueId();
                                            ResultSetPlayerPrefs rspp = new ResultSetPlayerPrefs(this.plugin, toUUID.toString());
                                            if (rspp.resultSet() && rspp.isDND()) {
                                                this.plugin.getMessenger().handlesSend(this.player, "DND", first);
                                                break block1;
                                            }
                                            Location player_loc = to.getLocation();
                                            if (this.plugin.getTardisArea().isInExistingArea(player_loc)) {
                                                this.plugin.getMessenger().sendColouredCommand((CommandSender)this.player, "PLAYER_IN_AREA", "/tardistravel area [area name]", this.plugin);
                                                break block1;
                                            }
                                            if (!this.plugin.getPluginRespect().getRespect(player_loc, new Parameters(this.player, Flag.getDefaultFlags()))) break block1;
                                            if (!this.plugin.getPlanetsConfig().getBoolean("planets." + player_loc.getWorld().getName() + ".time_travel")) {
                                                this.plugin.getMessenger().handlesSend(this.player, "NO_WORLD_TRAVEL");
                                                break block1;
                                            }
                                            World w = player_loc.getWorld();
                                            int[] start_loc = TARDISTimeTravel.getStartLocation(player_loc, direction);
                                            count = TARDISTimeTravel.safeLocation(start_loc[0] - 3, player_loc.getBlockY(), start_loc[2], start_loc[1] - 3, start_loc[3], w, direction);
                                            if (count > 0) {
                                                this.plugin.getMessenger().handlesSend(this.player, "RESCUE_NOT_SAFE");
                                                break block1;
                                            }
                                            goto_loc = player_loc;
                                            travelType = TravelType.PLAYER;
                                            break;
                                        }
                                        this.plugin.getMessenger().handlesSend(this.player, "NO_PERM_PLAYER");
                                        break block1;
                                    }
                                    case SAVE_DISK: {
                                        if (TARDISPermission.hasPermission(this.player, "tardis.save")) {
                                            int sx = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(2)));
                                            int sy = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(3)));
                                            int sz = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(4)));
                                            if (current.location().getWorld().getName().equals(lore.get(1)) && current.location().getBlockX() == sx && current.location().getBlockZ() == sz) break block1;
                                            this.plugin.getMessenger().handlesSend(this.player, "LOC_SET");
                                            goto_loc = new Location(TARDISAliasResolver.getWorldFromAlias(ComponentUtils.stripColour((Component)lore.get(1))), (double)sx, (double)sy, (double)sz);
                                            nextDirection = COMPASS.valueOf(ComponentUtils.stripColour((Component)lore.get(6)));
                                            sub = Boolean.parseBoolean(ComponentUtils.stripColour((Component)lore.get(7)));
                                            break;
                                        }
                                        this.plugin.getMessenger().handlesSend(this.player, "TRAVEL_NO_PERM_SAVE");
                                        break block1;
                                    }
                                }
                                if (goto_loc == null) break;
                                this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(travel, travelType));
                                this.plugin.getTrackerKeeper().getRescue().remove(id);
                                if (!this.plugin.getTrackerKeeper().getHasNotClickedHandbrake().contains(id)) {
                                    this.plugin.getTrackerKeeper().getHasNotClickedHandbrake().add(id);
                                    DamageUtility.run(this.plugin, DiskCircuit.MEMORY, id, this.player);
                                }
                                if (!this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                                    DestroyData dd = new DestroyData();
                                    dd.setDirection(direction);
                                    dd.setLocation(current.location());
                                    dd.setPlayer((OfflinePlayer)this.player);
                                    dd.setHide(false);
                                    dd.setOutside(false);
                                    dd.setSubmarine(current.submarine());
                                    dd.setTardisID(id);
                                    dd.setThrottle(SpaceTimeThrottle.NORMAL);
                                    HashMap<String, Object> set = new HashMap<String, Object>();
                                    set.put("handbrake_on", 0);
                                    HashMap<String, Object> tid = new HashMap<String, Object>();
                                    tid.put("tardis_id", id);
                                    if (!tardis.isHidden()) {
                                        this.plugin.getPresetDestroyer().destroyPreset(dd);
                                        this.plugin.getTrackerKeeper().getDematerialising().add(dd.getTardisID());
                                        this.plugin.getTrackerKeeper().getInVortex().add(id);
                                        TARDISSounds.playTARDISSound(current.location(), "tardis_takeoff");
                                    } else {
                                        this.plugin.getPresetDestroyer().removeBlockProtection(id);
                                        set.put("hidden", 0);
                                    }
                                    this.plugin.getQueryFactory().doUpdate("tardis", set, tid);
                                }
                                BuildData bd = new BuildData(uuid.toString());
                                bd.setDirection(nextDirection);
                                bd.setLocation(goto_loc);
                                bd.setMalfunction(false);
                                bd.setPlayer((OfflinePlayer)this.player);
                                bd.setRebuild(false);
                                bd.setOutside(false);
                                bd.setSubmarine(sub);
                                bd.setTardisID(id);
                                bd.setThrottle(SpaceTimeThrottle.NORMAL);
                                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                                    this.plugin.getPresetBuilder().buildPreset(bd);
                                    this.plugin.getTrackerKeeper().getInVortex().add(id);
                                    TARDISSounds.playTARDISSound(bd.getLocation(), "tardis_land");
                                    HashMap<String, Object> seth = new HashMap<String, Object>();
                                    seth.put("handbrake_on", 1);
                                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                                    wheret.put("tardis_id", id);
                                    this.plugin.getQueryFactory().doUpdate("tardis", seth, wheret);
                                }, 500L);
                                HashMap<String, Object> setc = new HashMap<String, Object>();
                                setc.put("world", goto_loc.getWorld().getName());
                                setc.put("x", goto_loc.getBlockX());
                                setc.put("y", goto_loc.getBlockY());
                                setc.put("z", goto_loc.getBlockZ());
                                setc.put("direction", nextDirection.toString());
                                setc.put("submarine", sub ? 1 : 0);
                                HashMap<String, Object> wherec = new HashMap<String, Object>();
                                wherec.put("tardis_id", id);
                                this.plugin.getQueryFactory().doUpdate("current", setc, wherec);
                                HashMap<String, Object> setb = new HashMap<String, Object>();
                                setb.put("world", current.location().getWorld().getName());
                                setb.put("x", current.location().getBlockX());
                                setb.put("y", current.location().getBlockY());
                                setb.put("z", current.location().getBlockZ());
                                setb.put("direction", direction.toString());
                                setb.put("submarine", current.submarine() ? 1 : 0);
                                HashMap<String, Object> whereb = new HashMap<String, Object>();
                                whereb.put("tardis_id", id);
                                this.plugin.getQueryFactory().doUpdate("back", setb, whereb);
                                HashMap<String, Object> wherea = new HashMap<String, Object>();
                                wherea.put("tardis_id", id);
                                this.plugin.getQueryFactory().alterEnergyLevel("tardis", -travel, wherea, this.player);
                                break;
                            }
                            case HIDE: {
                                this.player.performCommand("tardis hide");
                                break;
                            }
                            case REBUILD: {
                                this.player.performCommand("tardis rebuild");
                                break;
                            }
                            case SCAN: {
                                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles scan " + String.valueOf(uuid) + " " + id);
                                break;
                            }
                            case COMEHERE: {
                                new TARDISHandlesTeleportCommand(this.plugin).beamMeUp(this.player);
                                break;
                            }
                            case TAKE_OFF: {
                                if (!this.plugin.getUtils().inTARDISWorld(this.player.getLocation())) break;
                                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles takeoff " + String.valueOf(uuid) + " " + id);
                                break;
                            }
                            case LAND: {
                                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "handles land " + String.valueOf(uuid) + " " + id);
                                break;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return;
    }

    void processArtronCommand(int pos) {
        boolean first = true;
        TARDISHandlesBlock comparison = null;
        block11: for (int i = pos; i < 36; ++i) {
            ItemStack is = this.program.getInventory()[i];
            if (is == null) continue;
            TARDISHandlesBlock thb = TARDISHandlesBlock.BY_NAME.get(ComponentUtils.stripColour(is.getItemMeta().displayName()));
            switch (thb) {
                case LESS_THAN: 
                case LESS_THAN_EQUAL: 
                case GREATER_THAN: 
                case GREATER_THAN_EQUAL: 
                case EQUALS: {
                    comparison = thb;
                    continue block11;
                }
                case ONE: 
                case TWO: 
                case THREE: 
                case FOUR: 
                case FIVE: 
                case SIX: 
                case SEVEN: 
                case EIGHT: 
                case NINE: 
                case ZERO: {
                    if (!first) continue block11;
                    int level = this.getNumber(thb, i);
                    ResultSetTardisArtron rs = new ResultSetTardisArtron(this.plugin);
                    if (rs.fromUUID(this.player.getUniqueId().toString())) {
                        boolean process;
                        switch (comparison) {
                            case LESS_THAN: {
                                boolean bl;
                                if (level < rs.getArtronLevel()) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            case LESS_THAN_EQUAL: {
                                boolean bl;
                                if (level <= rs.getArtronLevel()) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            case GREATER_THAN: {
                                boolean bl;
                                if (level > rs.getArtronLevel()) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            case GREATER_THAN_EQUAL: {
                                boolean bl;
                                if (level >= rs.getArtronLevel()) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            default: {
                                boolean bl = process = level == rs.getArtronLevel();
                            }
                        }
                        if (!process) {
                            return;
                        }
                    }
                    first = false;
                    continue block11;
                }
                case DO: {
                    this.processCommand(i);
                    continue block11;
                }
            }
        }
    }

    private TARDISHandlesBlock getNext(int i) {
        if (i > 35) {
            return null;
        }
        ItemStack num = this.program.getInventory()[i];
        if (num != null) {
            return TARDISHandlesBlock.BY_NAME.get(ComponentUtils.stripColour(num.getItemMeta().displayName()));
        }
        return null;
    }

    private Location getRecharger(World world, Player player) {
        Location l = null;
        HashMap<String, Object> wherea = new HashMap<String, Object>();
        wherea.put("world", world.getName());
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, wherea, false, false);
        if (rsa.resultSet()) {
            String area = rsa.getArea().areaName();
            if (!TARDISPermission.hasPermission(player, "tardis.area." + area) || !player.isPermissionSet("tardis.area." + area)) {
                return null;
            }
            l = rsa.getArea().grid() ? this.plugin.getTardisArea().getNextSpot(area) : this.plugin.getTardisArea().getSemiRandomLocation(rsa.getArea().areaId());
        }
        return l;
    }

    private int getNumber(TARDISHandlesBlock thb, int i) {
        TARDISHandlesBlock numBlock;
        Object tmp = thb.getDisplayName();
        int n = 1;
        ItemStack num = this.program.getInventory()[i + n];
        while (num != null && (numBlock = TARDISHandlesBlock.BY_NAME.get(ComponentUtils.stripColour(num.getItemMeta().displayName()))).getCategory().equals((Object)TARDISHandlesCategory.NUMBER)) {
            tmp = (String)tmp + numBlock.getDisplayName();
            num = this.program.getInventory()[i + ++n];
        }
        return TARDISNumberParsers.parseInt((String)tmp);
    }

    private int find(TARDISHandlesBlock thb, int i) {
        if (i > 35) {
            return -1;
        }
        for (int n = i; n < 34; ++n) {
            TARDISHandlesBlock block;
            ItemStack yOrZ = this.program.getInventory()[n];
            if (yOrZ == null || (block = TARDISHandlesBlock.BY_NAME.get(ComponentUtils.stripColour(yOrZ.getItemMeta().displayName()))) != thb) continue;
            return n + 1;
        }
        return -1;
    }
}

