/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.hads;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISHADSEvent;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.HADS;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.hads.TARDISCloisterBell;
import me.eccentric_nz.TARDIS.hads.TARDISHostileDispersal;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

class TARDISHostileDisplacement {
    private final TARDIS plugin;
    private final List<Integer> angles = new ArrayList<Integer>(List.of(Integer.valueOf(0), Integer.valueOf(45), Integer.valueOf(90), Integer.valueOf(135), Integer.valueOf(180), Integer.valueOf(225), Integer.valueOf(270), Integer.valueOf(315)));
    private int count = 0;

    TARDISHostileDisplacement(TARDIS plugin) {
        this.plugin = plugin;
    }

    void moveTARDIS(int id, UUID uuid, Player hostile, ChameleonPreset preset) {
        TARDISTimeTravel tt = new TARDISTimeTravel(this.plugin);
        int r = this.plugin.getConfig().getInt("preferences.hads_distance");
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (!rsc.resultSet()) {
            this.plugin.debug("Could not get current TARDIS location for HADS!");
            return;
        }
        Current current = rsc.getCurrent();
        boolean underwater = current.submarine();
        Location l = current.location().clone();
        Collections.shuffle(this.angles);
        for (Integer a : this.angles) {
            ++this.count;
            int wx = (int)(l.getX() + (double)r * Math.cos(a.intValue()));
            int wz = (int)(l.getZ() + (double)r * Math.sin(a.intValue()));
            l.setX((double)wx);
            l.setZ((double)wz);
            boolean bool = true;
            int y = l.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) ? this.plugin.getUtils().getHighestNetherBlock(l.getWorld(), wx, wz) : TARDISStaticLocationGetters.getHighestYin3x3(l.getWorld(), wx, wz);
            l.setY((double)y);
            if (l.getBlock().getRelative(BlockFace.DOWN).isLiquid() && !this.plugin.getConfig().getBoolean("travel.land_on_water") && !current.submarine()) {
                bool = false;
            }
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (bool) {
                boolean safe;
                Location sub = null;
                if (current.submarine()) {
                    sub = tt.submarine(l.getBlock(), current.direction());
                    safe = sub != null;
                } else {
                    int[] start = TARDISTimeTravel.getStartLocation(l, current.direction());
                    boolean bl = safe = TARDISTimeTravel.safeLocation(start[0], y, start[2], start[1], start[3], l.getWorld(), current.direction()) < 1;
                }
                if (safe) {
                    Location fl;
                    Location location = fl = current.submarine() ? sub : l;
                    if (this.plugin.getPluginRespect().getRespect(fl, new Parameters(player, Flag.getNoMessageFlags()))) {
                        TARDISCloisterBell bell = new TARDISCloisterBell(this.plugin, 5, id, current.location(), this.plugin.getServer().getPlayer(uuid), true, "HADS displacement", false);
                        int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)bell, 2L, 70L);
                        bell.setTask(taskID);
                        this.plugin.getTrackerKeeper().getCloisterBells().put(id, taskID);
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            TARDISCloisterBell end = new TARDISCloisterBell(this.plugin, 6, id, fl, this.plugin.getServer().getPlayer(uuid), false, "", true);
                            int endTaskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)end, 2L, 70L);
                            end.setTask(endTaskID);
                            this.plugin.getTrackerKeeper().getCloisterBells().put(id, endTaskID);
                        }, 420L);
                        HashMap<String, Object> tid = new HashMap<String, Object>();
                        tid.put("tardis_id", id);
                        HashMap<String, Object> set = new HashMap<String, Object>();
                        set.put("world", fl.getWorld().getName());
                        set.put("x", fl.getBlockX());
                        set.put("y", fl.getBlockY());
                        set.put("z", fl.getBlockZ());
                        set.put("submarine", current.submarine() ? 1 : 0);
                        this.plugin.getQueryFactory().doUpdate("current", set, tid);
                        long delay = 1L;
                        this.plugin.getTrackerKeeper().getInVortex().add(id);
                        DestroyData dd = new DestroyData();
                        dd.setDirection(current.direction());
                        dd.setLocation(current.location());
                        dd.setPlayer((OfflinePlayer)player);
                        dd.setHide(false);
                        dd.setOutside(true);
                        dd.setSubmarine(current.submarine());
                        dd.setTardisID(id);
                        dd.setThrottle(SpaceTimeThrottle.NORMAL);
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            this.plugin.getTrackerKeeper().getDematerialising().add(id);
                            this.plugin.getPresetDestroyer().destroyPreset(dd);
                        }, delay);
                        BuildData bd = new BuildData(uuid.toString());
                        bd.setDirection(current.direction());
                        bd.setLocation(fl);
                        bd.setMalfunction(false);
                        bd.setOutside(true);
                        bd.setPlayer((OfflinePlayer)player);
                        bd.setRebuild(false);
                        bd.setSubmarine(current.submarine());
                        bd.setTardisID(id);
                        bd.setThrottle(SpaceTimeThrottle.NORMAL);
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getPresetBuilder().buildPreset(bd), delay * 2L);
                        this.plugin.getMessenger().sendHADS((CommandSender)player, this.plugin);
                        String hads = fl.getWorld().getName() + ":" + fl.getBlockX() + ":" + fl.getBlockY() + ":" + fl.getBlockZ();
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HADS_LOC", hads);
                        if (player != hostile) {
                            this.plugin.getMessenger().sendHADS((CommandSender)hostile, this.plugin);
                        }
                        this.plugin.getPM().callEvent((Event)new TARDISHADSEvent(hostile, id, fl, HADS.DISPLACEMENT));
                        break;
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HADS_PROTECTED");
                    if (player == hostile) continue;
                    this.plugin.getMessenger().send((CommandSender)hostile, TardisModule.TARDIS, "HADS_PROTECTED");
                    continue;
                }
                if (underwater) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HADS_NOT_SAFE");
                    continue;
                }
                if (this.count <= 7) continue;
                new TARDISHostileDispersal(this.plugin).disperseTARDIS(id, uuid, hostile, preset);
                continue;
            }
            this.plugin.getTrackerKeeper().getHadsDamage().remove(id);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HADS_NO_WATER");
        }
    }
}

