/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISShellBuilder;
import me.eccentric_nz.TARDIS.chameleon.TARDISChameleonPreset;
import me.eccentric_nz.TARDIS.chameleon.shell.ShellLoaderProblemBlocks;
import me.eccentric_nz.TARDIS.chameleon.shell.TARDISShellRoomConstructor;
import me.eccentric_nz.TARDIS.chameleon.shell.TARDISShellScanner;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISChameleonColumn;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetChameleon;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.Adaption;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateShellLoaderForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final Player player;

    public FloodgateShellLoaderForm(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.player = this.plugin.getServer().getPlayer(this.uuid);
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("TARDIS Shell Loader");
        builder.button("Current preset", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/control/chameleon_button.png");
        builder.button("Saved construct", FormImage.Type.URL, "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/chameleon/construct_button.png");
        for (ChameleonPreset preset : ChameleonPreset.values()) {
            if (ChameleonPreset.NOT_THESE.contains(preset.getCraftMaterial()) || preset.usesArmourStand() || !TARDISPermission.hasPermission(this.player, "tardis.preset." + preset.toString().toLowerCase(Locale.ROOT))) continue;
            String path = String.format("textures/blocks/%s.png", preset.getGuiDisplay().toString().toLowerCase(Locale.ROOT));
            builder.button(preset.getDisplayName(), FormImage.Type.PATH, path);
        }
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        String label = response.clickedButton().text();
        HashMap<String, Object> wheres = new HashMap<String, Object>();
        wheres.put("uuid", this.uuid.toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheres, false);
        if (rst.resultSet()) {
            int id = rst.getTardis_id();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Object rsc;
                ChameleonPreset preset;
                Tardis tardis = rs.getTardis();
                TARDISChameleonColumn chameleonColumn = null;
                if (label.equals("Current preset")) {
                    preset = tardis.getPreset();
                    chameleonColumn = !tardis.getAdaption().equals((Object)Adaption.OFF) ? TARDISShellScanner.scan(this.plugin, id, preset) : this.plugin.getPresets().getColumn(preset, COMPASS.EAST);
                } else if (label.equals("Saved construct")) {
                    String data;
                    preset = ChameleonPreset.CONSTRUCT;
                    HashMap<String, Object> wherec = new HashMap<String, Object>();
                    wherec.put("tardis_id", id);
                    rsc = new ResultSetChameleon(this.plugin, wherec);
                    if (((ResultSetChameleon)rsc).resultSet() && (data = ((ResultSetChameleon)rsc).getData().get("blueprintData")) != null) {
                        JsonArray json = JsonParser.parseString((String)data).getAsJsonArray();
                        String[][] strings = new String[10][4];
                        for (int i = 0; i < 10; ++i) {
                            JsonArray inner = json.get(i).getAsJsonArray();
                            for (int j = 0; j < 4; ++j) {
                                String block;
                                strings[i][j] = block = inner.get(j).getAsString();
                            }
                        }
                        chameleonColumn = TARDISChameleonPreset.buildTARDISChameleonColumn(COMPASS.EAST, strings);
                    }
                } else {
                    preset = ChameleonPreset.valueOf(label);
                    chameleonColumn = this.plugin.getPresets().getColumn(preset, COMPASS.EAST);
                }
                if (chameleonColumn != null) {
                    HashMap<String, Object> whereb = new HashMap<String, Object>();
                    whereb.put("tardis_id", id);
                    whereb.put("type", 25);
                    rsc = new ResultSetControls(this.plugin, whereb, false);
                    if (((ResultSetControls)rsc).resultSet()) {
                        int c;
                        Location button = TARDISStaticLocationGetters.getLocationFromBukkitString(((ResultSetControls)rsc).getLocation());
                        World w = button.getWorld();
                        int fx = button.getBlockX() + 2;
                        int fy = button.getBlockY() + 1;
                        int fz = button.getBlockZ() - 1;
                        for (c = 0; c < 10; ++c) {
                            for (int y = fy; y < fy + 4; ++y) {
                                Block block = w.getBlockAt(fx + TARDISShellRoomConstructor.orderx[c], y, fz + TARDISShellRoomConstructor.orderz[c]);
                                if (!ShellLoaderProblemBlocks.DO_FIRST.contains(block.getType())) continue;
                                block.setBlockData(TARDISConstants.AIR);
                            }
                        }
                        for (c = 0; c < 10; ++c) {
                            for (int y = fy; y < fy + 4; ++y) {
                                w.getBlockAt(fx + TARDISShellRoomConstructor.orderx[c], y, fz + TARDISShellRoomConstructor.orderz[c]).setBlockData(TARDISConstants.AIR);
                            }
                        }
                        Location centre = button.clone().add(3.0, 1.0, 0.0);
                        new TARDISShellBuilder(this.plugin, preset, chameleonColumn, centre, -1).buildPreset();
                    }
                }
            }
        }
    }
}

