/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.ARS.TARDISARS;
import me.eccentric_nz.TARDIS.ARS.TARDISARSMethods;
import me.eccentric_nz.TARDIS.ARS.TARDISARSSlot;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetARS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.move.TARDISDoorListener;
import me.eccentric_nz.TARDIS.travel.TARDISDoorLocation;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateMapForm {
    private static final Pattern JSON_FLUFF = Pattern.compile("[\"\\[\\]]");
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final List<String> STONE = List.of("STONE");
    private final UUID uuid;
    private final int id;
    private final String path = "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/room/%s.png";

    public FloodgateMapForm(TARDIS plugin, UUID uuid, int id) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.id = id;
        this.prefix = this.plugin.getPrefix();
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("TARDIS Map");
        builder.content("Click a room name to transmat to that room.");
        builder.button("Console");
        for (String room : this.getRooms(this.id)) {
            builder.button(room, FormImage.Type.URL, String.format("https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/room/%s.png", room.toLowerCase(Locale.ROOT)));
        }
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        Player player = this.plugin.getServer().getPlayer(this.uuid);
        String label = response.clickedButton().text();
        String mat = label.equals("Console") ? this.getConsoleMaterial(this.id) : TARDISARS.valueOf(label).getMaterial();
        Location location = this.getTransmatLocation(mat);
        if (location != null) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT");
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                player.playSound(location, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                player.teleport(location);
            }, 10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getRooms(int id) {
        ArrayList<String> data = new ArrayList<String>();
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT json FROM " + this.prefix + "ars WHERE tardis_id = " + id;
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    String json = JSON_FLUFF.matcher(rs.getString("json")).replaceAll("");
                    ArrayList<String> materials = new ArrayList<String>(List.of(json.split(",")));
                    materials.removeAll(this.STONE);
                    for (String material : materials) {
                        String room;
                        if (Desktops.getBY_MATERIALS().containsKey(material) || (room = TARDISARS.ARSFor(material).toString()).equals("RENDERER")) continue;
                        data.add(room);
                    }
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for ars getting floodgate rooms! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing ars table getting floodgate rooms! " + e.getMessage());
            }
        }
        return data;
    }

    private Location getTransmatLocation(String room) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", this.id);
        ResultSetARS rs = new ResultSetARS(this.plugin, where);
        if (rs.resultSet()) {
            String[][][] json = TARDISARSMethods.getGridFromJSON(rs.getJson());
            for (int l = 0; l < 3; ++l) {
                for (int r = 0; r < 9; ++r) {
                    for (int c = 0; c < 9; ++c) {
                        if (room.equals("Console") && Desktops.getBY_MATERIALS().containsKey(json[l][r][c])) {
                            TARDISDoorLocation idl = TARDISDoorListener.getDoor(1, this.id);
                            return idl.getL();
                        }
                        if (!json[l][r][c].equals(room)) continue;
                        TARDISARSSlot a = new TARDISARSSlot();
                        a.setChunk(this.plugin.getLocationUtils().getTARDISChunk(this.id));
                        a.setY(l);
                        a.setX(r);
                        a.setZ(c);
                        return new Location(a.getChunk().getWorld(), (double)a.getX(), (double)a.getY(), (double)a.getZ()).add(3.5, 5.0, 8.5);
                    }
                }
            }
        }
        return null;
    }

    private String getConsoleMaterial(int id) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Schematic console = rs.getTardis().getSchematic();
            return console.getSeedMaterial().toString();
        }
        return "IRON_BLOCK";
    }
}

