/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISGeneticManipulatorDisguiseEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISGeneticManipulatorUndisguiseEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.FloodgateSpawnEgg;
import me.eccentric_nz.TARDIS.lazarus.TARDISLazarusDisguise;
import me.eccentric_nz.TARDIS.lazarus.TARDISLazarusLibs;
import me.eccentric_nz.TARDIS.lazarus.TARDISLazarusRunnable;
import me.eccentric_nz.TARDIS.lazarus.disguise.AGE;
import me.eccentric_nz.TARDIS.lazarus.disguise.FOX;
import me.eccentric_nz.TARDIS.lazarus.disguise.GENE;
import me.eccentric_nz.TARDIS.lazarus.disguise.MUSHROOM_COW;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Cat;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateGeneticManipulatorForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final Block block;
    private final String path = "https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/spawn_eggs/%s.png";

    public FloodgateGeneticManipulatorForm(TARDIS plugin, UUID uuid, Block block) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.block = block;
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("Genetic Manipulator");
        builder.button("Restore original");
        for (Material m : FloodgateSpawnEgg.disguises) {
            builder.button(m.toString().replace("_SPAWN_EGG", ""), FormImage.Type.URL, String.format("https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/gui/spawn_eggs/%s.png", m.toString().toLowerCase(Locale.ROOT)));
        }
        builder.button("Master's Reverse Polarity");
        builder.validResultHandler(this::handleResponse);
        builder.closedOrInvalidResultHandler(response -> this.handleClose());
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        String label;
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        this.plugin.getTrackerKeeper().getGeneticManipulation().add(this.uuid);
        TARDISLazarusRunnable runnable = new TARDISLazarusRunnable(this.plugin, this.block);
        int taskId = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 6L, 6L);
        runnable.setTaskID(taskId);
        TARDISSounds.playTARDISSound(player.getLocation(), "lazarus_machine");
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            this.openDoor(this.block);
            this.untrack(this.uuid);
        }, 100L);
        switch (label = response.clickedButton().text()) {
            case "Master's Reverse Polarity": {
                if (!TARDISPermission.hasPermission(player, "tardis.themaster")) break;
                this.plugin.getTrackerKeeper().setImmortalityGate(player.getName());
                if (this.plugin.isDisguisesOnServer()) {
                    TARDISLazarusLibs.runImmortalityGate(player);
                } else {
                    TARDISLazarusDisguise.runImmortalityGate(player);
                }
                this.plugin.getMessenger().broadcast(TardisModule.TARDIS, "The Master (aka " + player.getName() + ") has cloned his genetic template to all players. Behold the Master Race!");
                this.plugin.getPM().callEvent((Event)new TARDISGeneticManipulatorDisguiseEvent(player, player.getName()));
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    this.plugin.getServer().getOnlinePlayers().forEach(p -> {
                        if (this.plugin.isDisguisesOnServer()) {
                            TARDISLazarusLibs.removeDisguise(p);
                        } else {
                            TARDISLazarusDisguise.removeDisguise(p);
                        }
                    });
                    this.plugin.getMessenger().broadcast(TardisModule.TARDIS, "Lord Rassilon has reset the Master Race back to human form.");
                    this.plugin.getTrackerKeeper().setImmortalityGate("");
                    this.plugin.getPM().callEvent((Event)new TARDISGeneticManipulatorUndisguiseEvent(player));
                }, 3600L);
                break;
            }
            case "Restore original": {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    if (this.plugin.isDisguisesOnServer()) {
                        TARDISLazarusLibs.removeDisguise(player);
                    } else {
                        TARDISLazarusDisguise.removeDisguise(player);
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GENETICS_RESTORED");
                    this.plugin.getPM().callEvent((Event)new TARDISGeneticManipulatorUndisguiseEvent(player));
                }, 80L);
                break;
            }
            default: {
                EntityType dt = EntityType.valueOf((String)label);
                Object[] options = null;
                switch (dt) {
                    case AXOLOTL: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, Axolotl.Variant.LUCY, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{Axolotl.Variant.WILD, AGE.ADULT};
                        break;
                    }
                    case FROG: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, Frog.Variant.TEMPERATE, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{Frog.Variant.TEMPERATE, AGE.ADULT};
                        break;
                    }
                    case CAT: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, Cat.Type.JELLIE, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{Cat.Type.JELLIE, false, AGE.ADULT};
                        break;
                    }
                    case PANDA: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, (Object)GENE.NORMAL, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{GENE.NORMAL, AGE.ADULT};
                        break;
                    }
                    case DONKEY: 
                    case MULE: 
                    case PIG: 
                    case OCELOT: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, null, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{false, AGE.ADULT};
                        break;
                    }
                    case PILLAGER: 
                    case BAT: 
                    case CREEPER: 
                    case ENDERMAN: 
                    case BLAZE: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, null, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{false};
                        break;
                    }
                    case SHEEP: 
                    case WOLF: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, DyeColor.LIME, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{DyeColor.LIME, false, AGE.ADULT};
                        break;
                    }
                    case HORSE: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, Horse.Color.DARK_BROWN, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{Horse.Color.DARK_BROWN, AGE.ADULT};
                        break;
                    }
                    case LLAMA: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, Llama.Color.BROWN, true, false).createDisguise();
                            break;
                        }
                        options = new Object[]{Llama.Color.BROWN, true, AGE.ADULT};
                        break;
                    }
                    case PARROT: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, Parrot.Variant.GREEN, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{Parrot.Variant.GREEN, AGE.ADULT};
                        break;
                    }
                    case RABBIT: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, Rabbit.Type.SALT_AND_PEPPER, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{Rabbit.Type.SALT_AND_PEPPER, false, AGE.ADULT};
                        break;
                    }
                    case VILLAGER: 
                    case ZOMBIE_VILLAGER: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, Villager.Profession.FARMER, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{Villager.Profession.FARMER, AGE.ADULT};
                        break;
                    }
                    case SLIME: 
                    case MAGMA_CUBE: 
                    case PUFFERFISH: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, 1, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{1};
                        break;
                    }
                    case COW: 
                    case TURTLE: 
                    case ZOMBIE: 
                    case BEE: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, null, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{AGE.ADULT};
                        break;
                    }
                    case SNOW_GOLEM: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, true, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{true};
                        break;
                    }
                    case TROPICAL_FISH: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, TropicalFish.Pattern.values()[0], false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{TropicalFish.Pattern.values()[0]};
                        break;
                    }
                    case MOOSHROOM: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, MushroomCow.Variant.RED, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{MUSHROOM_COW.getFromMushroomCowType(MushroomCow.Variant.RED), AGE.ADULT};
                        break;
                    }
                    case FOX: {
                        if (this.plugin.isDisguisesOnServer()) {
                            new TARDISLazarusLibs(player, label, Fox.Type.RED, false, false).createDisguise();
                            break;
                        }
                        options = new Object[]{FOX.getFromFoxType(Fox.Type.RED), AGE.ADULT};
                        break;
                    }
                    default: {
                        if (!this.plugin.isDisguisesOnServer()) break;
                        new TARDISLazarusLibs(player, label, null, false, false).createDisguise();
                    }
                }
                if (this.plugin.isDisguisesOnServer()) break;
                new TARDISLazarusDisguise(this.plugin, player, dt, options).createDisguise();
            }
        }
    }

    private void handleClose() {
        this.openDoor(this.block);
        this.untrack(this.uuid);
    }

    private void untrack(UUID uuid) {
        this.plugin.getTrackerKeeper().getLazarus().remove(uuid);
        this.plugin.getTrackerKeeper().getGeneticManipulation().remove(uuid);
        this.plugin.getTrackerKeeper().getGeneticallyModified().remove(uuid);
    }

    private void openDoor(Block block) {
        block.getRelative(BlockFace.SOUTH).setType(Material.AIR);
        block.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP).setType(Material.AIR);
    }
}

