/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.files;

import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBlocks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetGravity;
import me.eccentric_nz.TARDIS.utility.TARDISAntiBuild;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.util.Vector;

public class TARDISBlockLoader {
    private final TARDIS plugin;

    public TARDISBlockLoader(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void loadProtectedBlocks() {
        ResultSetBlocks rsb = new ResultSetBlocks(this.plugin, null, true);
        rsb.resultSetAsync((hasResult, resultSetBlocks) -> {
            if (hasResult) {
                resultSetBlocks.getData().forEach(rb -> this.plugin.getGeneralKeeper().getProtectBlockMap().put(rb.getStrLocation(), rb.getTardis_id()));
            }
        });
    }

    public void unloadProtectedBlocks(int id) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetBlocks rsb = new ResultSetBlocks(this.plugin, where, true);
        rsb.resultSetAsync((hasResult, resultSetBlocks) -> {
            if (hasResult) {
                resultSetBlocks.getData().forEach(rb -> this.plugin.getGeneralKeeper().getProtectBlockMap().remove(rb.getStrLocation()));
            }
        });
    }

    public void loadGravityWells() {
        ResultSetGravity rsg = new ResultSetGravity(this.plugin, null, true);
        if (rsg.resultSet()) {
            ArrayList<HashMap<String, String>> data = rsg.getData();
            block7: for (HashMap<String, String> map : data) {
                int i = TARDISNumberParsers.parseInt(map.get("direction"));
                Double[] values = new Double[]{Double.valueOf(map.get("direction")), Double.valueOf(map.get("distance")), Double.valueOf(map.get("velocity"))};
                switch (i) {
                    case 1: {
                        this.plugin.getGeneralKeeper().getGravityUpList().put(map.get("location"), values);
                        continue block7;
                    }
                    case 2: {
                        this.plugin.getGeneralKeeper().getGravityNorthList().put(map.get("location"), values);
                        continue block7;
                    }
                    case 3: {
                        this.plugin.getGeneralKeeper().getGravityWestList().put(map.get("location"), values);
                        continue block7;
                    }
                    case 4: {
                        this.plugin.getGeneralKeeper().getGravitySouthList().put(map.get("location"), values);
                        continue block7;
                    }
                    case 5: {
                        this.plugin.getGeneralKeeper().getGravityEastList().put(map.get("location"), values);
                        continue block7;
                    }
                }
                this.plugin.getGeneralKeeper().getGravityDownList().add(map.get("location"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAntiBuild() {
        TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
        Connection connection = service.getConnection();
        Statement statement = null;
        ResultSet rs = null;
        String prefix = this.plugin.getPrefix();
        String query = "SELECT " + prefix + "tardis.tardis_id, " + prefix + "tardis.owner, " + prefix + "tardis.chunk FROM " + prefix + "tardis, " + prefix + "player_prefs WHERE " + prefix + "player_prefs.build_on = 0 AND " + prefix + "player_prefs.uuid = " + prefix + "tardis.uuid";
        try {
            service.testConnection(connection);
            statement = connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Integer id = rs.getInt("tardis_id");
                    String tl = rs.getString("owner");
                    TARDISAntiBuild tab = new TARDISAntiBuild();
                    String[] split = rs.getString("chunk").split(":");
                    ProtectedRegion pr = this.plugin.getWorldGuardUtils().getRegion(split[0], tl);
                    if (pr == null) continue;
                    Vector min = new Vector(pr.getMinimumPoint().x(), pr.getMinimumPoint().y(), pr.getMinimumPoint().z());
                    Vector max = new Vector(pr.getMaximumPoint().x(), pr.getMaximumPoint().y(), pr.getMaximumPoint().z());
                    tab.setMin(min);
                    tab.setMax(max);
                    tab.setTimelord(tl);
                    this.plugin.getTrackerKeeper().getAntiBuild().put(id, tab);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for antibuild load! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing antibuild load! " + e.getMessage());
            }
        }
    }
}

