/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.display;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.display.TARDISDisplayType;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TARDISDisplayCommand
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final List<String> SUBS = new ArrayList<String>();

    public TARDISDisplayCommand(TARDIS plugin) {
        this.plugin = plugin;
        for (TARDISDisplayType dt : TARDISDisplayType.values()) {
            this.SUBS.add(dt.toString());
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            UUID uuid = p.getUniqueId();
            if (args.length == 0) {
                if (p.hasPermission("tardis.display")) {
                    if (this.plugin.getTrackerKeeper().getDisplay().containsKey(uuid)) {
                        this.plugin.getTrackerKeeper().getDisplay().remove(uuid);
                        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "DISPLAY_DISABLED");
                    } else {
                        this.plugin.getTrackerKeeper().getDisplay().put(uuid, TARDISDisplayType.ALL);
                        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "DISPLAY_ENABLED");
                    }
                } else {
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "DISPLAY_PERMISSION");
                }
            }
            if (args.length == 1) {
                try {
                    TARDISDisplayType displayType = TARDISDisplayType.valueOf(args[0].toUpperCase(Locale.ROOT));
                    this.plugin.getTrackerKeeper().getDisplay().put(uuid, displayType);
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "DISPLAY_ENABLED");
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "DISPLAY_INVALID");
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length <= 1) {
            return this.partial(args[0], this.SUBS);
        }
        return ImmutableList.of();
    }
}

