/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class TARDISTimeRotorLoader {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private int count = 0;

    public TARDISTimeRotorLoader(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    public void load() {
        try {
            this.ps = this.connection.prepareStatement("SELECT tardis_id, rotor FROM " + this.prefix + "tardis");
            this.rs = this.ps.executeQuery();
            if (this.rs.isBeforeFirst()) {
                while (this.rs.next()) {
                    String u = this.rs.getString("rotor");
                    if (u.isEmpty() || u.contains("Location")) continue;
                    try {
                        UUID uuid = UUID.fromString(u);
                        this.plugin.getGeneralKeeper().getTimeRotors().add(uuid);
                        ++this.count;
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.debug("Invalid Time Rotor UUID: " + e.getMessage());
                    }
                }
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Loaded " + this.count + " time rotors.");
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for time rotor loading: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing time rotor statement or resultset: " + ex.getMessage());
            }
        }
    }
}

