/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.customblocks;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISChemistryDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISLightDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISSeedDisplayItem;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class TARDISDisplayItemRegistry {
    private static final HashMap<String, TARDISDisplayItem> BY_ID = new HashMap();
    private static final HashMap<String, TARDISDisplayItem> BY_NAME = new HashMap();
    private static final HashMap<NamespacedKey, TARDISDisplayItem> BY_MODEL = new HashMap();
    private static final HashMap<Integer, TARDISDisplayItem> BY_MUSHROOM_STEM = new HashMap<Integer, TARDISDisplayItem>(){
        {
            this.put(1, TARDISChemistryDisplayItem.BLUE_LAMP);
            this.put(2, TARDISChemistryDisplayItem.RED_LAMP);
            this.put(3, TARDISChemistryDisplayItem.PURPLE_LAMP);
            this.put(4, TARDISChemistryDisplayItem.GREEN_LAMP);
            this.put(10000001, TARDISChemistryDisplayItem.BLUE_LAMP_ON);
            this.put(10000002, TARDISChemistryDisplayItem.RED_LAMP_ON);
            this.put(10000003, TARDISChemistryDisplayItem.PURPLE_LAMP_ON);
            this.put(10000004, TARDISChemistryDisplayItem.GREEN_LAMP_ON);
            this.put(5, TARDISChemistryDisplayItem.HEAT_BLOCK);
            this.put(46, TARDISBlockDisplayItem.HEXAGON);
            this.put(47, TARDISBlockDisplayItem.ROUNDEL);
            this.put(48, TARDISBlockDisplayItem.ROUNDEL_OFFSET);
            this.put(49, TARDISBlockDisplayItem.COG);
            this.put(50, TARDISBlockDisplayItem.ADVANCED_CONSOLE);
            this.put(51, TARDISBlockDisplayItem.DISK_STORAGE);
            this.put(54, TARDISBlockDisplayItem.BLUE_BOX);
        }
    };
    private static final HashMap<Integer, TARDISDisplayItem> BY_RED_MUSHROOM = new HashMap<Integer, TARDISDisplayItem>(){
        {
            this.put(40, TARDISChemistryDisplayItem.CREATIVE);
            this.put(41, TARDISChemistryDisplayItem.COMPOUND);
            this.put(42, TARDISChemistryDisplayItem.REDUCER);
            this.put(43, TARDISChemistryDisplayItem.CONSTRUCTOR);
            this.put(44, TARDISChemistryDisplayItem.LAB);
            this.put(45, TARDISChemistryDisplayItem.PRODUCT);
        }
    };

    public static void register(Class<? extends Enum<?>> enumClass) {
        for (Enum<?> constraint : enumClass.getEnumConstants()) {
            if (!(constraint instanceof TARDISDisplayItem)) continue;
            TARDISDisplayItem displayItem = (TARDISDisplayItem)((Object)constraint);
            TARDISDisplayItemRegistry.register(displayItem);
        }
    }

    public static void register(TARDISDisplayItem displayItem) {
        BY_ID.put(displayItem.getId(), displayItem);
        BY_NAME.put(displayItem.getName().toLowerCase(Locale.ROOT), displayItem);
        NamespacedKey customModel = displayItem.getCustomModel();
        if (customModel != null) {
            BY_MODEL.put(customModel, displayItem);
        }
    }

    public static TARDISDisplayItem getByModel(NamespacedKey key) {
        return BY_MODEL.get(key);
    }

    public static TARDISDisplayItem getByDisplayName(Component name) {
        for (TARDISDisplayItem tdi : BY_NAME.values()) {
            if (!ComponentUtils.stripColour(name).equals(tdi.getDisplayName())) continue;
            return tdi;
        }
        return null;
    }

    public static TARDISDisplayItem getByItemDisplay(ItemDisplay display) {
        ItemStack is = display.getItemStack();
        ItemMeta im = is.getItemMeta();
        if (im.hasItemModel()) {
            return TARDISDisplayItemRegistry.getByModel(im.getItemModel());
        }
        if (im.hasDisplayName()) {
            return TARDISDisplayItemRegistry.getByDisplayName(im.displayName());
        }
        return null;
    }

    public static HashMap<String, TARDISDisplayItem> getBY_NAME() {
        return BY_NAME;
    }

    public static HashMap<Integer, TARDISDisplayItem> getBY_MUSHROOM_STEM() {
        return BY_MUSHROOM_STEM;
    }

    public static HashMap<Integer, TARDISDisplayItem> getBY_RED_MUSHROOM() {
        return BY_RED_MUSHROOM;
    }

    public static Collection<TARDISDisplayItem> values() {
        return BY_NAME.values();
    }

    public static TARDISDisplayItem valueOf(String name) {
        return BY_ID.get(name);
    }

    static {
        for (TARDISBlockDisplayItem tARDISBlockDisplayItem : TARDISBlockDisplayItem.values()) {
            TARDISDisplayItemRegistry.register(tARDISBlockDisplayItem);
        }
        for (Enum enum_ : TARDISChemistryDisplayItem.values()) {
            TARDISDisplayItemRegistry.register((TARDISDisplayItem)((Object)enum_));
        }
        for (Enum enum_ : TARDISLightDisplayItem.values()) {
            TARDISDisplayItemRegistry.register((TARDISDisplayItem)((Object)enum_));
        }
        for (Enum enum_ : TARDISSeedDisplayItem.values()) {
            TARDISDisplayItemRegistry.register((TARDISDisplayItem)((Object)enum_));
        }
    }
}

