/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.exterior;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISBuilderUtility;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.flight.vehicle.TARDISArmourStand;
import me.eccentric_nz.TARDIS.flight.vehicle.VehicleUtility;
import me.eccentric_nz.TARDIS.move.TARDISDoorListener;
import me.eccentric_nz.TARDIS.travel.TARDISDoorLocation;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.craftbukkit.entity.CraftArmorStand;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;

public class TARDISInstantPoliceBox {
    private final TARDIS plugin;
    private final BuildData bd;
    private final ChameleonPreset preset;

    public TARDISInstantPoliceBox(TARDIS plugin, BuildData bd, ChameleonPreset preset) {
        this.plugin = plugin;
        this.bd = bd;
        this.preset = preset;
    }

    public void buildPreset() {
        World world = this.bd.getLocation().getWorld();
        if (this.plugin.getTrackerKeeper().getRescue().containsKey(this.bd.getTardisID())) {
            UUID playerUUID = this.plugin.getTrackerKeeper().getRescue().get(this.bd.getTardisID());
            Player saved = this.plugin.getServer().getPlayer(playerUUID);
            if (saved != null) {
                TARDISDoorLocation idl = TARDISDoorListener.getDoor(1, this.bd.getTardisID());
                Location l = idl.getL();
                this.plugin.getGeneralKeeper().getDoorListener().movePlayer(saved, l, false, world, false, 0, this.bd.useMinecartSounds(), false);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("tardis_id", this.bd.getTardisID());
                set.put("uuid", playerUUID.toString());
                this.plugin.getQueryFactory().doInsert("travellers", set);
            }
            this.plugin.getTrackerKeeper().getRescue().remove(this.bd.getTardisID());
        }
        Block block = this.bd.getLocation().getBlock();
        Block under = block.getRelative(BlockFace.DOWN);
        boolean slab = Tag.SLABS.isTagged((Keyed)under.getType());
        TARDISBuilderUtility.saveDoorLocation(this.bd, slab);
        TARDISBuilderUtility.updateChameleonDemat(this.preset.toString(), this.bd.getTardisID());
        this.plugin.getGeneralKeeper().getProtectBlockMap().put(this.bd.getLocation().getBlock().getRelative(BlockFace.DOWN).getLocation().toString(), this.bd.getTardisID());
        ItemFrame frame = null;
        ArmorStand stand = null;
        boolean found = false;
        Location spawn = slab ? this.bd.getLocation().subtract(0.0, 0.5, 0.0) : this.bd.getLocation();
        for (Entity e : world.getNearbyEntities(this.bd.getLocation(), 1.0, 1.0, 1.0)) {
            ItemFrame f;
            if (e instanceof ArmorStand) {
                ArmorStand a = (ArmorStand)e;
                if (((CraftArmorStand)a).getHandle() instanceof TARDISArmourStand) {
                    stand = a;
                } else {
                    stand = (ArmorStand)VehicleUtility.spawnStand(spawn).getBukkitEntity();
                    a.remove();
                }
                found = true;
                break;
            }
            if (!(e instanceof ItemFrame)) continue;
            frame = f = (ItemFrame)e;
            found = true;
            break;
        }
        if (!found || stand == null && frame != null) {
            if (frame != null) {
                frame.remove();
            }
            if (!slab) {
                TARDISBlockSetters.setUnderDoorBlock(world, under.getX(), under.getY(), under.getZ(), this.bd.getTardisID(), false);
            }
            stand = (ArmorStand)VehicleUtility.spawnStand(spawn).getBukkitEntity();
        }
        stand.setRotation(this.bd.getDirection().getYaw(), 0.0f);
        TARDISBuilderUtility.setPoliceBoxHelmet(this.plugin, this.preset, this.bd, stand);
        Levelled levelled = TARDISConstants.LIGHT;
        levelled.setLevel(this.bd.getExteriorLampLevel());
        block.getRelative(BlockFace.UP, 2).setBlockData((BlockData)levelled);
        TARDISDisplayItemUtils.setInteraction(stand, this.bd.getTardisID());
    }
}

