/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.ARS;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.ARS.ARS;
import me.eccentric_nz.TARDIS.ARS.TARDISARS;
import me.eccentric_nz.TARDIS.ARS.TARDISARSJettison;
import me.eccentric_nz.TARDIS.ARS.TARDISARSJettisonRunnable;
import me.eccentric_nz.TARDIS.ARS.TARDISARSMapData;
import me.eccentric_nz.TARDIS.ARS.TARDISARSProcessor;
import me.eccentric_nz.TARDIS.ARS.TARDISARSRunnable;
import me.eccentric_nz.TARDIS.ARS.TARDISARSSaveData;
import me.eccentric_nz.TARDIS.ARS.TARDISARSSlot;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.sudo.TARDISSudoTracker;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetARS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCondenser;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.RoomRequiredLister;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISARSMethods {
    final TARDIS plugin;
    final HashMap<UUID, Integer> scroll_start = new HashMap();
    final HashMap<UUID, Integer> selected_slot = new HashMap();
    final HashMap<UUID, TARDISARSSaveData> save_map_data = new HashMap();
    final HashMap<UUID, TARDISARSMapData> map_data = new HashMap();
    final Set<String> consoleBlocks = Desktops.getBY_MATERIALS().keySet();
    final HashMap<UUID, Integer> ids = new HashMap();
    final List<UUID> hasLoadedMap = new ArrayList<UUID>();
    private final String[] levels = new String[]{"Bottom level", "Main level", "Top level"};

    TARDISARSMethods(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static String[][][] getGridFromJSON(String js) {
        String[][][] grid = new String[3][9][9];
        JsonArray json = JsonParser.parseString((String)js).getAsJsonArray();
        for (int y = 0; y < 3; ++y) {
            JsonArray jsonx = json.get(y).getAsJsonArray();
            for (int x = 0; x < 9; ++x) {
                JsonArray jsonz = jsonx.get(x).getAsJsonArray();
                for (int z = 0; z < 9; ++z) {
                    grid[y][x][z] = jsonz.get(z).getAsString().equals("TNT") ? "STONE" : jsonz.get(z).getAsString();
                }
            }
        }
        return grid;
    }

    private void saveAll(UUID playerUUID) {
        TARDISARSMapData md = this.map_data.get(playerUUID);
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        JsonArray json = JsonParser.parseString((String)gson.toJson((Object)md.getData())).getAsJsonArray();
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("ars_x_east", md.getE());
        set.put("ars_z_south", md.getS());
        set.put("ars_y_layer", md.getY());
        set.put("json", json.toString());
        HashMap<String, Object> wherea = new HashMap<String, Object>();
        wherea.put("ars_id", md.getId());
        this.plugin.getQueryFactory().doUpdate("ars", set, wherea);
    }

    private void revert(UUID playerUUID) {
        TARDISARSSaveData sd = this.save_map_data.get(playerUUID);
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        JsonArray json = JsonParser.parseString((String)gson.toJson((Object)sd.getData())).getAsJsonArray();
        HashMap<String, String> set = new HashMap<String, String>();
        set.put("json", json.toString());
        HashMap<String, Integer> wherea = new HashMap<String, Integer>();
        wherea.put("ars_id", sd.getId());
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getQueryFactory().doUpdate("ars", set, wherea), 6L);
    }

    private String[][] sliceGrid(String[][] layer, int x, int z) {
        String[][] slice = new String[5][5];
        int indexx = 0;
        int indexz = 0;
        for (int xx = x; xx < x + 5; ++xx) {
            for (int zz = z; zz < z + 5; ++zz) {
                slice[indexx][indexz] = layer[xx][zz];
                ++indexz;
            }
            indexz = 0;
            ++indexx;
        }
        return slice;
    }

    void setSlot(InventoryView view, int slot, Material material, String room, UUID playerUUID, boolean showPerms) {
        ItemStack is = ItemStack.of((Material)material, (int)1);
        ItemMeta im = is.getItemMeta();
        im.displayName((Component)Component.text((String)room));
        if (!room.equals("Empty slot")) {
            Player player;
            ARS ars = TARDISARS.ARSFor(material.toString());
            String config_path = ars.getConfigPath();
            ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
            lore.add(Component.text((String)("Cost: " + this.plugin.getRoomsConfig().getInt("rooms." + config_path + ".cost"))));
            if (showPerms && (player = this.plugin.getServer().getPlayer(playerUUID)) != null && !TARDISPermission.hasPermission(player, "tardis.room." + config_path.toLowerCase(Locale.ROOT))) {
                lore.add(Component.text((String)this.plugin.getLanguage().getString("NO_PERM_CONSOLE", "No permission!"), (TextColor)NamedTextColor.RED));
            }
            im.lore(lore);
        } else {
            im.lore(null);
        }
        is.setItemMeta(im);
        view.setItem(slot, is);
    }

    void setSlot(InventoryView view, int slot, ItemStack is, UUID playerUUID, boolean update) {
        view.setItem(slot, is);
        String material = is.getType().toString();
        if (update) {
            this.updateGrid(playerUUID, slot, material);
        }
    }

    int[] getCoords(int slot, TARDISARSMapData md) {
        int[] coords = new int[2];
        if (slot <= 8) {
            coords[0] = slot - 4 + md.getE();
            coords[1] = md.getS();
        }
        if (slot > 8 && slot <= 17) {
            coords[0] = slot - 13 + md.getE();
            coords[1] = md.getS() + 1;
        }
        if (slot > 17 && slot <= 26) {
            coords[0] = slot - 22 + md.getE();
            coords[1] = md.getS() + 2;
        }
        if (slot > 26 && slot <= 35) {
            coords[0] = slot - 31 + md.getE();
            coords[1] = md.getS() + 3;
        }
        if (slot > 35 && slot <= 44) {
            coords[0] = slot - 40 + md.getE();
            coords[1] = md.getS() + 4;
        }
        return coords;
    }

    private void updateGrid(UUID playerUUID, int slot, String material) {
        TARDISARSMapData md = this.map_data.get(playerUUID);
        String[][][] grid = md.getData();
        int yy = md.getY();
        int[] coords = this.getCoords(slot, md);
        int newx = coords[0];
        int newz = coords[1];
        if (material.equals("SANDSTONE")) {
            if (yy < 2) {
                grid[yy + 1][newx][newz] = material;
            }
        } else if (material.equals("MOSSY_COBBLESTONE") && yy > 0) {
            grid[yy - 1][newx][newz] = material;
        }
        grid[yy][newx][newz] = material;
        md.setData(grid);
        this.map_data.put(playerUUID, md);
    }

    void setLore(InventoryView view, int slot, String str) {
        List<TextComponent> lore = str != null ? List.of(Component.text((String)str)) : null;
        ItemStack is = view.getItem(slot);
        ItemMeta im = is.getItemMeta();
        im.lore(lore);
        is.setItemMeta(im);
    }

    void switchLevel(InventoryView view, int slot, UUID playerUUID) {
        TARDISARSMapData md = this.map_data.get(playerUUID);
        for (int i = 27; i < 30; ++i) {
            Material material = Material.WHITE_WOOL;
            if (i == slot) {
                material = Material.YELLOW_WOOL;
                md.setY(i - 27);
                this.map_data.put(playerUUID, md);
            }
            ItemStack is = ItemStack.of((Material)material, (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)Component.text((String)this.levels[i - 27]));
            is.setItemMeta(im);
            this.setSlot(view, i, is, playerUUID, false);
        }
    }

    void close(Player player) {
        UUID playerUUID = player.getUniqueId();
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            this.scroll_start.remove(playerUUID);
            this.selected_slot.remove(playerUUID);
            this.hasLoadedMap.remove(playerUUID);
            if (this.map_data.containsKey(playerUUID)) {
                if (this.playerIsOwner(playerUUID, this.ids.get(playerUUID))) {
                    this.saveAll(playerUUID);
                    TARDISARSProcessor tap = new TARDISARSProcessor(this.plugin, this.ids.get(playerUUID));
                    boolean changed = tap.compare3DArray(this.save_map_data.get(playerUUID).getData(), this.map_data.get(playerUUID).getData());
                    if (changed && tap.checkCosts(tap.getChanged(), tap.getJettison())) {
                        if (this.plugin.getConfig().getBoolean("growth.rooms_require_blocks") && !TARDISSudoTracker.SUDOERS.containsKey(playerUUID) && !this.hasCondensables(playerUUID.toString(), tap.getChanged(), this.ids.get(playerUUID))) {
                            String message = tap.getChanged().size() > 1 ? "ARS_CONDENSE_MULTIPLE" : "ARS_CONDENSE";
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, message);
                            if (tap.getChanged().size() == 1) {
                                RoomRequiredLister.listCondensables(this.plugin, tap.getChanged().entrySet().iterator().next().getValue().toString(), player);
                            }
                            this.revert(playerUUID);
                            player.closeInventory();
                            return;
                        }
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARS_START");
                        if (!tap.getJettison().isEmpty()) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_JETT", String.format("%d", tap.getJettison().size()));
                            long del = 5L;
                            for (Map.Entry<TARDISARSJettison, ARS> map : tap.getJettison().entrySet()) {
                                TARDISARSJettisonRunnable jr = new TARDISARSJettisonRunnable(this.plugin, map.getKey(), map.getValue(), this.ids.get(playerUUID), player);
                                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)jr, del);
                                del += 5L;
                            }
                        }
                        long period = 2400L / this.plugin.getConfig().getLong("growth.delay_factor") * Math.round(20.0 / this.plugin.getConfig().getDouble("growth.room_speed"));
                        long delay = 20L;
                        int tasksRemaining = tap.getChanged().size();
                        for (Map.Entry<TARDISARSSlot, ARS> map : tap.getChanged().entrySet()) {
                            --tasksRemaining;
                            TARDISARSRunnable ar = new TARDISARSRunnable(this.plugin, map.getKey(), map.getValue(), player, this.ids.get(playerUUID));
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)ar, delay);
                            delay += period;
                        }
                        DamageUtility.run(this.plugin, DiskCircuit.ARS, this.plugin.getTardisAPI().getIdOfTARDISPlayerIsIn(playerUUID), player);
                    } else {
                        this.revert(playerUUID);
                        if (tap.getError().equals("ARS_LIMIT")) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, tap.getError(), this.plugin.getConfig().getString("growth.ars_limit"));
                        } else {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, tap.getError());
                        }
                    }
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_ONLY_TL");
                    this.revert(playerUUID);
                }
                this.map_data.remove(playerUUID);
                this.save_map_data.remove(playerUUID);
                this.ids.remove(playerUUID);
            }
            player.closeInventory();
        }, 1L);
    }

    void loadMap(InventoryView view, UUID playerUUID) {
        if (view.getItem(10).getItemMeta().hasLore()) {
            this.setLore(view, 10, this.plugin.getLanguage().getString("ARS_MAP_ERROR", "Map already loaded!"));
            return;
        }
        this.setLore(view, 10, "Loading...");
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", this.ids.get(playerUUID));
        ResultSetARS rs = new ResultSetARS(this.plugin, where);
        if (rs.resultSet()) {
            TARDISARSSaveData sd = new TARDISARSSaveData();
            TARDISARSMapData md = new TARDISARSMapData();
            String[][][] json = TARDISARSMethods.getGridFromJSON(rs.getJson());
            String[][][] json2 = TARDISARSMethods.getGridFromJSON(rs.getJson());
            sd.setData(json);
            sd.setId(rs.getId());
            md.setData(json2);
            md.setE(rs.getEast());
            md.setS(rs.getSouth());
            md.setY(rs.getLayer());
            md.setId(rs.getId());
            this.save_map_data.put(playerUUID, sd);
            this.map_data.put(playerUUID, md);
            this.setMap(rs.getLayer(), rs.getEast(), rs.getSouth(), playerUUID, view);
            this.saveAll(playerUUID);
            this.hasLoadedMap.add(playerUUID);
            this.setLore(view, 10, this.plugin.getLanguage().getString("ARS_MAP_LOADED", "Map LOADED"));
            this.switchLevel(view, 27 + rs.getLayer(), playerUUID);
        }
    }

    void setMap(int ul, int ue, int us, UUID playerUUID, InventoryView view) {
        TARDISARSMapData data = this.map_data.get(playerUUID);
        String[][][] grid = data.getData();
        String[][] layer = grid[ul];
        String[][] map = this.sliceGrid(layer, ue, us);
        int indexx = 0;
        int indexz = 0;
        for (int i = 4; i < 9; ++i) {
            for (int j = 0; j < 5; ++j) {
                int slot = i + j * 9;
                Material material = Material.valueOf((String)map[indexx][indexz]);
                String name = TARDISARS.ARSFor(map[indexx][indexz]).getDescriptiveName();
                this.setSlot(view, slot, material, name, playerUUID, false);
                ++indexz;
            }
            indexz = 0;
            ++indexx;
        }
    }

    void moveMap(UUID playerUUID, InventoryView view, int slot) {
        if (this.map_data.containsKey(playerUUID)) {
            int ue;
            TARDISARSMapData md = this.map_data.get(playerUUID);
            int us = switch (slot) {
                case 1 -> {
                    ue = md.getE();
                    yield md.getS() + 1 < 5 ? md.getS() + 1 : md.getS();
                }
                case 9 -> {
                    ue = md.getE() + 1 < 5 ? md.getE() + 1 : md.getE();
                    yield md.getS();
                }
                case 11 -> {
                    ue = md.getE() - 1 >= 0 ? md.getE() - 1 : md.getE();
                    yield md.getS();
                }
                default -> {
                    ue = md.getE();
                    yield md.getS() - 1 >= 0 ? md.getS() - 1 : md.getS();
                }
            };
            this.setMap(md.getY(), ue, us, playerUUID, view);
            this.setLore(view, slot, null);
            md.setE(ue);
            md.setS(us);
            this.map_data.put(playerUUID, md);
        } else {
            this.setLore(view, slot, this.plugin.getLanguage().getString("ARS_LOAD", "You need to load the map first!"));
        }
    }

    private boolean hasCondensables(String uuid, HashMap<TARDISARSSlot, ARS> map, int id) {
        boolean hasRequired = true;
        String wall = "ORANGE_WOOL";
        String floor = "LIGHT_GRAY_WOOL";
        boolean hasPrefs = false;
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid);
        if (rsp.resultSet()) {
            hasPrefs = true;
            wall = rsp.getWall();
            floor = rsp.getFloor();
        }
        HashMap<String, Integer> item_counts = new HashMap<String, Integer>();
        for (Map.Entry<TARDISARSSlot, ARS> entry : map.entrySet()) {
            HashMap<String, Integer> roomBlocks = this.plugin.getBuildKeeper().getRoomBlockCounts().get(entry.getValue().toString());
            for (Map.Entry<String, Integer> entry2 : roomBlocks.entrySet()) {
                int required;
                String bid = entry2.getKey();
                String bkey = hasPrefs && (bid.equals("ORANGE_WOOL") || bid.equals("LIGHT_GRAY_WOOL")) ? (bid.equals("ORANGE_WOOL") ? wall : floor) : bid;
                int tmp = Math.round((float)entry2.getValue().intValue() / 100.0f * (float)this.plugin.getConfig().getInt("growth.rooms_condenser_percent"));
                int n = required = tmp > 0 ? tmp : 1;
                if (item_counts.containsKey(bkey)) {
                    item_counts.put(bkey, (Integer)item_counts.get(bkey) + required);
                    continue;
                }
                item_counts.put(bkey, required);
            }
        }
        for (Map.Entry<TARDISARSSlot, ARS> entry : item_counts.entrySet()) {
            HashMap<String, Object> wherec = new HashMap<String, Object>();
            wherec.put("tardis_id", id);
            wherec.put("block_data", entry.getKey());
            ResultSetCondenser rsc = new ResultSetCondenser(this.plugin, wherec);
            if (rsc.resultSet()) {
                if (rsc.getBlock_count() >= (Integer)((Object)entry.getValue())) continue;
                hasRequired = false;
                continue;
            }
            hasRequired = false;
        }
        return hasRequired;
    }

    int getTardisId(String uuid) {
        int id = 0;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid);
        ResultSetTravellers rs = new ResultSetTravellers(this.plugin, where, false);
        if (rs.resultSet()) {
            id = rs.getTardis_id();
        }
        return id;
    }

    boolean hasRenderer(UUID playerUUID) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", this.ids.get(playerUUID));
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            return !rs.getTardis().getRenderer().isEmpty();
        }
        return false;
    }

    boolean checkSlotForConsole(InventoryView view, int slot) {
        Material m = view.getItem(slot).getType();
        return this.consoleBlocks.contains(m.toString());
    }

    private boolean playerIsOwner(UUID uuid, int id) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("uuid", TARDISSudoTracker.SUDOERS.getOrDefault(uuid, uuid).toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        return rs.resultSet();
    }
}

