/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.ARS;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.converters.lookup.LegacyIdTable;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class ARSConverter {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;

    public ARSConverter(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertARS() {
        Statement query = null;
        Statement update = null;
        ResultSet rs = null;
        int i = 0;
        try {
            this.service.testConnection(this.connection);
            this.connection.setAutoCommit(false);
            query = this.connection.prepareStatement("SELECT ars_id, json FROM " + this.prefix + "ars");
            update = this.connection.prepareStatement("UPDATE " + this.prefix + "ars set json = ? WHERE ars_id = ?");
            rs = query.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    int id = rs.getInt("ars_id");
                    String js = rs.getString("json");
                    if (rs.wasNull() || !js.contains("1")) continue;
                    String[][][] grid = new String[3][9][9];
                    JsonArray json = JsonParser.parseString((String)js).getAsJsonArray();
                    for (int y = 0; y < 3; ++y) {
                        JsonArray jsonx = json.get(y).getAsJsonArray();
                        for (int x = 0; x < 9; ++x) {
                            JsonArray jsonz = jsonx.get(x).getAsJsonArray();
                            for (int z = 0; z < 9; ++z) {
                                grid[y][x][z] = jsonz.get(z).getAsInt() == 46 ? "STONE" : LegacyIdTable.LOOKUP.get(jsonz.get(z).getAsInt()).toString();
                            }
                        }
                    }
                    Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                    JsonArray arr = JsonParser.parseString((String)gson.toJson((Object)grid)).getAsJsonArray();
                    update.setString(1, arr.toString());
                    update.setInt(2, id);
                    update.addBatch();
                    ++i;
                }
            }
            if (i > 0) {
                update.executeBatch();
                this.connection.commit();
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Converted " + i + " ARS records");
            }
            this.plugin.getConfig().set("conversions.ars_materials", (Object)true);
            this.plugin.saveConfig();
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for ars table! " + ex.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (query != null) {
                    query.close();
                }
                if (update != null) {
                    update.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing ars table! " + e.getMessage());
            }
        }
    }
}

