/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.weeping_angels;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;

public class AngelBuilder
implements Listener {
    private final TARDIS plugin;

    public AngelBuilder(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onSkullPlace(BlockPlaceEvent event) {
        if (event.getBlock().getType().equals((Object)Material.SKELETON_SKULL)) {
            Block placed = event.getBlockPlaced();
            Block below = placed.getRelative(BlockFace.DOWN);
            if (!below.getType().equals((Object)Material.COBBLESTONE_WALL)) {
                return;
            }
            Block bottom = below.getRelative(BlockFace.DOWN);
            if (!bottom.getType().equals((Object)Material.COBBLESTONE_WALL)) {
                return;
            }
            Block east = below.getRelative(BlockFace.EAST);
            Block west = below.getRelative(BlockFace.WEST);
            Block north = below.getRelative(BlockFace.NORTH);
            Block south = below.getRelative(BlockFace.SOUTH);
            if (east.getType().equals((Object)Material.COBBLESTONE_WALL) && west.getType().equals((Object)Material.COBBLESTONE_WALL) || north.getType().equals((Object)Material.COBBLESTONE_WALL) && south.getType().equals((Object)Material.COBBLESTONE_WALL)) {
                if (!TARDISPermission.hasPermission(event.getPlayer(), "tardisweepingangels.build.angel")) {
                    this.plugin.getMessenger().send((CommandSender)event.getPlayer(), TardisModule.MONSTERS, "WA_PERM_BUILD", "Weeping Angel!");
                    return;
                }
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    placed.setType(Material.AIR);
                    below.setType(Material.AIR);
                    bottom.setType(Material.AIR);
                    if (east.getType().equals((Object)Material.COBBLESTONE_WALL)) {
                        east.setType(Material.AIR);
                        west.setType(Material.AIR);
                    } else {
                        north.setType(Material.AIR);
                        south.setType(Material.AIR);
                    }
                    Location l = bottom.getLocation();
                    LivingEntity angel = new MonsterSpawner().create(l, Monster.WEEPING_ANGEL);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        new Equipper(Monster.WEEPING_ANGEL, angel, false).setHelmetAndInvisibility();
                        this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)angel, EntityType.SKELETON, Monster.WEEPING_ANGEL, l));
                    }, 5L);
                }, 20L);
            }
        }
    }
}

