/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.listeners;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.tardisvortexmanipulator.TVMUtils;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMQueryFactory;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetManipulator;
import me.eccentric_nz.tardisvortexmanipulator.gui.TVMGUI;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class TVMEquipListener
implements Listener {
    private final TARDIS plugin;
    private final HashSet<Material> transparent = new HashSet();

    public TVMEquipListener(TARDIS plugin) {
        this.plugin = plugin;
        this.transparent.add(Material.AIR);
        this.transparent.add(Material.ALLIUM);
        this.transparent.add(Material.AZURE_BLUET);
        this.transparent.add(Material.BLUE_ORCHID);
        this.transparent.add(Material.BROWN_MUSHROOM);
        this.transparent.add(Material.DANDELION);
        this.transparent.add(Material.DEAD_BUSH);
        this.transparent.add(Material.FERN);
        this.transparent.add(Material.SHORT_GRASS);
        this.transparent.add(Material.LARGE_FERN);
        this.transparent.add(Material.LILAC);
        this.transparent.add(Material.ORANGE_TULIP);
        this.transparent.add(Material.OXEYE_DAISY);
        this.transparent.add(Material.PEONY);
        this.transparent.add(Material.PINK_TULIP);
        this.transparent.add(Material.POPPY);
        this.transparent.add(Material.REDSTONE_WIRE);
        this.transparent.add(Material.RED_MUSHROOM);
        this.transparent.add(Material.RED_TULIP);
        this.transparent.add(Material.ROSE_BUSH);
        this.transparent.add(Material.SNOW);
        this.transparent.add(Material.SUNFLOWER);
        this.transparent.add(Material.TALL_GRASS);
        this.transparent.add(Material.VINE);
        this.transparent.add(Material.WHITE_TULIP);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerInteractEvent event) {
        TVMResultSetManipulator rs;
        Action action = event.getAction();
        if (!action.equals((Object)Action.RIGHT_CLICK_AIR) && !action.equals((Object)Action.LEFT_CLICK_AIR)) {
            return;
        }
        Player player = event.getPlayer();
        if (!TARDISPermission.hasPermission(player, "vm.teleport")) {
            return;
        }
        ItemStack is = player.getInventory().getItemInMainHand();
        if (is.hasItemMeta() && is.getItemMeta().hasDisplayName() && ComponentUtils.endsWith(is.getItemMeta().displayName(), "Vortex Manipulator") && (rs = new TVMResultSetManipulator(this.plugin, player.getUniqueId().toString())).resultSet()) {
            if (action.equals((Object)Action.RIGHT_CLICK_AIR)) {
                player.openInventory(new TVMGUI(this.plugin, rs.getTachyonLevel()).getInventory());
            } else if (this.plugin.getVortexConfig().getBoolean("allow.look_at_block") && TARDISPermission.hasPermission(player, "vm.lookatblock")) {
                UUID uuid = player.getUniqueId();
                int maxDistance = this.plugin.getVortexConfig().getInt("max_look_at_distance");
                Location bl = player.getTargetBlock(this.transparent, maxDistance).getLocation();
                bl.add(0.0, 1.0, 0.0);
                ArrayList<Player> players = new ArrayList<Player>();
                players.add(player);
                if (this.plugin.getVortexConfig().getBoolean("allow.multiple")) {
                    player.getNearbyEntities(0.5, 0.5, 0.5).forEach(e -> {
                        if (e instanceof Player && !e.getUniqueId().equals(uuid)) {
                            players.add((Player)e);
                        }
                    });
                }
                int required = this.plugin.getVortexConfig().getInt("tachyon_use.travel.to_block");
                int actual = required * players.size();
                if (!TVMUtils.checkTachyonLevel(uuid.toString(), actual)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NEED_TACHYON", actual);
                    return;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_STANDBY");
                if (TARDISConstants.RANDOM.nextInt(100) < this.plugin.getVortexConfig().getInt("block_travel_malfunction_chance")) {
                    this.plugin.debug(String.valueOf(player.displayName()) + " has malfunctioned");
                    Parameters params = new Parameters(player, Flag.getAPIFlags());
                    Location _bl = null;
                    int retries = 0;
                    while (_bl == null) {
                        _bl = this.plugin.getTardisAPI().getRandomLocation(this.plugin.getTardisAPI().getWorlds(), null, params);
                        if (++retries < 10) continue;
                    }
                    if (_bl != null) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MALFUNCTION");
                        bl = _bl;
                    }
                }
                TVMUtils.movePlayers(players, bl, player.getLocation().getWorld());
                new TVMQueryFactory(this.plugin).alterTachyons(uuid.toString(), -actual);
            }
        }
    }
}

