/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen.populators;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.GallifeyStructureUtility;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.TARDISLootTables;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.BlockVector;

public class GallifreyStructurePopulator
extends BlockPopulator {
    final List<Material> buildable = List.of(Material.RED_SAND, Material.WATER, Material.TERRACOTTA, Material.BROWN_TERRACOTTA, Material.LIGHT_GRAY_TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.RED_TERRACOTTA, Material.WHITE_TERRACOTTA);
    private final TARDIS plugin;

    public GallifreyStructurePopulator(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void populate(WorldInfo worldInfo, Random random, int x, int z, LimitedRegion limitedRegion) {
        if (this.isFeatureChunk(worldInfo.getSeed(), x, z)) {
            int startX = x * 16;
            int startY = 128;
            int startZ = z * 16;
            for (int i = 128; i > 60 && !this.buildable.contains(limitedRegion.getType(startX, startY, startZ)); --i) {
                --startY;
            }
            if (limitedRegion.isInRegion(startX, startY, startZ) && limitedRegion.getBuffer() > 15) {
                int dir = random.nextInt(4);
                List<BlockVector> grid = switch (dir) {
                    case 0 -> GallifeyStructureUtility.vectorLeft;
                    case 1 -> GallifeyStructureUtility.vectorUp;
                    case 2 -> GallifeyStructureUtility.vectorRight;
                    default -> GallifeyStructureUtility.vectorDown;
                };
                int i = 0;
                for (BlockVector vector : grid) {
                    this.build(limitedRegion, startX + vector.getBlockX(), i == 0 ? startY + vector.getBlockY() : -99, startZ + vector.getBlockZ(), random, GallifeyStructureUtility.structures.get(i));
                    ++i;
                }
            }
        }
    }

    public boolean isFeatureChunk(long seed, int x, int z) {
        RandomSpreadStructurePlacement spread = new RandomSpreadStructurePlacement(20, 10, RandomSpreadType.TRIANGULAR, 10387321);
        ChunkPos chunkPos = spread.getPotentialStructureChunk(seed, x, z);
        return chunkPos.x == x && chunkPos.z == z;
    }

    private void build(LimitedRegion limitedRegion, int startX, int startY, int startZ, Random random, String which) {
        String path = "schematics/gallifrey_" + which + ".tschm";
        InputStream stream = this.plugin.getResource(path);
        if (stream != null) {
            JsonObject obj = TARDISSchematicGZip.unzip(stream);
            JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
            int h = dimensions.get("height").getAsInt() - 1;
            int w = dimensions.get("width").getAsInt();
            int d = dimensions.get("length").getAsInt() - 1;
            int level = 0;
            int row = 0;
            if (startY == -99) {
                startY = 129;
                for (int i = 128; i > 60 && !this.buildable.contains(limitedRegion.getType(startX, startY, startZ)); --i) {
                    --startY;
                }
                ++startY;
            }
            JsonArray arr = obj.get("input").getAsJsonArray();
            while (level <= h && row < w) {
                JsonArray floor = arr.get(level).getAsJsonArray();
                JsonArray r = floor.get(row).getAsJsonArray();
                for (int col = 0; col <= d; ++col) {
                    JsonObject c = r.get(col).getAsJsonObject();
                    int x = startX + row;
                    int y = startY + level;
                    int z = startZ + col;
                    BlockData data = this.plugin.getServer().createBlockData(c.get("data").getAsString());
                    Material type = data.getMaterial();
                    if (limitedRegion.isInRegion(x, y, z)) {
                        switch (type) {
                            case CHEST: {
                                limitedRegion.setBlockData(x, y, z, data);
                                if (!limitedRegion.getType(x, y, z).equals((Object)Material.CHEST)) break;
                                Chest container = (Chest)limitedRegion.getBlockState(x, y, z);
                                container.setLootTable(TARDISLootTables.LOOT.get(random.nextInt(11)));
                                container.update();
                                break;
                            }
                            case SPONGE: {
                                break;
                            }
                            case SPAWNER: {
                                limitedRegion.setBlockData(x, y, z, data);
                                CreatureSpawner cs = (CreatureSpawner)limitedRegion.getBlockState(x, y, z);
                                cs.setSpawnedType(EntityType.VILLAGER);
                                cs.update();
                                break;
                            }
                            default: {
                                limitedRegion.setBlockData(x, y, z, data);
                                if (level != 0) break;
                                int yy = y - 1;
                                while (limitedRegion.getType(x, yy, z).isAir() || limitedRegion.getType(x, yy, z).equals((Object)Material.WATER)) {
                                    limitedRegion.setType(x, yy, z, Material.RED_SAND);
                                    --yy;
                                }
                                break block0;
                            }
                        }
                    }
                    if (col == d && row < w) {
                        ++row;
                    }
                    if (col != d || row != w || level >= h) continue;
                    row = 0;
                    ++level;
                }
            }
        }
    }
}

