/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen;

import java.util.List;
import java.util.Random;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardischunkgenerator.worldgen.biomeproviders.TARDISVoidBiomeProvider;
import me.eccentric_nz.tardischunkgenerator.worldgen.populators.RoomPopulator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;

public class RoomGenerator
extends ChunkGenerator {
    private final TARDIS plugin;

    public RoomGenerator(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void generateBedrock(WorldInfo worldInfo, Random random, int x, int z, ChunkGenerator.ChunkData chunkData) {
        for (int bx = 0; bx < 16; ++bx) {
            for (int bz = 0; bz < 16; ++bz) {
                chunkData.setBlock(bx, 63, bz, Material.BEDROCK);
            }
        }
    }

    public BiomeProvider getDefaultBiomeProvider(WorldInfo worldInfo) {
        return new TARDISVoidBiomeProvider();
    }

    public Location getFixedSpawnLocation(World world, Random random) {
        return new Location(world, 8.0, 68.0, 8.0);
    }

    public boolean shouldGenerateNoise() {
        return false;
    }

    public boolean shouldGenerateSurface() {
        return false;
    }

    public boolean shouldGenerateCaves() {
        return false;
    }

    public boolean shouldGenerateDecorations() {
        return false;
    }

    public boolean shouldGenerateMobs() {
        return false;
    }

    public boolean shouldGenerateStructures() {
        return false;
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        List populators = super.getDefaultPopulators(world);
        populators.add(new RoomPopulator(this.plugin));
        return populators;
    }
}

