/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.reducer;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.tardischemistry.compound.Compound;
import me.eccentric_nz.tardischemistry.element.Element;
import me.eccentric_nz.tardischemistry.element.ElementBuilder;
import me.eccentric_nz.tardischemistry.reducer.ReducerInventory;
import me.eccentric_nz.tardischemistry.reducer.Reduction;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ReducerGUIListener
extends TARDISMenuListener {
    public ReducerGUIListener(TARDIS plugin) {
        super(plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onCompoundMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof ReducerInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 26) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                TARDIS.plugin.debug("ReducerGUIListener");
                event.setCancelled(true);
            }
            return;
        }
        switch (slot) {
            case 0: 
            case 9: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 17: {
                event.setCancelled(true);
                this.reduce(event.getClickedInventory(), player);
                break;
            }
            case 26: {
                event.setCancelled(true);
                this.close(player);
                break;
            }
            default: {
                event.setCancelled(true);
            }
        }
    }

    private void reduce(Inventory inventory, Player player) {
        ItemStack is = inventory.getItem(0);
        if (is != null) {
            Material material = is.getType();
            if (material.equals((Object)Material.GLASS_BOTTLE) && is.hasItemMeta()) {
                ItemMeta im = is.getItemMeta();
                if (im.hasDisplayName()) {
                    String c = ComponentUtils.stripColour(im.displayName()).replace(" ", "_");
                    for (Compound compound : Compound.values()) {
                        if (!compound.toString().equals(c)) continue;
                        this.reduce(compound.getFormula(), inventory, player);
                        return;
                    }
                }
            } else {
                for (Reduction reduction : Reduction.values()) {
                    if (!reduction.getMaterial().equals((Object)material)) continue;
                    this.reduce(reduction.getElements(), inventory, player);
                    return;
                }
            }
        }
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
    }

    private void reduce(String data, Inventory inventory, Player player) {
        String[] elements = data.split("-");
        int i = 18;
        for (String e : elements) {
            String[] split = e.split(":");
            Element element = Element.valueOf(split[0]);
            ItemStack chemical = ElementBuilder.getElement(element);
            chemical.setAmount(Integer.parseInt(split[1]));
            if (i > 25) {
                i = 9;
            }
            inventory.setItem(i, chemical);
            ++i;
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            inventory.setItem(0, null);
        }
    }
}

