/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.microscope;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardischemistry.microscope.ComputerInventory;
import me.eccentric_nz.tardischemistry.microscope.FileCabinetInventory;
import me.eccentric_nz.tardischemistry.microscope.LabEquipment;
import me.eccentric_nz.tardischemistry.microscope.MicroscopeUtils;
import me.eccentric_nz.tardischemistry.microscope.SlideInventory;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Rotation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MicroscopeItemFrameListener
implements Listener {
    private final TARDIS plugin;

    MicroscopeItemFrameListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInteractEntity(PlayerInteractAtEntityEvent event) {
        if (event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            if (!frame.getPersistentDataContainer().has(this.plugin.getMicroscopeKey(), PersistentDataType.INTEGER)) {
                return;
            }
            event.setCancelled(true);
            frame.setRotation(this.getPreviousRotation(frame.getRotation()));
            Player player = event.getPlayer();
            if (MicroscopeUtils.STORED_STACKS.containsKey(player.getUniqueId())) {
                return;
            }
            ItemStack dye = frame.getItem();
            if (dye.getType().isAir()) {
                return;
            }
            if (!LabEquipment.getByMaterial().containsKey(dye.getType())) {
                return;
            }
            ItemStack is = player.getInventory().getItemInMainHand();
            ItemMeta im = is.getItemMeta();
            LabEquipment equipment = LabEquipment.getByMaterial().get(dye.getType());
            switch (equipment) {
                case SLIDE_RACK: {
                    if (MicroscopeUtils.hasItemInHand(is, Material.GLASS, this.plugin)) {
                        MicroscopeUtils.reduceInHand(player);
                        break;
                    }
                    player.openInventory(new SlideInventory(this.plugin).getInventory());
                    break;
                }
                case MICROSCOPE: {
                    String key;
                    if (MicroscopeUtils.hasItemInHand(is, Material.GLASS, this.plugin)) {
                        key = (String)im.getPersistentDataContainer().get(this.plugin.getMicroscopeKey(), PersistentDataType.STRING);
                        frame.getPersistentDataContainer().set(this.plugin.getMicroscopeKey(), PersistentDataType.STRING, (Object)key);
                    } else {
                        key = (String)frame.getPersistentDataContainer().get(this.plugin.getMicroscopeKey(), PersistentDataType.STRING);
                    }
                    MicroscopeUtils.STORED_STACKS.put(player.getUniqueId(), is);
                    ItemStack slide = ItemStack.of((Material)Material.GLASS, (int)1);
                    ItemMeta slideMeta = slide.getItemMeta();
                    String[] split = key.split("/");
                    slideMeta.displayName((Component)Component.text((String)TARDISStringUtils.sentenceCase(split[1])));
                    slideMeta.setItemModel(new NamespacedKey((Plugin)this.plugin, key));
                    slide.setItemMeta(slideMeta);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.getInventory().setItemInMainHand(slide), 1L);
                    break;
                }
                case COMPUTER_MONITOR: {
                    if (MicroscopeUtils.hasItemInHand(is, Material.LIME_STAINED_GLASS, this.plugin)) {
                        MicroscopeUtils.reduceInHand(player);
                        break;
                    }
                    player.openInventory(new ComputerInventory(this.plugin).getInventory());
                    break;
                }
                case ELECTRON_MICROSCOPE: {
                    String key;
                    if (MicroscopeUtils.hasItemInHand(is, Material.LIME_STAINED_GLASS, this.plugin)) {
                        key = (String)im.getPersistentDataContainer().get(this.plugin.getMicroscopeKey(), PersistentDataType.STRING);
                        frame.getPersistentDataContainer().set(this.plugin.getMicroscopeKey(), PersistentDataType.STRING, (Object)key);
                    } else {
                        key = (String)frame.getPersistentDataContainer().get(this.plugin.getMicroscopeKey(), PersistentDataType.STRING);
                    }
                    MicroscopeUtils.STORED_STACKS.put(player.getUniqueId(), is);
                    ItemStack screen = ItemStack.of((Material)Material.LIME_STAINED_GLASS, (int)1);
                    ItemMeta screenMeta = screen.getItemMeta();
                    String[] split = key.split("/");
                    screenMeta.displayName((Component)Component.text((String)TARDISStringUtils.sentenceCase(split[1])));
                    screenMeta.setItemModel(new NamespacedKey((Plugin)this.plugin, key));
                    screen.setItemMeta(screenMeta);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.getInventory().setItemInMainHand(screen), 1L);
                    break;
                }
                case FILING_CABINET: {
                    if (MicroscopeUtils.hasItemInHand(is, Material.GRAY_STAINED_GLASS, this.plugin)) {
                        MicroscopeUtils.reduceInHand(player);
                        break;
                    }
                    player.openInventory(new FileCabinetInventory(this.plugin).getInventory());
                    break;
                }
                default: {
                    String key;
                    if (MicroscopeUtils.hasItemInHand(is, Material.GRAY_STAINED_GLASS, this.plugin)) {
                        key = (String)im.getPersistentDataContainer().get(this.plugin.getMicroscopeKey(), PersistentDataType.STRING);
                        frame.getPersistentDataContainer().set(this.plugin.getMicroscopeKey(), PersistentDataType.STRING, (Object)key);
                    } else {
                        key = (String)frame.getPersistentDataContainer().get(this.plugin.getMicroscopeKey(), PersistentDataType.STRING);
                    }
                    MicroscopeUtils.STORED_STACKS.put(player.getUniqueId(), is);
                    ItemStack helmet = ItemStack.of((Material)Material.GRAY_STAINED_GLASS, (int)1);
                    ItemMeta helmetMeta = helmet.getItemMeta();
                    String[] split = key.split("/");
                    helmetMeta.displayName((Component)Component.text((String)TARDISStringUtils.sentenceCase(split[1])));
                    helmetMeta.setItemModel(new NamespacedKey((Plugin)this.plugin, key));
                    helmet.setItemMeta(helmetMeta);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.getInventory().setItemInMainHand(helmet), 1L);
                }
            }
        }
    }

    private Rotation getPreviousRotation(Rotation rotation) {
        int max = Rotation.values().length - 1;
        int ord = rotation.ordinal() - 1;
        if (ord < 0) {
            ord = max;
        }
        return Rotation.values()[ord];
    }
}

