/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.lab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Snow;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public class HeatBlockRunnable
implements Runnable {
    private static final List<Vector> INNER_VECTORS = new ArrayList<Vector>(List.of(new Vector(-1.0, 0.0, 1.0), new Vector(0.0, 0.0, 1.0), new Vector(1.0, 0.0, 1.0), new Vector(-1.0, 0.0, 0.0), new Vector(1.0, 0.0, 0.0), new Vector(-1.0, 0.0, -1.0), new Vector(0.0, 0.0, -1.0), new Vector(1.0, 0.0, -1.0)));
    private static final List<Vector> OUTER_VECTORS = new ArrayList<Vector>(List.of(new Vector(-2.0, 0.0, 2.0), new Vector(-1.0, 0.0, 2.0), new Vector(0.0, 0.0, 2.0), new Vector(1.0, 0.0, 2.0), new Vector(2.0, 0.0, 2.0), new Vector(-2.0, 0.0, 1.0), new Vector(2.0, 0.0, 1.0), new Vector(-2.0, 0.0, 0.0), new Vector(2.0, 0.0, 0.0), new Vector(-2.0, 0.0, -1.0), new Vector(2.0, 0.0, -1.0), new Vector(-2.0, 0.0, -2.0), new Vector(-1.0, 0.0, -2.0), new Vector(0.0, 0.0, -2.0), new Vector(1.0, 0.0, -2.0), new Vector(2.0, 0.0, -2.0)));
    private final TARDIS plugin;

    public HeatBlockRunnable(TARDIS plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        for (String s : this.plugin.getTrackerKeeper().getHeatBlocks()) {
            ItemStack is;
            ItemDisplay display;
            Location location = TARDISStaticLocationGetters.getLocationFromBukkitString(s);
            if (location == null || location.getBlock().getType() != Material.BARRIER || (display = TARDISDisplayItemUtils.get(location.getBlock())) == null || (is = display.getItemStack()).getType() != Material.RED_CONCRETE || !is.hasItemMeta() || !is.getItemMeta().getPersistentDataContainer().has(this.plugin.getCustomBlockKey(), PersistentDataType.STRING)) continue;
            this.meltBlock(location);
        }
    }

    private void meltBlock(Location location) {
        if (location != null) {
            int inner_count = 0;
            World world = location.getWorld();
            if (world != null) {
                Collections.shuffle(INNER_VECTORS);
                for (Vector inner : INNER_VECTORS) {
                    if (TARDISConstants.RANDOM.nextInt(100) <= 25) continue;
                    Block ib = location.getWorld().getHighestBlockAt(location.clone().add(inner));
                    Material im = ib.getType();
                    if (im.equals((Object)Material.SNOW)) {
                        Snow snow = (Snow)ib.getBlockData();
                        int layers = snow.getLayers() - 1;
                        if (layers > 0) {
                            snow.setLayers(layers);
                            ib.setBlockData((BlockData)snow);
                        } else {
                            ib.setBlockData(TARDISConstants.AIR);
                        }
                        return;
                    }
                    if (im.equals((Object)Material.ICE) || im.equals((Object)Material.PACKED_ICE)) {
                        ib.setBlockData(TARDISConstants.WATER);
                        return;
                    }
                    if (++inner_count != 8) continue;
                    Collections.shuffle(OUTER_VECTORS);
                    for (Vector outer : OUTER_VECTORS) {
                        Block ob = location.getWorld().getHighestBlockAt(location.clone().add(outer));
                        Material om = ob.getType();
                        if (om.equals((Object)Material.SNOW)) {
                            ob.setBlockData(TARDISConstants.AIR);
                            return;
                        }
                        if (!om.equals((Object)Material.ICE) && !om.equals((Object)Material.PACKED_ICE)) continue;
                        ob.setBlockData(TARDISConstants.WATER);
                        return;
                    }
                }
            }
        }
    }
}

