/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardischemistry.creative.CompoundsCreativeInventory;
import me.eccentric_nz.tardischemistry.creative.ProductsCreativeInventory;
import me.eccentric_nz.tardischemistry.element.Element;
import me.eccentric_nz.tardischemistry.element.ElementBuilder;
import me.eccentric_nz.tardischemistry.element.ElementInventory;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ElementGUIListener
implements Listener {
    private final TARDIS plugin;
    private final HashMap<UUID, Integer> scroll = new HashMap();
    private final List<UUID> scrolling = new ArrayList<UUID>();
    private final ItemStack[][] blocks;
    private final int rows;

    public ElementGUIListener(TARDIS plugin) {
        this.plugin = plugin;
        this.rows = Element.values().length / 8 + 1;
        this.blocks = this.getWallBlocks();
    }

    @EventHandler
    public void onElementMenuOpen(InventoryOpenEvent event) {
        if (event.getInventory().getHolder(false) instanceof ElementInventory) {
            Player p = (Player)event.getPlayer();
            this.scroll.put(p.getUniqueId(), 0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onElementMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof ElementInventory)) {
            return;
        }
        Player p = (Player)event.getWhoClicked();
        UUID uuid = p.getUniqueId();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                this.plugin.debug("ElementGUIListener");
                event.setCancelled(true);
            }
            return;
        }
        InventoryView view = event.getView();
        switch (slot) {
            case 8: {
                event.setCancelled(true);
                if (this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scroll(view, this.scroll.get(uuid) + 1, true, uuid);
                break;
            }
            case 17: {
                event.setCancelled(true);
                if (this.scrolling.contains(uuid)) break;
                this.scrolling.add(uuid);
                this.scroll(view, this.scroll.get(uuid) - 1, false, uuid);
                break;
            }
            case 26: {
                event.setCancelled(true);
                break;
            }
            case 35: {
                event.setCancelled(true);
                this.close(p);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    CompoundsCreativeInventory compounds = new CompoundsCreativeInventory(this.plugin);
                    p.openInventory(compounds.getInventory());
                }, 2L);
                break;
            }
            case 44: {
                event.setCancelled(true);
                this.close(p);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    ProductsCreativeInventory lab = new ProductsCreativeInventory(this.plugin);
                    p.openInventory(lab.getInventory());
                }, 2L);
                break;
            }
            case 53: {
                event.setCancelled(true);
                this.close(p);
                break;
            }
            default: {
                event.setCancelled(true);
                ItemStack choice = view.getItem(slot).clone();
                choice.setAmount(event.getClick().equals((Object)ClickType.SHIFT_LEFT) ? 64 : 1);
                p.getInventory().addItem(new ItemStack[]{choice});
            }
        }
    }

    private void scroll(InventoryView view, int row, boolean up, UUID uuid) {
        if (up && row < this.rows - 5 || !up && row >= 0) {
            this.scroll.put(uuid, row);
            this.setSlots(view, row, uuid);
        } else {
            this.scrolling.remove(uuid);
        }
    }

    private void setSlots(InventoryView view, int row, UUID uuid) {
        int slot = 0;
        for (int r = row; r < row + 6; ++r) {
            for (int c = 0; c < 8; ++c) {
                view.setItem(slot, this.blocks[r][c]);
                if (slot % 9 == 7) {
                    slot += 2;
                    continue;
                }
                ++slot;
            }
        }
        this.scrolling.remove(uuid);
    }

    private ItemStack[][] getWallBlocks() {
        ItemStack[][] stacks = new ItemStack[this.rows][8];
        int r = 0;
        int c = 0;
        for (Element entry : Element.values()) {
            ItemStack is;
            stacks[r][c] = is = ElementBuilder.getElement(entry);
            if (++c != 8) continue;
            ++r;
            c = 0;
        }
        return stacks;
    }

    private void close(Player p) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((Player)p).closeInventory(), 1L);
    }
}

