/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry;

import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardischemistry.TARDISChemistryRecipeInventory;
import me.eccentric_nz.tardischemistry.compound.CompoundCommand;
import me.eccentric_nz.tardischemistry.constructor.ConstructCommand;
import me.eccentric_nz.tardischemistry.creative.CreativeCommand;
import me.eccentric_nz.tardischemistry.formula.FormulaCommand;
import me.eccentric_nz.tardischemistry.lab.LabCommand;
import me.eccentric_nz.tardischemistry.product.ProductCommand;
import me.eccentric_nz.tardischemistry.reducer.ReduceCommand;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISChemistryCommand
implements CommandExecutor {
    private final TARDIS plugin;
    private final List<String> GUIS = List.of("creative", "construct", "compound", "reduce", "product", "lab");

    public TARDISChemistryCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardischemistry")) {
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (player == null) {
                this.plugin.getMessenger().message(sender, TardisModule.TARDIS, "Command can only be used by a player!");
                return true;
            }
            if (args.length < 2) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return true;
            }
            if (args[0].equalsIgnoreCase("formula") && TARDISPermission.hasPermission(player, "tardis.formula.show")) {
                return new FormulaCommand(this.plugin).show(player, args);
            }
            if (args[0].equalsIgnoreCase("gui")) {
                if (!TARDISPermission.hasPermission(player, "tardis.chemistry.command")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHEMISTRY_CMD_PERM");
                    return true;
                }
                switch (args[1].toLowerCase(Locale.ROOT)) {
                    case "creative": {
                        if (args.length < 3) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                            return true;
                        }
                        return new CreativeCommand(this.plugin).open(player, args);
                    }
                    case "construct": {
                        return new ConstructCommand(this.plugin).build(player);
                    }
                    case "compound": {
                        return new CompoundCommand(this.plugin).create(player);
                    }
                    case "reduce": {
                        return new ReduceCommand(this.plugin).use(player);
                    }
                    case "product": {
                        return new ProductCommand(this.plugin).craft(player);
                    }
                    case "lab": {
                        return new LabCommand(this.plugin).combine(player);
                    }
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("recipe")) {
                if (!TARDISPermission.hasPermission(sender, "tardis.help")) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                    return true;
                }
                String which = args[1].toLowerCase(Locale.ROOT);
                if (!this.GUIS.contains(which)) {
                    this.plugin.getMessenger().message((CommandSender)player, "");
                    return false;
                }
                this.showBlockRecipe(player, which);
                return true;
            }
            return true;
        }
        return false;
    }

    private void showBlockRecipe(Player player, String which) {
        player.closeInventory();
        this.plugin.getTrackerKeeper().getRecipeViewers().add(player.getUniqueId());
        Material surround = switch (which) {
            case "creative" -> Material.DIAMOND;
            case "construct" -> Material.LAPIS_LAZULI;
            case "compound" -> Material.REDSTONE;
            case "reduce" -> Material.GOLD_NUGGET;
            case "product" -> Material.IRON_NUGGET;
            default -> Material.COAL;
        };
        player.openInventory(new TARDISChemistryRecipeInventory(this.plugin, which, surround).getInventory());
    }
}

