/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISSpiral;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.plugin.Plugin;

public class TARDISVoidUpdate {
    private final TARDIS plugin;
    private final int id;
    private int taskID;

    public TARDISVoidUpdate(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
    }

    public void updateBiome() {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", this.id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            String[] cstr = tardis.getChunk().split(":");
            World w = TARDISAliasResolver.getWorldFromAlias(cstr[0]);
            int cx = TARDISNumberParsers.parseInt(cstr[1]);
            int cz = TARDISNumberParsers.parseInt(cstr[2]);
            this.taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new Updater(w, cx, cz), 1L, 20L);
        }
    }

    class Updater
    implements Runnable {
        private final World world;
        private final int cx;
        private final int cz;
        private int idx = 0;

        Updater(World world, int cx, int cz) {
            this.world = world;
            this.cx = cx;
            this.cz = cz;
        }

        @Override
        public void run() {
            Chunk chunk = this.world.getChunkAt(this.cx, this.cz);
            if (!chunk.isLoaded()) {
                chunk.load();
            }
            int sx = (this.cx + TARDISSpiral.SPIRAL.get((int)this.idx).x) * 16;
            int ex = sx + 16;
            int sz = (this.cz + TARDISSpiral.SPIRAL.get((int)this.idx).y) * 16;
            int ez = sz + 16;
            if (this.world.getBlockAt(sx, 64, sz).getBiome().equals((Object)Biome.THE_END)) {
                for (int x = sx; x < ex; ++x) {
                    for (int z = sz; z < ez; ++z) {
                        for (int y = 48; y < 81; y += 2) {
                            this.world.setBiome(x, y, z, Biome.THE_VOID);
                        }
                    }
                }
            }
            ++this.idx;
            if (this.idx == 81) {
                TARDISVoidUpdate.this.plugin.getServer().getScheduler().cancelTask(TARDISVoidUpdate.this.taskID);
                TARDISVoidUpdate.this.taskID = 0;
            }
        }
    }
}

