/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel.dialog;

import com.mojang.datafixers.util.Pair;
import io.papermc.paper.dialog.DialogResponseView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TARDISTerminalDialogProcessor {
    private final TARDIS plugin;
    private final Player player;

    public TARDISTerminalDialogProcessor(TARDIS plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void process(DialogResponseView data) {
        if (data != null) {
            String environment = data.getText("environment");
            Boolean submarine = data.getBoolean("submarine");
            Float x = data.getFloat("x");
            Float z = data.getFloat("z");
            Float multiplier = data.getFloat("multiplier");
            if (environment == null || submarine == null || x == null || z == null || multiplier == null) {
                this.plugin.getMessenger().message((CommandSender)this.player, "Could not read Terminal values!");
                return;
            }
            UUID uuid = this.player.getUniqueId();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, false);
            if (rst.resultSet()) {
                int id = rst.getTardis_id();
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                rsc.resultSet();
                Location location = null;
                switch (environment) {
                    case "CURRENT": {
                        location = rsc.getCurrent().location().clone().add((double)(x.floatValue() * multiplier.floatValue()), 0.0, (double)(z.floatValue() * multiplier.floatValue()));
                        break;
                    }
                    case "NETHER": {
                        if (this.plugin.getConfig().getBoolean("travel.nether") || !this.plugin.getConfig().getBoolean("travel.terminal.redefine")) {
                            World nether = this.getWorld("NETHER", this.player);
                            if (nether == null) break;
                            location = new Location(nether, (double)(x.floatValue() * multiplier.floatValue()), 64.0, (double)(z.floatValue() * multiplier.floatValue()));
                            break;
                        }
                        World alternate = this.plugin.getServer().getWorld(this.plugin.getConfig().getString("travel.terminal.nether", "world"));
                        if (alternate == null) break;
                        location = new Location(alternate, (double)(x.floatValue() * multiplier.floatValue()), 64.0, (double)(z.floatValue() * multiplier.floatValue()));
                        break;
                    }
                    case "THE_END": {
                        if (this.plugin.getConfig().getBoolean("travel.the_end") || !this.plugin.getConfig().getBoolean("travel.terminal.redefine")) {
                            World the_end = this.getWorld("THE_END", this.player);
                            if (the_end == null) break;
                            location = new Location(the_end, (double)(x.floatValue() * multiplier.floatValue()), 64.0, (double)(z.floatValue() * multiplier.floatValue()));
                            break;
                        }
                        World alternate = this.plugin.getServer().getWorld(this.plugin.getConfig().getString("travel.terminal.the_end", "world"));
                        if (alternate == null) break;
                        location = new Location(alternate, (double)(x.floatValue() * multiplier.floatValue()), 64.0, (double)(z.floatValue() * multiplier.floatValue()));
                        break;
                    }
                    default: {
                        World normal = this.getWorld("NORMAL", this.player);
                        if (normal == null) break;
                        location = new Location(normal, (double)(x.floatValue() * multiplier.floatValue()), 64.0, (double)(z.floatValue() * multiplier.floatValue()));
                    }
                }
                if (location == null) {
                    this.plugin.getMessenger().send(this.player, "DEST_SET", !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id));
                    return;
                }
                location.add(this.getRandomAddition(), 0.0, this.getRandomAddition());
                int y = location.getWorld().getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
                location.setY((double)y);
                Location finalLocation = location;
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    Pair<Boolean, Integer> safe = this.safe(finalLocation, rsc.getCurrent().direction(), submarine, this.player);
                    if (((Boolean)safe.getFirst()).booleanValue()) {
                        HashMap<String, Object> set = new HashMap<String, Object>();
                        String ww = !this.plugin.getPlanetsConfig().getBoolean("planets." + finalLocation.getWorld().getName() + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getWorld(finalLocation.getWorld().getName()).getName() : finalLocation.getWorld().getName();
                        set.put("world", ww);
                        set.put("x", finalLocation.getBlockX());
                        set.put("y", safe.getSecond());
                        set.put("z", finalLocation.getBlockZ());
                        set.put("direction", (Object)rsc.getCurrent().direction());
                        set.put("submarine", submarine != false ? 1 : 0);
                        HashMap<String, Object> wheret = new HashMap<String, Object>();
                        wheret.put("tardis_id", id);
                        this.plugin.getQueryFactory().doSyncUpdate("next", set, wheret);
                        this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.TERMINAL));
                        this.plugin.getTrackerKeeper().getRescue().remove(id);
                        this.plugin.getMessenger().send(this.player, "DEST_SET", !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id));
                        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                            new TARDISLand(this.plugin, id, this.player).exitVortex();
                            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(this.player, null, TravelType.TERMINAL, id));
                        }
                        DamageUtility.run(this.plugin, DiskCircuit.INPUT, id, this.player);
                        this.plugin.getMessenger().send(this.player, "DEST_SET", !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id));
                    }
                });
            }
        }
    }

    private double getRandomAddition() {
        double r = TARDISConstants.RANDOM.nextInt(50);
        if (TARDISConstants.RANDOM.nextBoolean()) {
            r = 0.0 - r;
        }
        return r;
    }

    private World getWorld(String environment, Player player) {
        ArrayList<World> allowedWorlds = new ArrayList<World>();
        Set worldlist = this.plugin.getPlanetsConfig().getConfigurationSection("planets").getKeys(false);
        for (String o : worldlist) {
            String env;
            World ww;
            if (!this.plugin.getPlanetsConfig().getBoolean("planets." + o + ".time_travel") || this.plugin.getConfig().getBoolean("travel.per_world_perms") && !TARDISPermission.hasPermission(player, "tardis.travel." + o) || (ww = TARDISAliasResolver.getWorldFromAlias(o)) == null || !(env = ww.getEnvironment().toString()).equals(environment)) continue;
            allowedWorlds.add(ww);
        }
        return !allowedWorlds.isEmpty() ? (World)allowedWorlds.get(TARDISConstants.RANDOM.nextInt(allowedWorlds.size())) : null;
    }

    private Pair<Boolean, Integer> safe(Location location, COMPASS d, boolean submarine, Player p) {
        int safe;
        World world = location.getWorld();
        int blockX = location.getBlockX();
        int blockZ = location.getBlockZ();
        String loc_str = world.getName() + ":" + blockX + ":" + blockZ;
        TARDISTimeTravel tt = new TARDISTimeTravel(this.plugin);
        switch (world.getEnvironment()) {
            case THE_END: {
                int endy = TARDISStaticLocationGetters.getHighestYin3x3(world, blockX, blockZ);
                if (endy > 40 && Math.abs(blockX) > 9 && Math.abs(blockZ) > 9) {
                    Location loc = new Location(world, (double)blockX, 0.0, (double)blockZ);
                    int[] estart = TARDISTimeTravel.getStartLocation(loc, d);
                    int esafe = TARDISTimeTravel.safeLocation(estart[0], endy, estart[2], estart[1], estart[3], world, d);
                    if (esafe == 0) {
                        String save = world.getName() + ":" + blockX + ":" + endy + ":" + blockZ;
                        if (this.plugin.getPluginRespect().getRespect(new Location(world, (double)blockX, (double)endy, (double)blockZ), new Parameters(p, Flag.getNoMessageFlags()))) {
                            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DEST_SET_TERMINAL", save);
                            return new Pair((Object)true, (Object)endy);
                        }
                        this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DEST_PROTECTED", save);
                        return new Pair((Object)false, (Object)-1);
                    }
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DEST_NOT_SAFE", loc_str);
                    return new Pair((Object)false, (Object)-1);
                }
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DEST_NOT_SAFE", loc_str);
                return new Pair((Object)false, (Object)-1);
            }
            case NETHER: {
                if (tt.safeNether(world, blockX, blockZ, d, p)) {
                    int nethery = this.plugin.getUtils().getHighestNetherBlock(world, blockX, blockZ);
                    String save = world.getName() + ":" + blockX + ":" + nethery + ":" + blockZ;
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DEST_SET_TERMINAL", save);
                    return new Pair((Object)true, (Object)nethery);
                }
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DEST_NOT_SAFE", loc_str);
                return new Pair((Object)false, (Object)-1);
            }
        }
        Location loc = new Location(world, (double)blockX, 0.0, (double)blockZ);
        int[] start = TARDISTimeTravel.getStartLocation(loc, d);
        int starty = TARDISStaticLocationGetters.getHighestYin3x3(world, blockX, blockZ);
        if (starty <= 0) {
            starty = 1;
        }
        loc.setY((double)starty);
        if (submarine && TARDISStaticUtils.isOceanBiome(loc.getBlock().getBiome())) {
            Location subloc = tt.submarine(loc.getBlock(), d);
            if (subloc != null) {
                safe = 0;
                starty = subloc.getBlockY();
            } else {
                safe = 1;
            }
        } else {
            safe = TARDISTimeTravel.safeLocation(start[0], starty, start[2], start[1], start[3], world, d);
        }
        if (safe == 0) {
            String save = world.getName() + ":" + blockX + ":" + starty + ":" + blockZ;
            if (this.plugin.getPluginRespect().getRespect(new Location(world, (double)blockX, (double)starty, (double)blockZ), new Parameters(p, Flag.getNoMessageFlags()))) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DEST_SET_TERMINAL", save);
                return new Pair((Object)true, (Object)starty);
            }
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DEST_PROTECTED", save);
            return new Pair((Object)false, (Object)-1);
        }
        this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DEST_NOT_SAFE", loc_str);
        return new Pair((Object)false, (Object)-1);
    }
}

