/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISEmergencyRelocation;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.travel.TARDISTerminalInventory;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISTerminalListener
implements Listener {
    private final TARDIS plugin;
    private final HashMap<UUID, Current> terminalUsers = new HashMap();
    private final HashMap<UUID, String> terminalDestination = new HashMap();
    private final HashMap<UUID, Integer> terminalStep = new HashMap();
    private final HashMap<UUID, Integer> terminalIDs = new HashMap();
    private final HashMap<UUID, Integer> terminalWorlds = new HashMap();
    private final HashMap<UUID, Boolean> terminalSub = new HashMap();

    public TARDISTerminalListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onDestTerminalClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISTerminalInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, false);
        if (!rst.resultSet()) {
            return;
        }
        InventoryView view = event.getView();
        switch (slot) {
            case 1: {
                this.terminalStep.put(uuid, 10);
                break;
            }
            case 3: {
                this.terminalStep.put(uuid, 25);
                break;
            }
            case 5: {
                this.terminalStep.put(uuid, 50);
                break;
            }
            case 7: {
                this.terminalStep.put(uuid, 100);
                break;
            }
            case 9: {
                this.setSlots(view, 10, 16, false, "X", true, uuid);
                break;
            }
            case 17: {
                this.setSlots(view, 10, 16, true, "X", true, uuid);
                break;
            }
            case 18: {
                this.setSlots(view, 19, 25, false, "Z", true, uuid);
                break;
            }
            case 26: {
                this.setSlots(view, 19, 25, true, "Z", true, uuid);
                break;
            }
            case 27: {
                this.setSlots(view, 28, 34, false, "Multiplier", false, uuid);
                break;
            }
            case 35: {
                this.setSlots(view, 28, 34, true, "Multiplier", false, uuid);
                break;
            }
            case 36: {
                this.terminalWorlds.put(uuid, this.terminalWorlds.containsKey(uuid) ? this.terminalWorlds.get(uuid) + 1 : 0);
                this.setCurrent(view, player, 36);
                break;
            }
            case 38: {
                this.terminalWorlds.put(uuid, this.terminalWorlds.containsKey(uuid) ? this.terminalWorlds.get(uuid) + 1 : 0);
                this.setCurrent(view, player, 38);
                break;
            }
            case 40: {
                this.terminalWorlds.put(uuid, this.terminalWorlds.containsKey(uuid) ? this.terminalWorlds.get(uuid) + 1 : 0);
                this.setCurrent(view, player, 40);
                break;
            }
            case 42: {
                this.terminalWorlds.put(uuid, this.terminalWorlds.containsKey(uuid) ? this.terminalWorlds.get(uuid) + 1 : 0);
                this.setCurrent(view, player, 42);
                break;
            }
            case 44: {
                this.toggleSubmarine(view, player);
                break;
            }
            case 46: {
                this.checkSettings(view, player);
                break;
            }
            case 49: {
                if (this.terminalDestination.containsKey(uuid)) {
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    String[] data = this.terminalDestination.get(uuid).split(":");
                    String ww = !this.plugin.getPlanetsConfig().getBoolean("planets." + data[0] + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getWorld(data[0]).getName() : data[0];
                    set.put("world", ww);
                    set.put("x", data[1]);
                    set.put("y", data[2]);
                    set.put("z", data[3]);
                    set.put("direction", this.terminalUsers.get(uuid).direction().toString());
                    set.put("submarine", this.terminalSub.containsKey(uuid) ? 1 : 0);
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("tardis_id", this.terminalIDs.get(uuid));
                    this.plugin.getQueryFactory().doSyncUpdate("next", set, wheret);
                    this.plugin.getTrackerKeeper().getHasDestination().put(this.terminalIDs.get(uuid), new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.TERMINAL));
                    this.plugin.getTrackerKeeper().getRescue().remove(this.terminalIDs.get(uuid));
                    this.close(player);
                    this.plugin.getMessenger().send(player, "DEST_SET", !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.terminalIDs.get(uuid)));
                    if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.terminalIDs.get(uuid))) {
                        new TARDISLand(this.plugin, this.terminalIDs.get(uuid), player).exitVortex();
                        this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.TERMINAL, this.terminalIDs.get(uuid)));
                    }
                    DamageUtility.run(this.plugin, DiskCircuit.INPUT, this.terminalIDs.get(uuid), player);
                    break;
                }
                ItemStack is = view.getItem(49);
                ItemMeta im = is.getItemMeta();
                im.lore(List.of(Component.text((String)"No valid destination has been set!")));
                is.setItemMeta(im);
                break;
            }
            case 52: {
                this.close(player);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onOpenTerminal(InventoryOpenEvent event) {
        Inventory inv = event.getInventory();
        InventoryHolder holder = inv.getHolder(false);
        if (holder instanceof TARDISTerminalInventory) {
            ResultSetPlayerPrefs rsp;
            Player player = (Player)event.getPlayer();
            UUID uuid = player.getUniqueId();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, false);
            if (rst.resultSet()) {
                int id = rst.getTardis_id();
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                if (rsc.resultSet()) {
                    this.terminalUsers.put(uuid, rsc.getCurrent());
                    this.terminalIDs.put(uuid, id);
                } else {
                    new TARDISEmergencyRelocation(this.plugin).relocate(id, player);
                    this.close(player);
                    return;
                }
            }
            if ((rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString())).resultSet()) {
                String sub = rsp.isSubmarineOn() ? "true" : "false";
                ItemStack is = inv.getItem(44);
                ItemMeta im = is.getItemMeta();
                im.lore(List.of(Component.text((String)sub)));
                is.setItemMeta(im);
            }
        }
    }

    private int getSlot(InventoryView view, int min, int max) {
        for (int i = min; i <= max; ++i) {
            if (view.getItem(i) == null) continue;
            return i;
        }
        return min;
    }

    private int getNewSlot(int slot, int min, int max, boolean pos) {
        if (pos) {
            return slot < max ? slot + 1 : max;
        }
        return slot > min ? slot - 1 : min;
    }

    private List<Component> getLoreValue(int max, int slot, boolean signed, UUID uuid) {
        int step = this.terminalStep.getOrDefault(uuid, 50);
        int val = max - slot;
        Object str = switch (val) {
            case 0 -> {
                if (signed) {
                    yield "+" + 3 * step;
                }
                yield "x7";
            }
            case 1 -> {
                if (signed) {
                    yield "+" + 2 * step;
                }
                yield "x6";
            }
            case 2 -> {
                if (signed) {
                    yield "+" + step;
                }
                yield "x5";
            }
            case 4 -> {
                if (signed) {
                    yield "-" + step;
                }
                yield "x3";
            }
            case 5 -> {
                if (signed) {
                    yield "-" + 2 * step;
                }
                yield "x2";
            }
            case 6 -> {
                if (signed) {
                    yield "-" + 3 * step;
                }
                yield "x1";
            }
            default -> signed ? "0" : "x4";
        };
        return List.of(Component.text((String)str));
    }

    private int getValue(int max, int slot, boolean signed, UUID uuid) {
        int step = this.terminalStep.getOrDefault(uuid, 50);
        int val = max - slot;
        return switch (val) {
            case 0 -> {
                if (signed) {
                    yield 3 * step;
                }
                yield 7;
            }
            case 1 -> {
                if (signed) {
                    yield 2 * step;
                }
                yield 6;
            }
            case 2 -> {
                if (signed) {
                    yield step;
                }
                yield 5;
            }
            case 4 -> {
                if (signed) {
                    yield -step;
                }
                yield 3;
            }
            case 5 -> {
                if (signed) {
                    yield -(2 * step);
                }
                yield 2;
            }
            case 6 -> {
                if (signed) {
                    yield -(3 * step);
                }
                yield 1;
            }
            default -> signed ? 0 : 4;
        };
    }

    private void setSlots(InventoryView view, int min, int max, boolean pos, String row, boolean signed, UUID uuid) {
        int affected_slot = this.getSlot(view, min, max);
        int new_slot = this.getNewSlot(affected_slot, min, max, pos);
        view.setItem(affected_slot, null);
        ItemStack is = switch (row) {
            case "X" -> ItemStack.of((Material)Material.LIGHT_BLUE_WOOL, (int)1);
            case "Z" -> ItemStack.of((Material)Material.YELLOW_WOOL, (int)1);
            default -> ItemStack.of((Material)Material.PURPLE_WOOL, (int)1);
        };
        ItemMeta im = is.getItemMeta();
        im.displayName((Component)Component.text((String)row));
        List<Component> lore = this.getLoreValue(max, new_slot, signed, uuid);
        im.lore(lore);
        is.setItemMeta(im);
        view.setItem(new_slot, is);
    }

    private void setCurrent(InventoryView view, Player p, int slot) {
        int[] slots;
        String current = this.terminalUsers.get(p.getUniqueId()).location().getWorld().getName();
        current = !this.plugin.getPlanetsConfig().getBoolean("planets." + current + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getAlias(current) : TARDISAliasResolver.getWorldAlias(current);
        for (int i : slots = new int[]{36, 38, 40, 42}) {
            List<TextComponent> lore = null;
            ItemStack is = view.getItem(i);
            ItemMeta im = is.getItemMeta();
            if (i == slot) {
                switch (slot) {
                    case 38: {
                        lore = List.of(Component.text((String)this.getWorld("NORMAL", current, p)));
                        break;
                    }
                    case 40: {
                        if (this.plugin.getConfig().getBoolean("travel.nether") || !this.plugin.getConfig().getBoolean("travel.terminal.redefine")) {
                            lore = List.of(Component.text((String)this.getWorld("NETHER", current, p)));
                            break;
                        }
                        lore = List.of(Component.text((String)this.getWorld(this.plugin.getConfig().getString("travel.terminal.nether"), current, p)));
                        break;
                    }
                    case 42: {
                        if (this.plugin.getConfig().getBoolean("travel.the_end") || !this.plugin.getConfig().getBoolean("travel.terminal.redefine")) {
                            lore = List.of(Component.text((String)this.getWorld("THE_END", current, p)));
                            break;
                        }
                        lore = List.of(Component.text((String)this.getWorld(this.plugin.getConfig().getString("travel.terminal.the_end"), current, p)));
                        break;
                    }
                    default: {
                        lore = List.of(Component.text((String)current));
                    }
                }
            }
            im.lore(lore);
            is.setItemMeta(im);
        }
    }

    private void toggleSubmarine(InventoryView view, Player p) {
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, p.getUniqueId().toString());
        if (rsp.resultSet()) {
            String bool = rsp.isSubmarineOn() ? "false" : "true";
            ItemStack is = view.getItem(44);
            ItemMeta im = is.getItemMeta();
            im.lore(List.of(Component.text((String)bool)));
            is.setItemMeta(im);
            int tf = rsp.isSubmarineOn() ? 0 : 1;
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("submarine_on", tf);
            HashMap<String, Object> wheret = new HashMap<String, Object>();
            wheret.put("pp_id", rsp.getPp_id());
            this.plugin.getQueryFactory().doUpdate("player_prefs", set, wheret);
        }
    }

    private String getWorld(String e, String this_world, Player p) {
        String world;
        ArrayList allowedWorlds = new ArrayList();
        Set worldlist = this.plugin.getPlanetsConfig().getConfigurationSection("planets").getKeys(false);
        worldlist.forEach(o -> {
            World ww = TARDISAliasResolver.getWorldFromAlias(o);
            if (ww != null) {
                String env = ww.getEnvironment().toString();
                if (e.equalsIgnoreCase(env)) {
                    if (this.plugin.getConfig().getBoolean("travel.include_default_world") || !this.plugin.getConfig().getBoolean("creation.default_world")) {
                        if (this.plugin.getPlanetsConfig().getBoolean("planets." + o + ".time_travel")) {
                            allowedWorlds.add(o);
                        }
                    } else if (!o.equals(this.plugin.getConfig().getString("creation.default_world_name")) && this.plugin.getPlanetsConfig().getBoolean("planets." + o + ".time_travel")) {
                        allowedWorlds.add(o);
                    }
                }
                if (!(this_world == null || allowedWorlds.size() <= 1 && this.plugin.getPlanetsConfig().getBoolean("planets." + this_world + ".time_travel"))) {
                    allowedWorlds.remove(this_world);
                }
                if (allowedWorlds.size() > 1 && this.plugin.getConfig().getBoolean("travel.per_world_perms") && !TARDISPermission.hasPermission(p, "tardis.travel." + o)) {
                    allowedWorlds.remove(this_world);
                }
            }
        });
        if (!allowedWorlds.isEmpty()) {
            int rw = this.terminalWorlds.get(p.getUniqueId());
            if (rw > allowedWorlds.size() - 1) {
                rw = 0;
                this.terminalWorlds.put(p.getUniqueId(), 0);
            }
            world = (String)allowedWorlds.get(rw);
        } else {
            world = this_world;
        }
        return !this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getAlias(world) : TARDISAliasResolver.getWorldAlias(world);
    }

    private void checkSettings(InventoryView view, Player p) {
        UUID uuid = p.getUniqueId();
        int slotm = this.getValue(34, this.getSlot(view, 28, 34), false, uuid) * this.plugin.getConfig().getInt("travel.terminal_step");
        int slotx = this.getValue(16, this.getSlot(view, 10, 16), true, uuid) * slotm;
        int slotz = this.getValue(25, this.getSlot(view, 19, 25), true, uuid) * slotm;
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        COMPASS d = this.terminalUsers.get(uuid).direction();
        int[] slots = new int[]{36, 38, 40, 42};
        boolean found = false;
        block4: for (int i : slots) {
            String world;
            if (!view.getItem(i).getItemMeta().hasLore() || (world = ComponentUtils.stripColour((Component)view.getItem(i).getItemMeta().lore().getFirst())).equals("No permission")) continue;
            found = true;
            World w = !this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getWorld(world) : TARDISAliasResolver.getWorldFromAlias(world);
            World.Environment e = w.getEnvironment();
            if (this.plugin.getPlanetsConfig().getBoolean("planets." + w.getName() + ".false_nether")) {
                e = World.Environment.NETHER;
            }
            TARDISTimeTravel tt = new TARDISTimeTravel(this.plugin);
            if (world.equals(this.terminalUsers.get(uuid).location().getWorld().getName())) {
                slotx += this.terminalUsers.get(uuid).location().getBlockX();
                slotz += this.terminalUsers.get(uuid).location().getBlockZ();
            }
            String loc_str = world + ":" + slotx + ":" + slotz;
            switch (e) {
                case THE_END: {
                    int endy = TARDISStaticLocationGetters.getHighestYin3x3(w, slotx, slotz);
                    if (endy > 40 && Math.abs(slotx) > 9 && Math.abs(slotz) > 9) {
                        Location loc = new Location(w, (double)slotx, 0.0, (double)slotz);
                        int[] estart = TARDISTimeTravel.getStartLocation(loc, d);
                        int esafe = TARDISTimeTravel.safeLocation(estart[0], endy, estart[2], estart[1], estart[3], w, d);
                        if (esafe == 0) {
                            String save = world + ":" + slotx + ":" + endy + ":" + slotz;
                            if (this.plugin.getPluginRespect().getRespect(new Location(w, (double)slotx, (double)endy, (double)slotz), new Parameters(p, Flag.getNoMessageFlags()))) {
                                this.terminalDestination.put(uuid, save);
                                lore.add(Component.text((String)save));
                                lore.add(Component.text((String)"is a valid destination!"));
                                continue block4;
                            }
                            lore.add(Component.text((String)save));
                            lore.add(Component.text((String)"is a protected location."));
                            lore.add(Component.text((String)"Try again!"));
                            continue block4;
                        }
                        lore.add(Component.text((String)loc_str));
                        lore.add(Component.text((String)"is not safe!"));
                        continue block4;
                    }
                    lore.add(Component.text((String)loc_str));
                    lore.add(Component.text((String)"is not safe!"));
                    continue block4;
                }
                case NETHER: {
                    if (tt.safeNether(w, slotx, slotz, d, p)) {
                        String save = world + ":" + slotx + ":" + this.plugin.getUtils().getHighestNetherBlock(w, slotx, slotz) + ":" + slotz;
                        this.terminalDestination.put(uuid, save);
                        lore.add(Component.text((String)save));
                        lore.add(Component.text((String)"is a valid destination!"));
                        continue block4;
                    }
                    lore.add(Component.text((String)loc_str));
                    lore.add(Component.text((String)"is not safe!"));
                    continue block4;
                }
                default: {
                    int safe;
                    Location loc = new Location(w, (double)slotx, 0.0, (double)slotz);
                    int[] start = TARDISTimeTravel.getStartLocation(loc, d);
                    int starty = TARDISStaticLocationGetters.getHighestYin3x3(w, slotx, slotz);
                    if (starty <= 0) {
                        starty = 1;
                    }
                    ItemMeta subim = view.getItem(44).getItemMeta();
                    loc.setY((double)starty);
                    if (subim.hasLore() && ComponentUtils.stripColour((Component)subim.lore().getFirst()).equals("true") && TARDISStaticUtils.isOceanBiome(loc.getBlock().getBiome())) {
                        Location subloc = tt.submarine(loc.getBlock(), d);
                        if (subloc != null) {
                            safe = 0;
                            starty = subloc.getBlockY();
                            this.terminalSub.put(uuid, true);
                        } else {
                            safe = 1;
                        }
                    } else {
                        safe = TARDISTimeTravel.safeLocation(start[0], starty, start[2], start[1], start[3], w, d);
                    }
                    if (safe == 0) {
                        String save = world + ":" + slotx + ":" + starty + ":" + slotz;
                        if (this.plugin.getPluginRespect().getRespect(new Location(w, (double)slotx, (double)starty, (double)slotz), new Parameters(p, Flag.getNoMessageFlags()))) {
                            this.terminalDestination.put(uuid, save);
                            lore.add(Component.text((String)save));
                            lore.add(Component.text((String)"is a valid destination!"));
                            continue block4;
                        }
                        lore.add(Component.text((String)save));
                        lore.add(Component.text((String)"is a protected location."));
                        lore.add(Component.text((String)"Try again!"));
                        continue block4;
                    }
                    lore.add(Component.text((String)loc_str));
                    lore.add(Component.text((String)"is not safe!"));
                }
            }
        }
        if (!found) {
            lore.add(Component.text((String)"You need to select a world!"));
        }
        ItemStack is = view.getItem(46);
        ItemMeta im = is.getItemMeta();
        im.lore(lore);
        is.setItemMeta(im);
    }

    private void close(Player p) {
        UUID uuid = p.getUniqueId();
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            this.terminalUsers.remove(uuid);
            this.terminalStep.remove(uuid);
            this.terminalDestination.remove(uuid);
            this.terminalSub.remove(uuid);
            this.terminalWorlds.remove(uuid);
            p.closeInventory();
        }, 1L);
    }
}

